/*


    ========== licence begin GPL
    Copyright (C) 2002-2003 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end


*/

package com.sap.dbtech.jdbc.translators;

import java.sql.*;
import com.sap.dbtech.util.*;
/**
 *
 */
class BooleanTranslator extends BinaryDataTranslator {
    /**
     *
     */
    BooleanTranslator(
        int mode,
        int ioType,
        int dataType,
        int len,
        int ioLen,
        int bufpos,
        boolean readOnly, 
        boolean autoIncr)
    {
        super (mode, ioType, dataType, len, ioLen, bufpos, readOnly, autoIncr);
    }
    /**
     *
     * @return java.math.BigDecimal
     */
    public java.math.BigDecimal getBigDecimal (
        SQLParamController controller,
        StructuredMem mem)
    throws SQLException
    {
        java.math.BigDecimal result;
        boolean isTrue;

        if (this.isNull (controller, mem)) {
            return null;
        }
        isTrue = this.getBoolean (controller, mem);
        if (isTrue) {
            result = new java.math.BigDecimal (1);
        }
        else {
            result = new java.math.BigDecimal (0);
        }
        return result;
    }
    /**
     *
     * @return java.lang.String
     */
    public boolean getBoolean (
        SQLParamController controller,
        StructuredMem mem)
    throws SQLException
    {
        boolean result = false;
        byte raw;

        if (!this.isNull (controller, mem)) {
            raw = mem.getInt1(this.bufpos);
            if (raw == 0x00) {
                result = false;
            }
            else {
                result = true;
            }
        }
        return result;
    }
    /**
     *
     */
    public byte
    getByte (
        SQLParamController controller,
        StructuredMem mem)
    throws SQLException
    {
        return this.getBoolean (controller, mem) ? (byte) 1 : (byte) 0;
    }
    /**
     *
     */
    public float
    getFloat (
        SQLParamController controller,
        StructuredMem mem)
    throws SQLException
    {
        return this.getBoolean (controller, mem) ? (float) 1 : (float) 0;
    }
    /**
     *
     */
    public double
    getDouble (
        SQLParamController controller,
        StructuredMem mem)
    throws SQLException
    {
        return this.getBoolean (controller, mem) ? (double) 1 : (double) 0;
    }
    /**
     *
     * @return java.lang.Object
     */
    public Object getObject (
        SQLParamController controller,
        StructuredMem mem)
    throws SQLException
    {
        Boolean result;
        boolean isTrue;

        if (this.isNull (controller, mem)) {
            return null;
        }
        isTrue = this.getBoolean (controller, mem);
        if (isTrue) {
            result = Boolean.TRUE;
        }
        else {
            result = Boolean.FALSE;
        }
        return result;
    }
    /**
     *
     */
    public int
    getInt (
        SQLParamController controller,
        StructuredMem mem)
    throws SQLException
    {
        return this.getBoolean (controller, mem) ? 1 : 0;
    }
    /**
     *
     */
    public long
    getLong (
        SQLParamController controller,
        StructuredMem mem)
    throws SQLException
    {
        return this.getBoolean (controller, mem) ? 1 : 0;
    }
    /**
     *
     */
    public short
    getShort (
        SQLParamController controller,
        StructuredMem mem)
    throws SQLException
    {
        return this.getBoolean (controller, mem) ? (short) 1 : (short) 0;
    }
    /**
     *
     * @param newValue boolean
     */
    public Object transBooleanForInput (boolean newValue) {
        byte [] result = new byte [1];

        result [0] = (newValue ? (byte) 1 : (byte) 0);
        return result;
    }
    /**
     *
     * @param obj java.lang.Object
     */
    public Object transSpecificForInput (Object obj)
    throws ConversionExceptionSapDB
    {
        Object result = null;

        if (obj instanceof Boolean) {
            result = this.transBooleanForInput (((Boolean) obj).booleanValue ());
        }
        else if (obj instanceof Number) {
            int numValue = ((Number) obj).intValue ();
            if (numValue == 0) {
                result = this.transBooleanForInput(false);
            }
            else {
                result = this.transBooleanForInput(true);
            }
        }
        else if (obj instanceof java.util.Date) {
            throw this.newSetException (obj.getClass ().getName ());
        }
        return result;
    }
    /**
     *
     * @param val java.lang.String
     */
    public Object transStringForInput (String val) {
        Boolean boolObj;

        if (val == null) {
            return null;
        }
        boolObj = new Boolean (val);
        return this.transBooleanForInput (boolObj.booleanValue ());
    }
}