/*
 * 
 * 
 * ========== licence begin GPL
    Copyright (C) 2002-2003 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end
 * 
 *  
 */
package com.sap.dbtech.jdbc.translators;

import java.io.*;

public class InputStreamFilter extends java.io.InputStream
{
    private int maxlength;

    private InputStream ips;

    private int readlength = 0;
    private int markedlength = 0;
    
    public InputStreamFilter(InputStream ips, int length)
    {
        this.maxlength = length;
        this.ips = ips;
    }

    public int read() throws java.io.IOException
    {
        if (maxlength <= readlength++)
            return -1;
        else
            return ips.read();
    }

    public int read(byte[] b, int off, int len) throws java.io.IOException
    {
        if (b == null) {
            throw new NullPointerException();
        } else if ((off < 0) || (off > b.length) || (len < 0)
                || ((off + len) > b.length) || ((off + len) < 0)) {
            throw new IndexOutOfBoundsException();
        }
        if (readlength >= maxlength) {
            return -1;
        }
        if (readlength + len > maxlength) {
            len = maxlength - readlength;
        }
        if (len <= 0) {
            return 0;
        }
        len = this.ips.read(b, off, len);
        readlength += len;
        return len;
    }
    
    public boolean markSupported()
    {
        return ips.markSupported();
    }
    
    public void mark(int readlimit)
    {
        ips.mark(readlimit);
        this.markedlength = this.readlength;
    }
    
    public void reset() throws IOException
    {
        ips.reset();
        this.readlength = this.markedlength;
    }
    
    public void close() throws IOException
    {
        ips.close();        
    }
    
    public int available() throws IOException
    {
        return ips.available();
    }
}