/*


    ========== licence begin GPL
    Copyright (C) 2002-2003 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end


*/

package com.sap.dbtech.jdbc.translators;

import com.sap.dbtech.jdbc.packet.DataPart;
import com.sap.dbtech.util.*;
import java.sql.Date;
import java.sql.SQLException;


/**
 * Title:        SAP DB JDBC Driver 2.0
 * Description:  Implementation of a JDBC Driver for SAP DB
 * Copyright:    Copyright (c) 2001
 * Company:      SAP AG
 * @author
 * @version 1.0
 */

public class UnicodeDateTranslator extends DateTranslator {

  public UnicodeDateTranslator(
        int mode,
        int ioType,
        int dataType,
        int len,
        int ioLen,
        int bufpos, 
        boolean readOnly, 
        boolean autoIncr)
    {
        super (mode, ioType, dataType, len, ioLen, bufpos, readOnly, autoIncr);

    }
        /**
     *
     * @return java.lang.String
     */
    public String getString (
            SQLParamController controller,
            StructuredMem mem) throws SQLException
    {
        String result = null;
        if (!this.isNull (controller, mem))
            result = mem.getString(this.bufpos, this.physicalLength - 1);
        return result;
    }
        /**
     *
     * @return java.sql.Date
     */
    public Date getDate (
        SQLParamController controller,
        StructuredMem mem,
        java.util.Calendar cal) throws SQLException
    {
        byte[] raw;
        Date result = null;

        if (!this.isNull (controller, mem)) {
            raw = mem.getBytes(this.bufpos, this.physicalLength - 1);

            int year=((int)raw[1]-'0')*1000;
            year +=((int)raw[3]-'0')*100;
            year +=((int)raw[5]-'0')*10;
            year +=((int)raw[7]-'0');

            int month=((int)raw[11]-'0')*10;
            month +=((int)raw[13]-'0');

            int day=((int)raw[17]-'0')*10;
            day +=((int)raw[19]-'0');

            if (cal == null)
              result = new Date(year-1900,month-1,day);
            else {
              cal.clear();
              cal.set(year,month-1,day,0,0,0);
              result = DBTechTranslator.CalendarUtil.getDateFromCalendar(cal);
            }
        }
        return result;
    }
    /**
     *
     * @param dataPart com.sap.dbtech.jdbc.packet.DataPart
     * @param data java.lang.Object
     */
    protected void putSpecific (
        DataPart dataPart,
        Object data)
    {
        dataPart.putDefineByte((byte) 1, this.bufpos - 1);
        dataPart.putUnicodeBytes ((byte []) data, this.bufpos, this.physicalLength - 1);
    }
        /**
     *
     * @param newValue java.lang.String
     */
    public Object transDateForInput (Date arg, java.util.Calendar cal)
    throws java.sql.SQLException
    {
        if (arg == null) {
            return null;
        }
        byte [] chars = (byte[]) super.transDateForInput(arg, cal);
        byte [] bytes = UnicodeUtil.bytes2BigUnicode (chars);
        this.checkFieldLimits (bytes.length);
        return bytes;
    }
}