package com.sap.dbtech.jdbc.translators;

/*!
 ========== licence begin GPL
    Copyright (C) 2002-2003 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end
 */

import java.io.InputStream;
import java.io.Reader;
import java.sql.Clob;
import java.sql.SQLException;

import com.sap.dbtech.jdbc.packet.DataPart;
import com.sap.dbtech.util.StructuredMem;

/**
 * Translator for LONG arguments of DB Procedures written in the internal
 * procedural language.
 */
public class UnicodeProcedureStreamTranslator extends ProcedureStreamTranslator {

    /**
     * @param mode
     * @param ioType
     * @param dataType
     * @param len
     * @param ioLen
     * @param bufpos
     * @param readOnly
     * @param autoIncre
     */
    UnicodeProcedureStreamTranslator(int mode, int ioType, int dataType,
            int len, int ioLen, int bufpos, boolean readOnly, boolean autoIncre) {
        super(mode, ioType, dataType, len, ioLen, bufpos, readOnly, autoIncre);
        // TODO Auto-generated constructor stub
    }
    public int getColumnDisplaySize() {
        return 1073741824;
    }

    public Object transStringForInput(String val) throws SQLException {
        if (val == null) {
            return null;
        } else {
            return new UnicodeProcedurePutval(this, val.toCharArray());
        }
    }

    public Object transCharacterStreamForInput(java.io.Reader reader, int length)
            throws SQLException {
        if (reader == null) {
            return null;
        } else {
            return new UnicodeProcedurePutval(this, reader, length);
        }
    }

    public InputStream getAsciiStream(SQLParamController controller,
            StructuredMem mem, StructuredMem longData) throws SQLException {
        Reader reader = this.getCharacterStream(controller, mem, longData);
        if (reader == null) {
            return null;
        }
        return new ReaderInputStream(reader, false);
    }

    public Reader getCharacterStream(SQLParamController controller,
            StructuredMem mem, StructuredMem longData) throws SQLException {
        java.io.Reader result = null;
        AbstractGetval getval;
        byte[] descriptor;

        if (!this.isNull(controller, mem)) {
            descriptor = mem.getBytes(this.bufpos, this.logicalLength);
            if (descriptorIsNull(descriptor)) {
                return null;
            }
            if (com.sap.dbtech.jdbc.DriverSapDB.isJDBC20) {
                getval = new GetvalUnicodeClob(controller.getConnectionSapDB(),
                        descriptor, longData, this.isUnicodeColumn());
            } else {
                getval = new GetvalUnicode(controller.getConnectionSapDB(),
                        descriptor, longData, this.isUnicodeColumn());
            }
            result = getval.getCharacterStream();
        }
        return result;
    }

    public Clob getClob(SQLParamController controller, StructuredMem mem,
            StructuredMem longData) throws SQLException {
        GetvalUnicodeClob result = null;
        byte[] descriptor;

        if (!this.isNull(controller, mem)) {
            descriptor = mem.getBytes(this.bufpos, this.logicalLength);
            if (descriptorIsNull(descriptor)) {
                return null;
            }
            result = new GetvalUnicodeClob(controller.getConnectionSapDB(),
                    descriptor, longData, this.isUnicodeColumn());
        }
        return result;
    }
    
    public Object transAsciiStreamForInput(java.io.InputStream stream,
            int length) throws SQLException {

        if (stream == null) {
            return null;
        }
        java.io.Reader reader = new java.io.InputStreamReader (stream);
        return this.transCharacterStreamForInput (reader, length);
   }
}
