/*


    ========== licence begin GPL
    Copyright (C) 2002-2003 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end


*/

package com.sap.dbtech.rte.comm;

import com.sap.dbtech.vsp001.*;
/**
 * provides information about the cause of a communication failure
 */
class CommunicationException
    extends RTEException
{
    /**
     * create a new exception with specified code
     * @param rc int
     */
    public CommunicationException (int rc) {
        super (mapRC (rc));
    }
    /**
     * maps the RTE specific error code to a string
     * @return java.lang.String
     * @param rc int
     */
    private static String mapRC (int rc) {
        String result = "Error";

        switch (rc) {
                case CommError.Notok_C:
                    result = "Communication Error";
                    break;
                case CommError.Tasklimit_C:
                    result = "Tasklimit";
                    break;
                case CommError.Timeout_C:
                    result = "Timeout";
                    break;
                case CommError.Crash_C:
                    result = "Crash";
                    break;
                case CommError.StartRequired_C:
                    result = "Start required";
                    break;
                case CommError.Shutdown_C:
                    result = "Shutdown";
                    break;
                case CommError.SendLineDown_C:
                    result = "Send line down";
                    break;
                case CommError.ReceiveLineDown_C:
                    result = "Receive line down";
                    break;
                case CommError.PacketLimit_C:
                    result = "Packet limit";
                    break;
                case CommError.Released_C:
                    result = "Released";
                    break;
                default:
                    result = "Communication Error, code " + String.valueOf (rc);
        }
        return result;
    }
}
