/*


    ========== licence begin GPL
    Copyright (C) 2002-2003 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end


*/

package com.sap.dbtech.rte.comm;

import com.sap.dbtech.util.*;
/**
 * the public interface used by clients to communicate with SAP DB servers.
 */
public abstract class JdbcCommunication {
    /**
     * checks whether challenge response authentication is available or not
     * @return boolean
     * @exception com.sap.dbtech.rte.comm.RTEException.
     */
    public abstract boolean isChallengeResponseSupported () throws java.sql.SQLException;
    /**
     * cancels a pending request.
     */
    public abstract void cancel () throws java.sql.SQLException;
    /**
     * does request and receive in one method call.
     * @return com.sap.dbtech.util.StructuredMem
     * @param len int
     * @exception com.sap.dbtech.rte.comm.RTEException.
     */
    public StructuredMem execute (StructuredMem userPacket, int len) throws RTEException {
        this.request (userPacket, len);
        return this.receive ();
    }
    /**
     * gets a new request packet.
     * @return StructuredMem
     */
    public StructuredMem getRequestPacket ()
    throws RTEException
    {
        return null;
    }
    /**
     * test whether the connection is still valid.
     * @return boolean
     */
    abstract public boolean isConnected ();
    /**
     * blocks while waiting for a reply
     * @return StructuredMem
     * @exception com.sap.dbtech.rte.comm.RTEException.
     */
    abstract public StructuredMem receive () throws RTEException;
    /**
     * tries to reconnect after a timeout.
     * @exception com.sap.dbtech.rte.comm.RTEException.
     */
    public void reconnect () throws RTEException {
    }
    /**
     * closes the connection.
     */
    public abstract void release ();
    /**
     * send a new request to the server.
     * @param userPacket StructuredMem
     * @param len int
     * @exception com.sap.dbtech.rte.comm.RTEException.
     */
    public abstract void request (StructuredMem userPacket, int len) throws RTEException;
}
