# ------------------------------------------------------------------------------
#
# Converter Descriptions
#
# ------------------------------------------------------------------------------
#
#
#    ========== licence begin  GPL
#    Copyright (c) 2000-2005 SAP AG
#
#    This program is free software; you can redistribute it and/or
#    modify it under the terms of the GNU General Public License
#    as published by the Free Software Foundation; either version 2
#    of the License, or (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#    ========== licence end

regex(.*\.cpp$)    -except

# -------------------------------------------------------------------------------------
# Errors and messages:
# -------------------------------------------------------------------------------------

Converter_Messages.genmsg           ascii

Converter_Messages.hpp              inc=SAPDBErr_MessageList.hpp

Converter_Exception.hpp             inc=SAPDBErr_MessageList.hpp


Converter_MapError.hpp             inc=Converter_Exception.hpp,\
                                       SAPDB_ToString.hpp,\
                                       Converter_Types.hpp,\
                                       Data_Types.hpp,\
                                       Converter_Messages.hpp

# -------------------------------------------------------------------------------------
# Interfaces and basic types:
# -------------------------------------------------------------------------------------
#
Converter_Version.hpp               inc=SAPDB_Types.hpp,\
                                        SAPDB_EnhancedTypes.hpp

Converter_Types.hpp                 inc=Kernel_Common.hpp,\
                                        Converter_Version.hpp,\
                                        SAPDB_EnhancedTypes.hpp,\
                                        SAPDBDiag_CheckTopic.hpp,\
                                        SAPDBTrace_Topic.hpp,\
                                        SAPDBTrace_Stream.hpp

Converter_ICommon.hpp               inc=gsp00,\
                                        Converter_Types.hpp,\
                                        Data_Types.hpp

Converter_IDiagnose.hpp             inc=gsp00,\
                                        Data_Types.hpp,\
                                        IOMan_BlockAddress.hpp

Converter_IDump.hpp                 inc=gsp00,\
                                        Kernel_Common.hpp,\
                                        Kernel_Dump.hpp

Converter_IPageNoMapping.hpp        inc=Converter_Types.hpp,\
                                        SAPDB_Types.hpp,\
                                        Data_Types.hpp

Converter_IPageNoManager.hpp        inc=ggg00,\
                                        SAPDB_Types.hpp,\
                                        Converter_Version.hpp,\
                                        Data_Types.hpp

Converter_Entry.hpp                 inc=Converter_Types.hpp,\
                                        Converter_PageFrameAllocator.hpp

Converter_Chain.hpp                 inc=SAPDB_Types.hpp

Converter_ParentReference.hpp       inc=Converter_Types.hpp

Converter_ISavePoint.hpp            inc=gsp00,\
                                        Converter_Version.hpp,\
                                        IOMan_BlockAddress.hpp

Converter_IBackUp.hpp               inc=gsp00,\
                                        Data_Types.hpp,\
                                        Converter_Types.hpp

Converter_IEvent.hpp                inc=Kernel_Event.hpp

Converter_IManager.hpp              inc=+gsp00,\
                                        Converter_Version.hpp,\
                                        Data_Types.hpp,\
                                        IOMan_BlockAddress.hpp

Converter_IMigration.hpp            inc=gsp00,\
                                        Data_Types.hpp,\
                                        IOMan_BlockAddress.hpp

Converter_IVerify.hpp               inc=Data_Types.hpp,\
                                        Converter_Types.hpp

# -------------------------------------------------------------------------------------
# Manager and Config:
# -------------------------------------------------------------------------------------
#
Converter_Configuration.hpp         inc=Kernel_Configuration.hpp,\
                                        IOMan_BlockAddress.hpp,\
                                        SAPDBMem_IRawAllocator.hpp,\
                                        SAPDBMem_IBlockAllocator.hpp,\
                                        Converter_Types.hpp



Converter_Converter.hpp             inc=gsp00,\
                                        Converter_ICommon.hpp,\
                                        Converter_IDiagnose.hpp,\
                                        Converter_IDump.hpp,\
                                        Converter_IPageIO.hpp,\
                                        Converter_IBackUp.hpp,\
                                        Converter_ISavePoint.hpp,\
                                        Converter_IPageNoManager.hpp,\
                                        Converter_IPageNoMapping.hpp,\
                                        Converter_IManager.hpp,\
                                        Converter_IMigration.hpp,\
                                        Converter_IVerify.hpp,\
                                        Converter_IEvent.hpp,\
                                        Converter_Index.hpp,\
                                        Converter_MapControl.hpp,\
                                        Converter_TempMapControl.hpp,\
                                        Converter_PermMapControl.hpp,\
                                        Converter_PermStaticMapControl.hpp,\
                                        Converter_Types.hpp,\
                                        Converter_WaitQueue.hpp,\
                                        IOMan_BlockAddress.hpp,\
                                        IOMan_Types.hpp,\
                                        RTEMem_AllocatorWrapper.hpp,\
                                        RTESync_InterlockedCounter.hpp,\
                                        SAPDBMem_IRawAllocator.hpp,\
                                        FBM_IManager.hpp,\
                                        Log_Savepoint.hpp,\
                                        Data_Types.hpp,\
                                        Kernel_Event.hpp,\
                                        Kernel_DateTime.hpp

Converter_Converter.cpp             inc=hgg01.h,\
                                        hgg08.h,\
                                        hbd20_6.h,\
                                        hbd91.h,\
                                        Converter_Converter.hpp,\
                                        Converter_Dump.hpp,\
                                        Converter_LeafPage.hpp,\
                                        Converter_PageFrameAllocator.hpp,\
                                        Converter_Pager.hpp,\
                                        Converter_BlockAddressIterator.hpp,\
                                        Converter_MapError.hpp,\
                                        Pager_IRestart.hpp,\
                                        Pager_ISavepoint.hpp,\
                                        FrameCtrl_ICommon.hpp,\
                                        IOMan_IDataInfo.hpp,\
                                        Log_Types.hpp,\
                                        RTE_Crash.hpp,\
                                        RTE_Message.hpp,\
                                        RTEConf_ParameterAccess.hpp,\
                                        RTEConf_ParameterAccessKernelInterface.hpp,\
                                        Kernel_IAdminRestartShutdown.hpp,\
                                        KernelParam_Converter.hpp,\
                                        Converter_Exception.hpp,\
                                        Converter_Messages.hpp \
&if $OSSPEC = LINUX #PTS 1110600
nodebug
&endif

# -------------------------------------------------------------------------------------
# Page Types:
# -------------------------------------------------------------------------------------
#
Converter_Page.hpp                  inc=Data_Types.hpp,\
                                        IOMan_BlockAddress.hpp,\
                                        Kernel_Page74.hpp,\
                                        Converter_Types.hpp,\
                                        Converter_ParentReference.hpp,\
                                        Converter_FlagInfo.hpp

Converter_Page.cpp                  inc=Converter_Page.hpp,\
                                        Converter_Messages.hpp,\
                                        Converter_Exception.hpp,\
                                        RTE_Message.hpp,\
                                        RTE_Crash.hpp

Converter_IndexPage.hpp             inc=Converter_Page.hpp
Converter_IndexPage.cpp             inc=Converter_IndexPage.hpp,\
                                        Converter_Messages.hpp,\
                                        Converter_Exception.hpp,\
                                        RTE_Message.hpp

Converter_LeafPage.hpp              inc=Converter_Page.hpp,\
                                        SAPDBFields_Field.hpp
Converter_LeafPage.cpp              inc=Converter_LeafPage.hpp,\
                                        Converter_BlockAddressIterator.hpp,\
                                        Converter_Messages.hpp,\
                                        Converter_Exception.hpp,\
                                        RTE_Message.hpp

Converter_BlockAddressIterator.cpp  inc=Converter_BlockAddressIterator.hpp

Converter_BlockAddressIterator.hpp  inc=IOMan_IBlockAddressIterator.hpp,\
                                        IOMan_BlockAddress.hpp,\
                                        Converter_LeafPage.hpp

Converter_BitMapPage.hpp            inc=SAPDB_BitOperations.hpp,\
                                        Kernel_Page74.hpp,\
                                        Data_Types.hpp,\
                                        Converter_Types.hpp

# used for data base migration from 7.2/7.3 to 7.4

Converter_Page72.hpp                inc=Data_Types.hpp,\
                                        Kernel_Page72.hpp,\
                                        Kernel_Common.hpp,\
                                        IOMan_BlockAddress.hpp

Converter_Page72.cpp                inc=ggg00,\
                                        hgg01_3.h,\
                                        Converter_Types.hpp,\
                                        Converter_Page72.hpp,\
                                        Converter_Messages.hpp,\
                                        Converter_Exception.hpp,\
                                        RTE_Message.hpp,\
                                        SAPDB_ToString.hpp

# -------------------------------------------------------------------------------------
# Map:
# -------------------------------------------------------------------------------------
#
Converter_Map.hpp                   inc=Container_Vector.hpp,\
                                        Converter_BitMapPage.hpp,\
                                        Converter_Chain.hpp,\
                                        Converter_MapEntry.hpp,\
                                        Converter_PageFrameAllocator.hpp,\
                                        Converter_PermMapSection.hpp

Converter_Map.cpp                   inc=Converter_Dump.hpp,\
                                        Converter_LeafPage.hpp,\
                                        Converter_Exception.hpp,\
                                        Converter_Messages.hpp,\
                                        Converter_Map.hpp,\
                                        Converter_FlagInfo.hpp,\
                                        Converter_MapSection.hpp,\
                                        Converter_PermMapSection.hpp,\
                                        FBM_IManager.hpp,\
                                        Kernel_FileIO.hpp,\
                                        Kernel_Dump.hpp,\
                                        RTE_Crash.hpp

Converter_MapEntry.hpp              inc=Converter_Chain.hpp,\
                                        Converter_Entry.hpp,\
                                        Converter_LeafPage.hpp,\
                                        Converter_PageFrameAllocator.hpp

# -------------------------------------------------------------------------------------
# MapControl:
# -------------------------------------------------------------------------------------

Converter_MapControl.hpp            inc=gsp00,\
                                        Converter_Map.hpp,\
                                        Converter_MapSectionData.hpp,\
                                        Container_Vector.hpp,\
                                        Kernel_Common.hpp

Converter_MapControl.cpp            inc=Converter_MapControl.hpp,\
                                        Converter_MapSection.hpp,\
                                        Converter_Dump.hpp,\
                                        Kernel_Dump.hpp

Converter_TempMapControl.hpp        inc=gsp00,\
                                        Converter_MapControl.hpp

Converter_TempMapControl.cpp        inc=Converter_TempMapControl.hpp,\
                                        Converter_TempMapControl.hpp,\
                                        Converter_Map.hpp,\
                                        Converter_MapError.hpp,\
                                        Converter_MapSection.hpp,\
                                        Converter_Version.hpp,\
                                        Data_Types.hpp,\
                                        FBM_IManager.hpp,\
                                        RTE_Crash.hpp

Converter_PermMapControl.hpp        inc=gsp00,\
                                        Converter_MapControl.hpp,\
                                        Converter_UsedPageNoContainer.hpp,\
                                        Converter_BackUpPageNoContainer.hpp,\
                                        Converter_Map.hpp,\
                                        Converter_PermMapSectionData.hpp,\
                                        Converter_WaitQueue.hpp,\
                                        Converter_ArchiveContainer.hpp,\
                                        Container_Vector.hpp,\
                                        Kernel_Common.hpp,\
                                        RTESync_InterlockedCounter.hpp

Converter_PermMapControl.cpp        inc=Converter_PermMapControl.hpp,\
                                        Converter_BitMapPage.hpp,\
                                        Converter_LeafPage.hpp,\
                                        Converter_BlockAddressIterator.hpp,\
                                        Converter_Index.hpp,\
                                        Converter_WaitQueue.hpp,\
                                        Converter_Version.hpp,\
                                        Converter/Converter_Exception.hpp,\
                                        Converter_MapError.hpp,\
                                        Converter_Messages.hpp,\
                                        Converter_Pager.hpp,\
                                        Converter_PermMapSection.hpp,\
                                        Data_Types.hpp,\
                                        FBM_IManager.hpp,\
                                        Kernel_Dump.hpp,\
                                        IOMan_BlockAddress.hpp,\
                                        RTE_Crash.hpp,\
                                        RTE_Message.hpp \
&if $OSSPEC = LINUX #PTS 1110600
nodebug
&endif
&if $OSSPEC = WIN32 and not defined BIT64 and $_MSC_VER = 12
-IGNORE=C4786
&endif


Converter_PermStaticMapControl.hpp  inc=gsp00,\
                                        Converter_PermMapControl.hpp,\
                                        Converter_WaitQueue.hpp,\
                                        Kernel_Common.hpp

Converter_PermStaticMapControl.cpp  inc=Converter_PermStaticMapControl.hpp,\
                                        Converter_Exception.hpp,\
                                        Converter_MapError.hpp,\
                                        Converter_Messages.hpp,\
                                        Converter_Map.hpp,\
                                        Converter_PermMapSection.hpp,\
                                        Converter_Pager.hpp,\
                                        DataAccess/Data_Types.hpp,\
                                        RTE_Crash.hpp,\
                                        RTE_Message.hpp
    

# -------------------------------------------------------------------------------------
# MapSection/Data:
# -------------------------------------------------------------------------------------

Converter_MapSectionData.hpp        inc=gsp00,\
                                        Converter_Types.hpp,\
                                        Converter_Chain.hpp,\
                                        Converter_Dump.hpp,\
                                        Converter_MapEntry.hpp,\
                                        Container_Vector.hpp

Converter_MapSectionData.cpp        inc=Converter_MapSectionData.hpp,\
                                        Converter_Map.hpp

Converter_PermMapSectionData.hpp    inc=Converter_Types.hpp,\
                                        Converter_Chain.hpp,\
                                        Converter_Dump.hpp,\
                                        Converter_FreePageList.hpp,\
                                        Converter_ParentReference.hpp,\
                                        Container_Vector.hpp,\
                                        RTESync_InterlockedCounter.hpp

Converter_PermMapSectionData.cpp    inc=Converter_PermMapSectionData.hpp,\
                                        Converter_Map.hpp

Converter_MapSection.hpp            inc=gsp00,\
                                        Converter_Types.hpp,\
                                        Converter_MapSectionData.hpp

Converter_MapSection.cpp            inc=heo51.h,\
                                        heo55k.h,\
                                        Converter_MapSection.hpp,\
                                        Converter_Map.hpp


Converter_PermMapSection.hpp        inc=gsp00,\
                                        Converter_Types.hpp,\
                                        Converter_Chain.hpp,\
                                        Converter_MapSection.hpp,\
                                        Converter_MapSectionData.hpp,\
                                        Converter_PermMapSectionData.hpp,\
                                        Container_Vector.hpp

Converter_PermMapSection.cpp        inc=Converter_PermMapSection.hpp,\
                                        Converter_Map.hpp

# -------------------------------------------------------------------------------------
# Index:
# -------------------------------------------------------------------------------------
#

Converter_IndexEntry.hpp            inc=Converter_Entry.hpp,\
                                        Converter_IndexPage.hpp

Converter_Index.hpp                 inc=Container_Vector.hpp,\
                                        Container_SortableVector.hpp,\
                                        Converter_Chain.hpp,\
                                        Converter_IndexEntry.hpp,\
                                        Converter_LeafPage.hpp,\
                                        Converter_LeafReference.hpp,\
                                        Kernel_Dump.hpp

Converter_Index.cpp                 inc=Converter_Lock.hpp,\
                                        Converter_Dump.hpp,\
                                        Converter_Index.hpp,\
                                        Converter_Exception.hpp,\
                                        Converter_Messages.hpp,\
                                        Converter_PageFrameAllocator.hpp,\
                                        Converter_Pager.hpp,\
                                        FBM_IManager.hpp,\
                                        IOMan_IDataInfo.hpp,\
                                        RTE_Message.hpp,\
                                        RTE_Crash.hpp

Converter_LeafReference.hpp         inc=IOMan_BlockAddress.hpp,\
                                        Converter_ParentReference.hpp
                                        
Converter_Lock.cpp                  inc=Converter_Lock.hpp,\
                                        heo55k.h,\
                                        hgg08.h

Converter_Lock.hpp                  inc=gsp00


# -------------------------------------------------------------------------------------
# Utility structures:
# -------------------------------------------------------------------------------------
#
Converter_FreePageList.hpp          inc=Data_Types.hpp,\
                                        Converter_Version.hpp,\
                                        Container_Vector.hpp

Converter_BackUpPageNoContainer.hpp inc=Data_Types.hpp,\
                                        Converter_Types.hpp,\
                                        Container_Vector.hpp,\
                                        Converter_FlagInfo.hpp,\
                                        RTESync_InterlockedCounter.hpp

Converter_BackUpPageNoContainer.cpp inc=Converter_BackUpPageNoContainer.hpp,\
                                        Converter_Exception.hpp,\
                                        Converter_Messages.hpp,\
                                        RTE_Message.hpp

                                        
Converter_UsedPageNoContainer.hpp   inc=Data_Types.hpp,\
                                        Container_Vector.hpp,\
                                        Converter_Types.hpp,\
                                        Converter_BitMapPage.hpp,\
                                        Converter_LeafPage.hpp,\
                                        Converter_PageFrameAllocator.hpp

Converter_UsedPageNoContainer.cpp   inc=Converter_UsedPageNoContainer.hpp

Converter_ArchiveContainer.hpp      inc=Data_Types.hpp,\
                                        Container_Vector.hpp,\
                                        Converter_Types.hpp,\
                                        Converter_LeafPage.hpp,\
                                        Converter_PageFrameAllocator.hpp

Converter_ArchiveContainer.cpp      inc=Converter_ArchiveContainer.hpp,\
                                        FBM_IManager.hpp

Converter_PageFrameAllocator.hpp    inc=gsp00,\
                                        Kernel_IPage.hpp,\
                                        Kernel_Common.hpp

Converter_PageFrameAllocator.cpp    inc=heo51.h,\
                                        Converter_PageFrameAllocator.hpp,\
                                        Converter_Converter.hpp,\
                                        FrameCtrl_IConverter.hpp

Converter_Pager.hpp                 inc=gsp00,\
                                        Converter_PageFrameAllocator.hpp,\
                                        Converter_Version.hpp,\
                                        Converter_Index.hpp

Converter_Pager.cpp                 inc=heo51.h,\
                                        Converter_Version.hpp,\
                                        Converter_Converter.hpp,\
                                        Converter_Page.hpp,\
                                         Converter_Pager.hpp,\
                                         FBM_Types.hpp,\
                                         FBM_IManager.hpp,\
                                         IOMan_BlockAddress.hpp,\
                                         IOMan_IConverterIO.hpp

Converter_WaitQueue.hpp             inc=gsp00,\
                                        Kernel_TaskWaitList.hpp

Converter_WaitQueue.cpp             inc=heo56.h,\
                                        heo55k.h,\
                                        hgg08.h,\
                                        Converter_WaitQueue.hpp

Converter_Dump.hpp                  inc=SAPDB_Types.hpp

Converter_FlagInfo.hpp              inc=Data_Types.hpp 

Converter_FlagInfo.cpp              inc=Converter_FlagInfo.hpp

# -------------------------------------------------------------------------------------
# Interface to old pascal modules
# -------------------------------------------------------------------------------------

Converter_Wrapper.cpp                inc=ggg00,\
                                         gbd00,\
                                         gkb00,\
                                         hbd10.h,\
                                         hgg01.h,\
                                         hgg01_3.h,\
                                         Converter_Converter.hpp,\
                                         IOMan_BlockAddress.hpp,\
                                         IOMan_IDataIO.hpp,\
                                         Data_Types.hpp,\
                                         FrameCtrl_IRestartPage.hpp,\
                                         FBM_IManager.hpp,\
                                         Kernel_RestartPage.hpp,\
                                         Kernel_DateTime.hpp

Converter_DiagnoseWrapper.cpp        inc=gsp00,\
                                         Converter_Page.hpp,\
                                         Converter_LeafPage.hpp,\
                                         Converter_IndexPage.hpp,\
                                         Converter_ParentReference.hpp,\
                                         Kernel_Page.hpp,\
                                         IOMan_BlockAddress.hpp,\
                                         Data_Types.hpp

# -------------------------------------------------------------------------------------
# ------  Factory Problems ------ 
# -------------------------------------------------------------------------------------

#PTS 1114591 performance improvement ...
&if  $MACH in [PA20W, PA11]
Converter_PermMapControl.cpp                +inline_level0
&endif

&if $OSSPEC == LINUX && $MACH in [ SDBonPPC64 ]
Converter_Converter.cpp      -OPT=-O1 #PTS 1133972 TS 2005-02-16
Converter_PermMapControl.cpp -OPT=-O1 #PTS 1133972 TS 2005-02-16
Converter_Map.cpp            -OPT=-O1 #PTS 1133972 TS 2005-02-16
&endif
