/*!**************************************************************************

  module      : FBM_PascalInterface.cpp
  
  -------------------------------------------------------------------------
  
  responsible : TorstenS

  auhtor      : AlexanderK
      
  special area: PascalInterface of the FreeBlockManagement (FBM)
  description : For the declarations of the functions see hbd11.h. 
                This modul, hbd11.h and vbd11 can be removed after all pascal sources
                using this functions are replaced by the c++ counterparts.
          
  last changed: 2000-03-10  11:00
  see also    : 
    
  -------------------------------------------------------------------------
  
  copyright:    (c) 2000-2004 SAP AG
                


    ========== licence begin  GPL
    Copyright (c) 2000-2005 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end


*****************************************************************************/

/*===========================================================================*
*  INCLUDES                                                                 *
*===========================================================================*/

#include "gbd00.h"
#include "gsp03.h"
#include "gsp03_3.h"
#include "hgg01_1.h"                              // g01optextmsg
#include "hbd11.h"
#include "FreeBlockManagement/FBM_Manager.hpp"

/*===========================================================================*
 *  FUNCTION DEFINITION                                                      *
 *===========================================================================*/

externC tsp00_Int4 
b11_blocks_used (tsp00_Int2 DevNo)
{
    return FBM_Manager::Instance().NumBlocksUsed(DevNo);
}

/*------------------------------------------------------------------------*/

externC void 
b11_mget_free_blocks (tgg00_TransContext  &Trans,
                      tsp00_Int2           min_block_cnt,
                      tsp00_Int2          &max_block_cnt,
                      tsp00_Int2          &DevNo,
                      tsp00_Int4          &BlockNo,  
                      tgg00_BasisError    &TrError)
{
    const tsp00_Int4 NumFreeBlocksWanted = max_block_cnt;

	// fixme
	const SAPDB_Bool bReqSequential = SAPDB_FALSE;
    
	// called by kb39-restore, always accessModeNormal
    IOMan_ClusterAddress cluster = 
        FBM_Manager::Instance().GetMultFreeBlocks( Trans.trTaskId_gg00, 
        NumFreeBlocksWanted, bReqSequential , Trans.trError_gg00);
    
    if( e_ok != Trans.trError_gg00 )
        return;

    DevNo         = cluster.GetDeviceNo();
    BlockNo       = cluster.GetBlockNo( 0 );
    max_block_cnt = cluster.GetBlockCount();
}

/*------------------------------------------------------------------------*/

externC void 
b11backup_block (tgg00_TransContext  &Trans,
                 tsp00_Int2           DevNo, 
                 tsp00_Int4           MaxNumBlocksWanted, 
                 tsp00_Int4          &SuppliedNumBlocks, 
                 tsp00_Int4          &BlockNo, 
                 tgg00_BasisError    &TrError)
{
    FBM_Manager::Instance().GetNextBlocksForBackUp (Trans.trTaskId_gg00, DevNo, 
        MaxNumBlocksWanted, SuppliedNumBlocks, BlockNo, Trans.trError_gg00);
}

/*------------------------------------------------------------------------*/

externC void 
b11_init () 
{
    tgg00_BasisError TrError = e_ok;
    FBM_Manager::CreateInstance (TrError);
    if (e_ok != TrError)
        g01abort (csp3_bd_msg, csp3_n_fbm,"FBM_IP::Create          ", TrError);
}

