
#
#    ========== licence begin LGPL
#    Copyright (C) 2002 SAP AG
#
#    This library is free software; you can redistribute it and/or
#    modify it under the terms of the GNU Lesser General Public
#    License as published by the Free Software Foundation; either
#    version 2.1 of the License, or (at your option) any later version.
#
#    This library is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#    Lesser General Public License for more details.
#
#    You should have received a copy of the GNU Lesser General Public
#    License along with this library; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#    ========== licence end
#

import string
import regex

identifier = '\([a-zA-Z_][a-zA-Z_0-9]*\)'
whitespace = '[' + string.whitespace + ']*'
namedcl = whitespace + '\(.+[^a-zA-Z_0-9]\)' + whitespace + identifier
parms = '(\(.*\))'
funcRE = regex.compile (namedcl + whitespace + parms)
namedclRE = regex.compile (namedcl)

def parseFunc (s):
    if funcRE.match (s) == -1:
        return None
    name, rettype, parms = funcRE.group (2, 1, 3)
    return name, rettype, parseParms (parms)

def parseParms (s):
    list = string.splitfields (s, ',')
    result = []
    for item in list:
        item = string.strip (item)
        namedclRE.match (item)
        name, parmtype = namedclRE.group (2, 1)
        parmtype = string.strip (parmtype)
        result.append ((name, parmtype))
    return result