#!/usr/bin/env python
# imkdep.py

#
#    ========== licence begin  GPL
#    Copyright (C) 2001 SAP AG
#
#    This program is free software; you can redistribute it and/or
#    modify it under the terms of the GNU General Public License
#    as published by the Free Software Foundation; either version 2
#    of the License, or (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#    ========== licence end
#

import sys
import os
path = os.path

from vmake.imkdepLib import DepUpdater, noInames, WrongConcom, _version

def strictnorm (pathname):
    return path.normcase (path.normpath (pathname))


src = strictnorm (os.environ ['SRC'])
desc = strictnorm (os.environ ['DESC'])

def startsWith (str, other):
    compareValue = path.normcase (str [:len (other)])
    result = compareValue == path.normcase (other)
    return result


def descnameFromFilename (fnameArg, unifiedSys):
    if fnameArg [-4:] == '.com':
        return fnameArg
    fname = path.normpath (path.abspath (fnameArg))
    if startsWith (fname, desc):
        return fname
    if not startsWith (fname, src):
        raise 'Argument not in %SRC% or %DESC%', fnameArg
    if path.isfile (fname):
        fname = path.dirname (fname)
    relative = fname [len (src):]
    layer = os.path.basename (relative)
    inSrc = src + relative + '/' + layer + '.com'
    if unifiedSys or os.path.exists (inSrc):
        result = inSrc
    else:
        result = desc + relative + '.com'
    return result

def descnamesFromFilenames (args, unifiedSys):
    set = {}
    for arg in args:
        description = descnameFromFilename (arg, unifiedSys)
        set [description] = 1
    result = set.keys ()
    result.sort ()
    return result

def checkVersion ():
    import sys
    if sys.version < '1.5.2':
        sys.stdout.write ("""
imkdep needs at least Python 1.5.2.
You're running Python %s.
Please upgrade using \\\\p26326\\InetPub\\ftproot\\ToolsNT\\py152.exe
""" % sys.version)
        sys.exit (1)


def main (options, args):
    """updates the include dependencies of a vmake .com description

    Arguments can be
    - a .com description with a directory prefix
    - the absolute or relative path to a .com description
    - the absolute or relative path to a source file
    - the absolute or relative path to a source directory

    imkdep works by building a file list of the source
    directory and scanning the sources for #include "..." statements.

    The description is accessed using 'iget'.
    On first use, existing inc= directives are removed from the
    description.

    #ifdef directives can be transferred to the .com-Description
    by adding the concom directive as a comment:
        #if defined(_WIN32) /*&if $OSSPEC = WIN32*/
        #include "gos00.h"
        #else               /*&else*/
        #include "gen00.h"
        #endif              /*&endif*/

    """
    checkVersion ()
    if options.noinames:
        noInames ()
    updater = DepUpdater (options)
    args = descnamesFromFilenames (args, options.unifiedSys)
    hasError = 0
    for arg in args:
        try:
            updater.updateDescription (arg)
        except WrongConcom, err:
            hasError = 1
    return hasError

def _options ():
    if desc == src:
        unifiedSys = 1
    else:
        unifiedSys = None
    return [
        # (optstring, varname, typechar, default, help)
        ('except', None, '', None, 'add -except to C++ modules'),
        ('noinames', None, '', None, 'don\'t use iget to find full names'),
        ('unifiedSys', None, '', unifiedSys, '$DESC == $SRC'),
        ('v', 'verbose', '', None, 'verbose output'),
        ('version', None, '', _version, 'version information'),
        ]

if __name__ == '__main__':
    import optlib
    optlib.optMain2 (main, _options ())
