#!/usr/bin/perl
######################################################
# dbRAZORBLADE 
# clean up the QA-Part of the PTS-Database
# HISTORY:
# 2003-04-22 Version 0.1 by Flessner, Falko (d038447)
#

use DBI;
use Net::HTTP;
use Sys::Hostname;
use HTML::LinkExtor;
use URI;
use strict;

package d;
	
my %dbi_attr = ( PrintError => 1, RaiseError => 1);

my $dbh = DBI->connect('DBI:ODBC:10.17.74.60:PTS', 'TESTER', 'TESTER', \%dbi_attr) or die $DBI::errstr;
my $parser = HTML::LinkExtor->new(\&link_callback);
my $monthdelta = 2600000;
my $currtime   = time();
my @to_erase;
my $outtext = "";

&log_start();

&log_entry("main: Turning AutoCommit off");
$dbh->{AutoCommit} = 0;

&do_stmt("CREATE TABLE \"TEMP\".\"MAKEIDS\" (IDMAKE int primary key)");
&do_stmt("CREATE TABLE \"TEMP\".\"LCAMAKEIDS\" (IDLCAMAKE int primary key)");
&do_stmt("CREATE TABLE \"TEMP\".\"JAVATESTIDS\" (DRIVERSTARTED timestamp primary key)");

&do_stmt("INSERT INTO \"TEMP\".\"MAKEIDS\" SELECT DISTINCT idmake FROM makehist WHERE ts < " . &getisotime($currtime - $monthdelta) . " AND idqastatus = 1 OR idqastatus = 5");
&do_stmt("INSERT INTO \"TEMP\".\"MAKEIDS\" SELECT id AS idmake FROM makes WHERE ts < " . &getisotime($currtime - $monthdelta) . " AND id NOT IN (SELECT idmake AS id FROM \"TEMP\".\"MAKEIDS\") AND idqastatus = 1 OR idqastatus = 5"); 
&do_stmt("INSERT INTO \"TEMP\".\"LCAMAKEIDS\" SELECT id as idlcamake FROM lcamakes WHERE ts < " . &getisotime($currtime - $monthdelta) . " AND idqastatus = 1 OR idqastatus = 5");
&do_stmt("INSERT INTO \"TEMP\".\"JAVATESTIDS\" SELECT driverstarted FROM javatestinfo WHERE makekey IN (SELECT idmake FROM \"TEMP\".\"MAKEIDS\")");
&do_stmt("INSERT INTO webdav_delete (url) SELECT url FROM makeprot WHERE idmake IN (SELECT idmake FROM \"TEMP\".\"MAKEIDS\")");
&do_stmt("INSERT INTO webdav_delete (url) SELECT url FROM lcamakeprot WHERE idlcamake IN (SELECT idlcamake FROM \"TEMP\".\"LCAMAKEIDS\")");

&log_entry("<B>COMMIT!</B>");
$dbh->commit();

my $stmt = "SELECT drivermailreport FROM javatestreport WHERE driverstarted IN (SELECT driverstarted FROM \"TEMP\".\"JAVATESTIDS\")";

my $sth = $dbh->prepare($stmt);
$sth->execute();

$outtext = "<TT>" . $stmt . "</TT><BR>After parsing, this returns the following URLs to DELETE<BR>\n";

&log_entry($outtext);

while ( my @urlrow = $sth->fetchrow_array ) {
	$parser->parse($urlrow[0]);
}


&log_entry("<B>COMMIT!</B>");
$dbh->commit();


$sth = $dbh->prepare("INSERT INTO webdav_delete (url) VALUES (?)");

my $i = 0;
foreach my $url (@to_erase) {
	$i++;
	&log_entry ("Adding URL Nr. $i :\n<A HREF=\"$url\"><TT>$url</TT></A><BR>");
	$sth->execute($url);
}

&do_stmt("DELETE FROM lcamakelog     WHERE idlcamake     IN (SELECT idlcamake FROM \"TEMP\".\"LCAMAKEIDS\")");
&do_stmt("DELETE FROM lcamakeprot    WHERE idlcamake     IN (SELECT idlcamake FROM \"TEMP\".\"LCAMAKEIDS\")");
&do_stmt("DELETE FROM lcatests       WHERE idlcamake     IN (SELECT idlcamake FROM \"TEMP\".\"LCAMAKEIDS\")");
&do_stmt("DELETE FROM lcamakehist    WHERE idlcamake     IN (SELECT idlcamake FROM \"TEMP\".\"LCAMAKEIDS\")");
&do_stmt("DELETE FROM lcamakes       WHERE id            IN (SELECT idlcamake FROM \"TEMP\".\"LCAMAKEIDS\")");

&do_stmt("DELETE FROM makelog        WHERE idmake        IN (SELECT idmake FROM \"TEMP\".\"MAKEIDS\")");
&do_stmt("DELETE FROM makeprot       WHERE idmake        IN (SELECT idmake FROM \"TEMP\".\"MAKEIDS\")");
&do_stmt("DELETE FROM makehist       WHERE idmake        IN (SELECT idmake FROM \"TEMP\".\"MAKEIDS\")");

&do_stmt("DELETE FROM javatestreport WHERE driverstarted IN (SELECT driverstarted FROM \"TEMP\".\"JAVATESTIDS\")");
&do_stmt("DELETE FROM javatestinfo   WHERE driverstarted IN (SELECT driverstarted FROM \"TEMP\".\"JAVATESTIDS\")");
&do_stmt("DELETE FROM \"TEMP\".\"MAKEIDS\" WHERE idmake  IN (SELECT DISTINCT idmake FROM lcamakes)");
&do_stmt("DELETE FROM makes          WHERE id            IN (SELECT idmake FROM \"TEMP\".\"MAKEIDS\")");

&log_entry("<B>COMMIT!</B>");
$dbh->commit();
$dbh->{AutoCommit} = 1;

$sth = $dbh->prepare("SELECT id, url FROM webdav_delete");
$sth->execute();

my $del_ref = $sth->fetchall_arrayref();

my $del_sth = $dbh->prepare("DELETE FROM webdav_delete WHERE id = ?");
foreach my $row (@$del_ref) {
	my ($id, $url) = @$row;
	&webdav_delete($url);
	$del_sth->execute($id);
}

&log_end();

sub link_callback {
        my ($tag, %attr) = @_;
        if ($tag ne "a") {
		&log_entry("I have found a anwanted tag: $tag");
		return;
	}
	
        foreach my $val (values(%attr)) {
		&log_entry("DEBUG: I have parsed out the followning URL:<BR><A HREF=\"" . $val . "\">$val</A>");
		push(@to_erase, $val);
	}
}


sub do_stmt {
	my $statement = shift;
	
	my $rv = $dbh->do($statement);
	
	if ($rv) {
		&log_entry("<TT>$statement </TT><BR>$rv rows affected");
	} else {
		&log_entry("<TT>$statement </TT><BR>ERROR: $dbh->errstr");
		&log_entry("<H1>Rolling back and exiting!!</H1>");
		$dbh->rollback();
		&log_end();
		exit(1);
	}
}

sub webdav_delete {
	my $url_string = shift;
	my %head_content;
	my @tlist = localtime(time());
	$head_content{'User-Agent'} = "LCqaCLI/1.0";
	
	my $url = URI->new($url_string);
	
	my $dav_req = Net::HTTP->new('Host' => $url->host(), 'PeerPort' => $url->port());
	$dav_req->write_request('DELETE', $url->path());
	my ($code, $mess, %headers) = $dav_req->read_response_headers();
	
	&log_entry(" webdav_delete $url_string : $code - $mess\n");
}
	
sub log_start {
	my @tlist = localtime(time());
	print "<HTML><HEAD><TITLE>dbrazorblade - log</TITLE></HEAD><BODY BGCOLOR=#FFFFFF><H1><FONT FACE=\"Arial, Helvetica\">dbRAZORBLADE</H1><H3><FONT FACE=\"Arial, Helvetica\">Log vom ";
		printf ("%04d-%02d-%02d %02d:%02d:%02d",
		$tlist[5] + 1900,
		$tlist[4] + 1,
		$tlist[3],
		$tlist[2],
		$tlist[1],
		$tlist[0]);
		
	print "</H3><TABLE BORDER=1>\n";

}

sub log_end {
	print "\n</TABLE><HR></BODY></HTML>\n";
}

sub log_entry {
	my $entry = shift;
	my @tlist = localtime(time());
	
	print "<TR><TD><FONT FACE=\"Arial, Helvetica\">";
	printf ("%04d-%02d-%02d %02d:%02d:%02d",
		$tlist[5] + 1900,
		$tlist[4] + 1,
		$tlist[3],
		$tlist[2],
		$tlist[1],
		$tlist[0]);
	print "</TD><TD><FONT FACE=\"Arial, Helvetica\">$entry </TD></TR>\n";
}
	
sub getisotime {
	my $ts = shift;
	my @tlist = localtime($ts);
	
	return sprintf("'%04d-%02d-%02d %02d:%02d:%02d.0000'",
		$tlist[5] + 1900,
		$tlist[4] + 1,
		$tlist[3],
		$tlist[2],
		$tlist[1],
		$tlist[0]);
}
