(* @(#)common/dump_hdg.P

    ========== licence begin LGPL
    Copyright (C) 2002 SAP AG

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2.1 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
    ========== licence end

 *)

(* define *)

#include "csg.def"
#define SymbolTableTypes(A)  STab [A].SType
#define StringField  NodeIndex + 3
#define SpecOperator  MinorOperator
#define LsOperator  MinorOperator
#define SsOperator MajorOperator

(* imports *)

#include "globals.i"
#include "csg.i"
#include "opcode.i"
#include "strtab.h"
#include "utilities.h"
#include "_shifts.h"

function double_to_double(p1,p2:integer):double; external; /* DK 16.07.88 */
function double_to_long(p1,p2:integer):long; external;


(* exports *)

#include "dumptree.h"

   (* this module contains the procedures that dump the *)
   (* the hdg.                                          *)

(* privates *)

type
   String20 = packed array [0..19] of char;

var
   opcodes : array [FirstOp .. LastOp] of String20;
   NestLevel : integer;

(* initial *)

procedure DumptreeI;
      (* initialize the opcodes, the level of nesting,line no,error count etc*)

var
   i,
   j: integer;

begin

      NestLevel := 0;

      for i := FirstOp to LastOp do begin
	  opcodes [ i ]            :=    '<<unknown>>';
	  opcodes [ i ][ 11 ] := chr (0);
	  end ;

      opcodes[NopOp]            :=    'nop';
      opcodes[NopOp][3] := chr (0);
{
 *    opcodes[StartOp]          :=    'start';
 *    opcodes[StartOp][5] := chr (0);
}
      opcodes[LnoOp]            :=    'lno';
      opcodes[LnoOp][3] := chr (0);
      opcodes[LoadOp]           :=    'load';
      opcodes[LoadOp][4] := chr (0);
{
 *    opcodes[LoadxOp]          :=    'loadx';
 *    opcodes[LoadxOp][5] := chr (0);
}
      opcodes[StoreOp]          :=    'store';
      opcodes[StoreOp][5] := chr (0);
{
 *    opcodes[StorexOp]         :=    'storex';
 *    opcodes[StorexOp][6] := chr (0);
}
      opcodes[StorepOp]         :=    'storep';
      opcodes[StorepOp][6] := chr (0);
      opcodes[StorepadrOp]      :=    'storepadr';
      opcodes[StorepadrOp][9] := chr (0);
{
 *    opcodes[LoadxadrOp]       :=    'loadxadr';
 *    opcodes[LoadxadrOp][8] := chr (0);
}
      opcodes[LitOp]            :=    'lit';
      opcodes[LitOp][3] := chr (0);
      opcodes[LoadadrOp]        :=    'loadadr';
      opcodes[LoadadrOp][7] := chr (0);
      opcodes[LoadstrOp]        :=    'loadstr';
      opcodes[LoadstrOp][7] := chr (0);
      opcodes[AddOp]            :=    'add';
      opcodes[AddOp][3] := chr (0);
      opcodes[SubtOp]           :=    'subt';
      opcodes[SubtOp][4] := chr (0);
      opcodes[MultOp]           :=    'mult';
      opcodes[MultOp][4] := chr (0);
      opcodes[DivOp]            :=    'div';
      opcodes[DivOp][3] := chr (0);
      opcodes[RangeOp]          :=    'rnge';
      opcodes[RangeOp][4] := chr (0);
      opcodes[UminusOp]         :=    'uminus';
      opcodes[UminusOp][6] := chr (0);
      opcodes[OrOp]             :=    'or';
      opcodes[OrOp][2] := chr (0);
      opcodes[XorOp]            :=    'xor';
      opcodes[XorOp][3] := chr (0);
      opcodes[AndOp]            :=    'and';
      opcodes[AndOp][3] := chr (0);
      opcodes[NotOp]            :=    'not';
      opcodes[NotOp][3] := chr (0);
      opcodes[ShlOp]            :=    'shl';
      opcodes[ShlOp][3] := chr (0);
      opcodes[ShrOp]            :=    'shr';
      opcodes[ShrOp][3] := chr (0);
      opcodes[EqOp]             :=    'eq';
      opcodes[EqOp][2] := chr (0);
      opcodes[LtOp]             :=    'lt';
      opcodes[LtOp][2] := chr (0);
      opcodes[GtOp]             :=    'gt';
      opcodes[GtOp][2] := chr (0);
      opcodes[LeOp]             :=    'le';
      opcodes[LeOp][2] := chr (0);
      opcodes[GeOp]             :=    'ge';
      opcodes[GeOp][2] := chr (0);
      opcodes[NeOp]             :=    'ne';
      opcodes[NeOp][2] := chr (0);
      opcodes[CallOp]           :=    'call';
      opcodes[CallOp][4] := chr (0);
{
 *    opcodes[ScallOp]          :=    'scall';
 *    opcodes[ScallOp][5] := chr (0);
}
      opcodes[RtrnOp]           :=    'rtrn';
      opcodes[RtrnOp][4] := chr (0);
      opcodes[RtrnxOp]          :=    'rtrnx';
      opcodes[RtrnxOp][5] := chr (0);
{
 *    opcodes[SaveOp]           :=    'save';
 *    opcodes[SaveOp][4] := chr (0);
 *    opcodes[ExitOp]           :=    'exit';
 *    opcodes[ExitOp][4] := chr (0);
 *    opcodes[LngthOp]          :=    'lngth';
 *    opcodes[LngthOp][5] := chr (0);
 *    opcodes[ElmntOp]          :=    'elmnt';
 *    opcodes[ElmntOp][5] := chr (0);
 *    opcodes[AppendOp]         :=    'append';
 *    opcodes[AppendOp][6] := chr (0);
 *    opcodes[PrintOp]          :=    'print';
 *    opcodes[PrintOp][5] := chr (0);
 *    opcodes[StorefOp]         :=    'storef';
 *    opcodes[StorefOp][6] := chr (0);
}
      opcodes[ProcOp]           :=    'proc';
      opcodes[ProcOp][4] := chr (0);
{
 *    opcodes[IntToCharOp]    :=    'IntToChar';
 *    opcodes[IntToCharOp][9] := chr (0);
 *    opcodes[CharToIntOp]    :=    'CharToInt';
 *    opcodes[CharToIntOp][9] := chr (0);
}
      opcodes[Sys0Op]           :=    'sys0';
      opcodes[Sys0Op][4] := chr (0);
{
 *    opcodes[Sys1Op]           :=    'sys1';
 *    opcodes[Sys1Op][4] := chr (0);
 *    opcodes[Sys2Op]           :=    'sys2';
 *    opcodes[Sys2Op][4] := chr (0);
 *    opcodes[Sys3Op]           :=    'sys3';
 *    opcodes[Sys3Op][4] := chr (0);
 *    opcodes[DescOp]           :=    'desc';
 *    opcodes[DescOp][4] := chr (0);
}
      opcodes[LitSizeOp]       :=    'LitSize';
      opcodes[LitSizeOp][7] := chr (0);
      opcodes[LitOffsetOp]     :=    'LitOffset';
      opcodes[LitOffsetOp][9] := chr (0);
{
 *    opcodes[LoadtOp]          :=    'loadt';
 *    opcodes[LoadtOp][5] := chr (0);
 *    opcodes[StoretOp]         :=    'storet';
 *    opcodes[StoretOp][6] := chr (0);
}
      opcodes[AddiOp]           :=    'addi';
      opcodes[AddiOp][4] := chr (0);
      opcodes[SubtiOp]          :=    'subti';
      opcodes[SubtiOp][5] := chr (0);
      opcodes[AddixOp]          :=    'addix';
      opcodes[AddixOp][5] := chr (0);
      opcodes[SubtixOp]         :=    'subtix';
      opcodes[SubtixOp][6] := chr (0);
      opcodes[MultxOp]          :=    'multx';
      opcodes[MultxOp][5] := chr (0);
      opcodes[ContinueOp]       :=    'continue';
      opcodes[ContinueOp][8] := chr (0);
      opcodes[GotoOp]           :=    'goto';
      opcodes[GotoOp][4] := chr (0);
      opcodes[ModOp]            :=    'mod';
      opcodes[ModOp][3] := chr (0);
      opcodes[BAndOp]           :=    'b_and';
      opcodes[BAndOp][5] := chr (0);
      opcodes[BOrOp]            :=    'b_or';
      opcodes[BOrOp][4] := chr (0);
      opcodes[BXorOp]           :=    'b_xor';
      opcodes[BXorOp][5] := chr (0);
      opcodes[BNotOp]           :=    'b_not';
      opcodes[BNotOp][5] := chr (0);
      opcodes[ConvertOp]        :=    'convert';
      opcodes[ConvertOp][7] := chr (0);
      opcodes[IdOp]             :=    'id';
      opcodes[IdOp][2] := chr (0);
      opcodes[SubscriptOp]      :=    'subscript';
      opcodes[SubscriptOp][9] := chr (0);
      opcodes[ElementOp]      :=    'element';
      opcodes[ElementOp][7] := chr (0);
      opcodes[DerefOp]      :=    'deref';
      opcodes[DerefOp][5] := chr (0);
      opcodes[LabelOp]      :=    'label';
      opcodes[LabelOp][5] := chr (0);
      opcodes[CaseOp]      :=    'case';
      opcodes[CaseOp][4] := chr (0);
      opcodes[DefaultOp]      :=    'default';
      opcodes[DefaultOp][7] := chr (0);
      opcodes[BreakOp]      :=    'break';
      opcodes[BreakOp][5] := chr (0);
      opcodes[PrefixOp]      :=    'prefix';
      opcodes[PrefixOp][6] := chr (0);
      opcodes[PostfixOp]      :=    'postfix';
      opcodes[PostfixOp][7] := chr (0);
      opcodes[ModuloOp]      :=    'modulo';
      opcodes[ModuloOp][6] := chr (0);
      opcodes[FileOp]      :=    'file';
      opcodes[FileOp][4] := chr (0);
      opcodes[AsmOp]      :=    'asm';
      opcodes[AsmOp][3] := chr (0);
      opcodes[RepeatOp ] := 'repeat';
      opcodes[RepeatOp][6] := chr (0);
      opcodes[ComplexOp] := 'complex';
      opcodes[ComplexOp][7] := chr (0);
      opcodes[StaticLinkOp]      :=    'staticlink';
      opcodes[StaticLinkOp][10] := chr (0);
      opcodes[RegOp]      :=    'reg';
      opcodes[RegOp][3] := chr (0);
      opcodes[EntryOp]      :=    'entry';
      opcodes[EntryOp][5] := chr (0);
      opcodes[StoreadrOp]      :=    'storeadr';
      opcodes[StoreadrOp][8] := chr (0);
      opcodes[ListOp]      :=    'list';
      opcodes[ListOp][4] := chr (0);
      opcodes[CommaOp]      :=    'comma';
      opcodes[CommaOp][5] := chr (0);
      opcodes[PushOp]      :=    'push ';
      opcodes[PushOp][5] := chr (0);
      opcodes[PopOp]      :=    'pop  ';
      opcodes[PopOp][5] := chr (0);
      opcodes[PushAdrOp]      :=    'pushadr';
      opcodes[PushAdrOp][7] := chr (0);
      opcodes[PopAdrOp]      :=    'popadr';
      opcodes[PopAdrOp][6] := chr (0);
      opcodes[BeginOp]      :=    'begin';
      opcodes[BeginOp][5] := chr (0);
      opcodes[EndOp]      :=    'end';
      opcodes[EndOp][3] := chr (0);
   end; (* initial *)

(* routines *)

   procedure indent(NoBlanks,NodeIndex: integer; str : String20);
      (* this procedure pads a string with leading blanks *)
      (* for purposes of indentation.                     *)
      var i : integer;

      begin
      writeln ;
      {
      if control['V'] then begin
      }
	 write('(',NodeIndex:4,') ');
      {
      end  (* if *);
      }
      for i := 1 to NoBlanks do begin
	 write(' ');
      end  (* for *);

      i := -1;
      repeat
         i := i + 1;
      until (str [i] = ' ') or (str [i] = chr (0));
      if i > 0 then begin
	 write(str:i);
      end;

      if control['i'] = false then begin
	 flush;
      end  (* if *);

      end (*indent*);


   procedure PrintName
      (index: integer);
   var
      i: integer;
      s: STRING;
   begin
      GetString (STab [index].SName, s [0]);
      i := GetStringLength (STab [index].SName);
      if i > 0 then begin
	 write (s:i, ' [', index:1, ']');
      end
      else begin
	 write ('name is null [', index:1, ']');
      end;
   end  (* PrintName *);


   procedure ListString
      (index: integer);
   var
      i: integer;
      s: STRING;
   begin
      GetString (index, s [0]);
      i := GetStringLength (index);
      if i > 0 then begin
	 write (s:i, ' [', index:1, ']');
      end
      else begin
	 write ('string is null [', index:1, ']');
      end;
   end  (* ListString *);


   procedure LstCode(code,NodeIndex,parm1,parm2 : integer);
      (* this procedure outputs operators and their operands.  *)
      var s : STRING;

      begin

      if code = LnoOp then begin
         indent(NestLevel,NodeIndex,opcodes[code]);
      end
      else begin
	 write ('-', opcodes [code]:sql__strlen (opcodes [code] [0]), ':  ');
      end;

      case code of

         LnoOp: begin
	    write(' ', parm1:1);
         end;

         LitSizeOp,LitOffsetOp,IdOp: begin
            PrintName (parm1);
         end;

         LoadstrOp: begin  (* load string by var *)
	    write (' (string) ');
            ListString(parm1);
         end;

         LitOp: begin
            case SymbolTableTypes (TypeField) of
	       PointerType,
               IntegerType: begin
		  write(' ',parm1:1,' (integer)');
               end;
	       UcharType: begin
		  write ( ' ', chr (parm1):1, ', ', parm1:1,' (uchar)');
               end;
	       LongType: begin
		  write(' ',double_to_long(parm1,parm2):1,' (long)');
               end;
	       UlongType: begin
		  write(' ',double_to_long(parm1,parm2):1,' (unsigned long)');
               end;
               FloatType: begin						/* DK 16.07.88 */
		  write(' ',double_to_double(parm1,parm2):1,' (float)');
               end;
               DoubleType: begin					/* DK 16.07.88 */	
		  write(' ',double_to_double(parm1,parm2):1, ' (double)');
               end;
               CharacterType,EnumerativeType: begin			/* DK 16.07.88 */
		  write('[',parm1:1,']  ');
               end;
               BooleanType: begin
                  if parm1 = 0  then begin
		     write (' false');
                  end
                  else begin
		     write (' true');
                  end  (* if *);
		  write (' (boolean)');
               end;
               ArrayType: begin
		  write (' (string) ');
                  ListString(parm1);
               end;
	       SubRangeType: begin write ( ' ..... (SubRangeType !!)'); end;
	       ShortType: begin write ( ' ..... (ShortType !!)'); end;
	       UshortType: begin write ( ' ..... (UshortType !!)'); end;
	       UnsignedType: begin write ( ' ..... (UnsignedType !!)'); end;
	       CharType: begin
		   write ( ' ', chr (parm1):1, ', ', parm1:1,' (CharType)');
			end;
	       RecordType: begin write ( ' ..... (RecordType !!)'); end;
	       FileType: begin write ( ' ..... (FileType !!)'); end;
	       SetType: begin write ( ' ..... (SetType !!)'); end;
	       FunctionType: begin write ( ' ..... (FunctionType !!)'); end;
	       UnionType: begin write ( ' ..... (UnionType !!)'); end;
	       StringType: begin write ( ' ..... (StringType !!)'); end;
	       VoidType: begin write ( ' ..... (VoidType !!)'); end;
	       BlockType: begin write ( ' ..... (BlockType !!)'); end;
	       ProcedureType: begin write ( ' ..... (ProcedureType !!)'); end;
	       otherwise: begin
		  write ( ' ..... (unknown type !!)');
               end;
            end  (* case *);
         end;

         Sys0Op: begin
            ListString (parm1);
	    write (', no. parameters = ', parm2:1);
         end;

         SubscriptOp: begin
	    write (parm1:1, ', ', parm2:1);
         end;

         CaseOp: begin
	    write ( parm1:1, ', ', parm2:1);
         end;

	 EntryOp,
	 PushOp,
         PopOp,
	 PushAdrOp,
         PopAdrOp,
         GotoOp,
         LabelOp: begin
            PrintName (parm1);
         end;

         FileOp: begin
	    write ('  ');
            ListString (parm1);
         end;

	 AsmOp: begin
	    write ('  ');
            ListString (parm1);
	 end;

	 BeginOp: begin
	    write ('  ');
	    write (parm1:1);
	 end;

	 EndOp: begin
	    write ('  ');
	    write (parm1:1);
	 end;

	 StaticLinkOp: begin					/* DK 16.07.88 */
	    write ('  ',parm1:1);
	 end;

         otherwise begin
	    write (' ');
         end;
      end  (* case *);

      end (*LstCode*);


   procedure HdgPrint(NodeIndex : HdgRange); forward;


   procedure CsgPrint(NodeIndex : HdgRange);
      (* this procedure outputs the csg's'.  *)

   var
      s: STRING;
      SaveIndex: HdgRange;


   procedure PrintType
      (NodeIndex: HdgRange);
   var
      i: integer;
      s: STRING;
   begin
      GetString (STab [TypeField].SName, s [0]);
      i := GetStringLength (STab [TypeField].SName);
      if i > 0 then begin
	 write (', type = ', s:i, ' [', TypeField:1, ']');
      end
      else begin
	 write (', type = unnamed [', TypeField:1, ']');
      end;
   end;


   procedure PrintDscPtr
      (NodeIndex: HdgRange);
   begin
      (* print the contents of descriptor field *)
      write('   {',DscField:1,'}');
   end (*PrintDscPtr*);


   begin
      if NodeIndex <> -1 then begin
         NestLevel := NestLevel + 3;
         case MajorOperator of

            node: begin
               indent (NestLevel, NodeIndex, 'node');
               LstCode(NodeOperator, NodeIndex, Node1parameter, Node2parameter);
               PrintType (NodeIndex);
            end;

            spec: begin
               LstCode(LnoOp,NodeIndex,SpecLineNo,0);
               indent (NestLevel, NodeIndex, 'spec');
               LstCode(SpecOperator,NodeIndex,Spec1parameter,0);
               PrintType (NodeIndex);
               PrintDscPtr (NodeIndex);
            end;

            ShortStmnt: begin
               LstCode(LnoOp,NodeIndex,SsLineNo,0);
               indent (NestLevel, NodeIndex, 'ShortStmnt');
               LstCode(SsOperator,NodeIndex,0,0);
               PrintType (NodeIndex);
               PrintDscPtr (NodeIndex);
               CsgPrint (Ss1operand);
            end;

            UnaryExp: begin
               indent (NestLevel, NodeIndex, 'UnaryExp');
               LstCode(UnaryOperator,NodeIndex,Unary1parameter,Unary2parameter);
               PrintType (NodeIndex);
               PrintDscPtr (NodeIndex);
               CsgPrint (Unary1operand);
            end;

            BinaryExp: begin
               indent (NestLevel, NodeIndex, 'BinaryExp');
               LstCode(BinOperator,NodeIndex,Bin1parameter,Bin2parameter);
               PrintType (NodeIndex);
               PrintDscPtr (NodeIndex);
               CsgPrint (Bin1operand);
               CsgPrint (Bin2operand);
            end;

            ExpList: begin
               indent (NestLevel, NodeIndex, 'ExpList');
               PrintType (NodeIndex);
               SaveIndex := NodeIndex;
               NodeIndex := ListHeadField;
               while NodeIndex <> -1 do begin
                  indent (NestLevel, SaveIndex, 'ListElement');
                  CsgPrint (NodeIndex);
                  NodeIndex := NextLink;
               end;
            end;

            LongStmnt: begin
               LstCode(LnoOp,NodeIndex,LsLineNo,0);
               indent (NestLevel, NodeIndex, 'LongStmnt');
               LstCode(LsOperator,NodeIndex,Ls1parameter,Ls2parameter);
               PrintType (NodeIndex);
               PrintDscPtr (NodeIndex);
               if MinorOperator = CallOp then begin
                  indent (NestLevel, NodeIndex, 'Ls1parameter');
                  CsgPrint (Ls1parameter);
               end;
               indent (NestLevel, NodeIndex, 'Ls1operand');
		if MinorOperator <> Sys0Op then
               		CsgPrint (Ls1operand);
               indent (NestLevel, NodeIndex, 'Ls2operand');
               CsgPrint (Ls2operand);
            end;

            ifthenelse: begin
               LstCode(LnoOp,NodeIndex,IfLineNo,0);
               indent (NestLevel, NodeIndex, 'ifthenelse');
               PrintType (NodeIndex);
               PrintDscPtr (NodeIndex);
               indent (NestLevel, NodeIndex, 'ifcond');
               CsgPrint (IfCondField);
               indent (NestLevel, NodeIndex, 'iftrue');
               HdgPrint(IfTrueField);
               if IfFalseField <> -1 then begin
                  indent (NestLevel, NodeIndex, 'iffalse');
                  HdgPrint(IfFalseField);
               end  (* if *);
            end;


            loop: begin
               LstCode(LnoOp,NodeIndex,WhileLineNo,0);
               indent (NestLevel, NodeIndex, 'loop');
               PrintType (NodeIndex);
               PrintDscPtr (NodeIndex);
               indent (NestLevel, NodeIndex, 'whiletest');
               CsgPrint (WhileTestField);
               indent (NestLevel, NodeIndex, 'whilebody');
               HdgPrint(WhileBodyField);
            end;

            Switch: begin
               LstCode(LnoOp,NodeIndex,SwitchLineNo,0);
               indent (NestLevel, NodeIndex, 'Switch');
               PrintType (NodeIndex);
               PrintDscPtr (NodeIndex);
               indent (NestLevel, NodeIndex, 'SwitchTest');
               CsgPrint (SwitchTest);
               indent (NestLevel, NodeIndex, 'SwitchBody');
               HdgPrint(SwitchBody);
            end;

            Case: begin
               LstCode(LnoOp,NodeIndex,CaseLineNo,0);
               indent (NestLevel, NodeIndex, 'Case');
               LstCode(MinorOperator,NodeIndex,CaseLowVal,CaseHighVal);
               PrintType (NodeIndex);
               PrintDscPtr (NodeIndex);
            end;

            RepeatUntil: begin
               LstCode(LnoOp,NodeIndex,RepeatLineNo,0);
               indent (NestLevel, NodeIndex, 'RepeatUntil');
               PrintType (NodeIndex);
               PrintDscPtr (NodeIndex);
               indent (NestLevel, NodeIndex, 'repeatbody');
               HdgPrint(RepeatBody);
               indent (NestLevel, NodeIndex, 'repeattest');
               CsgPrint (RepeatTest);
            end;

            Proc: begin
	       writeln ;
	       writeln ;
               indent(NestLevel,NodeIndex,'Proc');
               GetString (STab [ProcLabel].SName, s [0]);
	       write(':  ', s:GetStringLength (STab [ProcLabel].SName), ' [', ProcLabel:1, ']');
               PrintType (NodeIndex);
               PrintDscPtr (NodeIndex);
               HdgPrint(ProcProlog);
               HdgPrint(ProcBody);
            end;

            OpenProc: begin
               indent(NestLevel,NodeIndex,'OpenProc');
               GetString (STab [ProcLabel].SName, s [0]);
	       write(':  ', s:GetStringLength (STab [ProcLabel].SName), ' [', ProcLabel:1, ']');
               PrintType (NodeIndex);
               PrintDscPtr (NodeIndex);
               HdgPrint(ProcBody);
            end;

	    InitialProc: begin  (* 1992-Oct-19 J.Bruehe *)
	       indent(NestLevel,NodeIndex,'InitialProc - no further analysis');
            end;

	    otherwise: begin    (* 1992-Oct-19 J.Bruehe *)
	       writeln ( 'CsgPrint: unexpected MajorOp / NodeIndex ' ,
			MajorOperator , NodeIndex );
            end;

         end  (* case *);
         NestLevel := NestLevel - 3;
      end  (* if *);
   end  (* CsgPrint *);


   procedure HdgPrint;

   begin
      while ( NodeIndex <> -1 ) and ( NodeIndex <> 0 ) do begin
         CsgPrint(NodeIndex);
         NodeIndex := NextLink;
      end  (* while *);
   end (*HdgPrint*);


procedure DumpHdg(NodeIndex:integer);

      (* if there are no errors, this procedure prints the header *)
      (* for the hdg dump and calls the routine 'HdgPrint'.      *)

begin
   DumptreeI;
   writeln ;
   writeln ;
   write ('dump hdg');
   writeln ;
   writeln ;
   NestLevel := -3;
   HdgPrint(NodeIndex);
   writeln ;
   writeln ;
(* flush (output);      *)
end (*ListHdg*);


procedure HdgMark(NodeIndex : HdgRange); forward;
procedure markT(Idx : integer); forward;


procedure Mark(Idx : integer);
begin
STab[Idx].SFeld5 := 1;
end;

function DontReduceAnything : boolean; forward;

function IsMarked(Idx : integer) : boolean;
begin
IsMarked := (STab[Idx].SFeld5 = 1) or DontReduceAnything;
end;

function TypeOfVar(Idx : integer) : integer;
begin
if STab[Idx].STname > 0
then
  TypeOfVar := STab[Idx].STname
else
  TypeOfVar := STab[Idx].SType;
end;


function IsConstDcl(Idx:integer):boolean;
begin
   with STab[Idx] do
#ifdef RAS /*RASE err.17:fix IsConstDcl() */
     IsConstDcl := (SKind = ConDcl) and (SFeld3 > 0)
#else
     IsConstDcl := (SKind = ConDcl) and (SNextEnum = 0)
#endif
end;

function SubTree(Idx : integer) : integer;
/* Zusicherung: IsConstDcl(Idx)  */
begin
SubTree := STab[Idx].SFeld3;
end;

procedure MarkId(Idx : integer);
begin
/* wir markieren auch die Variable selbst,
   so ist spaeter Optimierung moeglich:
   nicht markierte Variable wird offensichtlich nicht verwendet,
   also nicht ausgeben! */
Mark(Idx);
markT(TypeOfVar(Idx));
if IsConstDcl(Idx)
    /* die rechte Seite einer Konstanten-Deklaration
       kann ein ganzer Unterbaum sein! */
then
  if SubTree(Idx) <> 0
  then
    HdgMark(SubTree(Idx));
end;


   procedure CsgMark(NodeIndex : HdgRange);
      (* this procedure outputs the csg's'.  *)
   var
      s: STRING;
      SaveIndex: HdgRange;

   begin
      if NodeIndex <> -1 then begin
         case MajorOperator of

            node: begin
	       case MinorOperator of
	       IdOp:
		  MarkId(Node1parameter);
	       otherwise:
		  begin
		  end;
	       end;	
            end;

            spec: begin
            end;

            ShortStmnt: begin
               CsgMark (Ss1operand);
            end;

            UnaryExp: begin
	       case MinorOperator of
	       DerefOp:
		  markT(TypeField);
               otherwise;
		  begin
		  end;
	       end;	
               CsgMark (Unary1operand);
            end;

            BinaryExp: begin
               CsgMark (Bin1operand);
               CsgMark (Bin2operand);
            end;

            ExpList: begin
               SaveIndex := NodeIndex;
               NodeIndex := ListHeadField;
               while NodeIndex <> -1 do begin
                  CsgMark (NodeIndex);
                  NodeIndex := NextLink;
               end;
            end;

            LongStmnt: begin
               if MinorOperator = CallOp then begin
                  CsgMark (Ls1parameter);
               end;
		if MinorOperator <> Sys0Op then
               		CsgMark (Ls1operand);
               CsgMark (Ls2operand);
            end;

            ifthenelse: begin
               CsgMark (IfCondField);
               HdgMark(IfTrueField);
               if IfFalseField <> -1 then begin
                  HdgMark(IfFalseField);
               end  (* if *);
            end;


            loop: begin
               CsgMark (WhileTestField);
               HdgMark(WhileBodyField);
            end;

            Switch: begin
               CsgMark (SwitchTest);
               HdgMark(SwitchBody);
            end;

            Case: begin
            end;

            RepeatUntil: begin
               HdgMark(RepeatBody);
               CsgMark (RepeatTest);
            end;

            Proc: begin
               HdgMark(ProcProlog);
               HdgMark(ProcBody);
            end;

            OpenProc: begin
               HdgMark(ProcBody);
            end;

         end  (* case *);
      end  (* if *);
   end  (* CsgMark *);


   procedure HdgMark;

   begin
      while NodeIndex <> -1  do begin
         CsgMark(NodeIndex);
         NodeIndex := NextLink;
      end  (* while *);
   end (*HdgMark*);


function IsEnumDcl(Idx:integer):boolean;
begin
   with STab[Idx] do
     IsEnumDcl := (SKind = TypeDcl) and (SType = EnumerativeType)
end;


procedure M_RecordType(Idx : integer);

	procedure List_RecordElements(Idx : integer); forward;
	procedure List_RecordVariants(Idx : integer); forward;
	procedure M_RecordElement(Idx : integer); forward;
	procedure M_RecordVariant(Idx : integer); forward;

	procedure List_RecordElements;
	begin
	while Idx <> -1 do
		begin
		M_RecordElement(Idx);
		Idx := STab[Idx].SNextField;
		end;
	end;

	procedure List_RecordVariants;
	begin
	while Idx <> -1 do
		begin
		M_RecordVariant(Idx);
		Idx := STab[Idx].SNextVariant;
		end;
	end;

	/* Allein dies ist Blatt, der Baum endet stets mit record-Elementen */
	procedure M_RecordElement;
	begin
        if not IsEnumDcl(STab[Idx].SType)
        then
	  markT(TypeOfVar(Idx));    /* so erkennt er auch Typnamen */
	end;

	procedure M_RecordVariant;
	begin
	List_RecordElements(STab[Idx].SFirstField);
	List_RecordVariants(STab[Idx].SFirstVariant);
	end;


begin
List_RecordElements(STab[Idx].SFirstField);
List_RecordVariants(STab[Idx].SFirstVariant);
end;

/* ------------------------ some flag-functions -------------------------- */

function BreakPointerType : boolean;
begin
BreakPointerType := control2['b'];
end;

function DelayedParCopy : boolean;
begin
DelayedParCopy := ( not control2['d'] );
end;

function DeleteUnusedVar : boolean;
begin
DeleteUnusedVar := ( not control2['v'] );
end;

function DeleteUnusedType : boolean;
begin
DeleteUnusedType := ( not control2['t'] ); (*JH and ( not control2['u'] ) ;*)
end;

function DeleteUnusedEnumElement : boolean;
begin
DeleteUnusedEnumElement := DeleteUnusedType;   /* vorerst */
end;

function DeleteUnusedConst : boolean;
begin
DeleteUnusedConst := DeleteUnusedType;   /* vorerst */
end;

function UseSymbolicConst : boolean;
begin
UseSymbolicConst := control['c'];
end;

function DontReduceAnything : boolean;
begin
DontReduceAnything := not (DeleteUnusedType or DeleteUnusedVar);
end;

/* ----------------------------------------------------------------------- */

procedure markT;   /*  (Idx : integer)  */
begin
if not IsMarked(Idx)
then
  begin
  Mark(Idx);
  if STab[Idx].SKind = TypeDcl
  then
    case STab[Idx].SType of
    RecordType:
      M_RecordType(Idx);  /* ist das einzige etwas kompliziertere! */
    PointerType:
      begin
      if not BreakPointerType
      then
        markT(STab[Idx].SDomain)
      /* else: wir kappen, ggf. machen wir integer-pointer daraus */
      end;
    ArrayType:
      markT(STab[Idx].SElement);
    EnumerativeType:
      if STab[Idx].STmyname > 0
      then
        markT(STab[Idx].STmyname);
    otherwise:
      begin
      /* spaeter ergaenzen! */
      end;
    end
  else
    if (STab[Idx].SKind = TypeNameDcl) or (STab[Idx].SKind = TagNameDcl)
    then
      markT(STab[Idx].SType);
  end;
end;


function UnmarkedType(Idx:integer): boolean;
begin
UnmarkedType := ((STab[Idx].SKind = TypeNameDcl) or
                 (STab[Idx].SKind = TypeDcl)) and
                not IsMarked(Idx);
end;

function UnmarkedVar(Idx:integer): boolean;
begin
UnmarkedVar := ((STab[Idx].SKind = VarDcl) or
                (STab[Idx].SKind = ParmDcl)) and
               not IsMarked(Idx);
end;

