#!/usr/bin/perl
#
# $SRC/install/perl/Makefile.PL
#
# $Header: //sapdb/V74/develop/sys/src/install/perl/Makefile.PL#16 $
# $DateTime: 2002/04/05 17:29:04 $
# $Change: 19075 $
#
#
#    ========== licence begin LGPL
#    Copyright (C) 2002 SAP AG
#
#    This library is free software; you can redistribute it and/or
#    modify it under the terms of the GNU Lesser General Public
#    License as published by the Free Software Foundation; either
#    version 2.1 of the License, or (at your option) any later version.
#
#    This library is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#    Lesser General Public License for more details.
#
#    You should have received a copy of the GNU Lesser General Public
#    License along with this library; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#    ========== licence end
#


use Config;
use Symbol;

my $win_in_wdf = 0;

sub main {
	print 
	"Generating Makefile for SAPDB Install extensions\n";

	$win_in_wdf = is_win_in_wdf ();

	my %Makedefs = (
	'PERL_PERL' => get_perl (),
	'PERL_PERLLIB' => get_perllib (),
	'PERL_PERLLIBPATH' => get_perllibpath (),
	'PERL_COREDIR' => get_coredir (),
	'PERL_XSUBPP' => get_xsubpp (),
	'PERL_TXT2INC' => get_txt2inc (),
	'PERL_CHG2INC' => get_chg2inc (),
	'PERL_CHG2PM' => get_chg2pm (),
	'PERL_MKDIR' => get_mkdir (),
	'PERL_RM' => get_rm (),
	'PERL_CP' => get_cp (),
	'PERL_INST_PREFIX' => get_inst_prefix (),
	'PERL_INST_SAPDB_INSTALL' => get_inst_sapdb_install (),
	'PERL_CCFLAGS' => $Config{'ccflags'}." ".$Config{'cccdlflags'},
	'PERL_DEFS' => get_defs (),
	'PERL_INC' => "\$(PERL_COREDIR)",
	'PERL_INCLUDE' => "-I\$(PERL_COREDIR)",
	'PERL_CFLAGS' => "\$(PERL_CCFLAGS) \$(PERL_INCLUDE) \$(PERL_DEFS)",
	'PERL_DLD' => $^O =~ /^mswin/i ? "link" : $Config{'ld'},
	'PERL_DLDFLAGS' => get_dldflags (),
	'PERL_CC' => $Config{'cc'},
	'PERL_LD' => $^O =~ /^mswin/i ? "link" : "\$(PERL_CC)",
	'PERL_LDFLAGS' => get_ldflags (),
	'PERL_DLEXT' => $Config{'dlext'},
	'PERL_OBJEXT' => $Config{'obj_ext'},
	'PERL_EXEEXT' => $Config{'exe_ext'},
	'PERL_EXTLIBS' => get_extlibs (),
	'PERL_VERSION_PM' => get_version_pm ());

	write_makefile (%Makedefs);

	#
	# setup include path for cross compilation environment
	#
	if ($^O =~ /mswin/i && $Config{'archname'} =~ /IA64/) {
		push @INC, "../win64/libx86", "../win64/lib";
	}
	chdir ("zlib"); do ("Makefile.PL"); chdir ("..");
	chdir ("zip"); do ("Makefile.PL"); chdir ("..");
}

sub write_makefile {
	my %Makedefs = @_;
	my $fh = gensym ();
	open ($fh, "> Makefile");
	print ($fh
	"#\n".
	"# Makefile\n".
	"# this file is generated from Makefile.PL\n".
	"# do not edit this file, any changes will be lost\n".
	"#\n".
	"\n".	
	".SUFFIXES:\n".
	".SUFFIXES: .o .c .xs\n".
	"\n");

	if ($^O =~ /^aix/) {
		print ($fh
		"#\n".
		"# make sure that we are in 32 bit mode on aix\n".
		"#\n".
		"OBJECT_MODE = 32\n".
		"\n");
	}

	while (my ($key, $value) = each %Makedefs) {
		next unless (defined $value);
		print ($fh $key." = ".$value."\n");
	}
	print $fh ("\n");

	write_body ($fh);
	close ($fh);
}

sub write_body {
	my $fh = shift;
	while (<DATA>) {
		chomp;
		if ($^O =~ /^aix/ && $_ =~ /-o (\w+)\.\$\(DLEXT\)/) {
			$_ .= " -bE:".$1.".exp";
		}
		if ($^O =~ /^mswin/i) {
			if ($_ =~ /-o (\w+)\.\$\(DLEXT\)/) {
				$_ .= " -def:".$1.".def";
				$_ =~ s/-o\s+/-out:/;
			} elsif ($_ =~ /-o \w+\$\(EXEEXT\)/) {
				$_ =~ s/-o\s+/-out:/;
			}
		}
		print ($fh $_."\n");
	}
}

sub is_win_in_wdf {
	my $toolshell = $ENV{TOOLSHELL};

	return 0 unless (defined $toolshell);

	return 1 if ($toolshell =~ /\\depot\\tools\\gen\\ntintel\\OpenSource/i);
	return 0;
}

sub get_perl {
	return $ENV{'TOOLSHELL'} if ($win_in_wdf != 0);

	# WIN32 IA64 cross compiler
	return ("win64\\binx86\\perl -I win64\\libx86;win64\\lib")
		if ($^O =~ /mswin/i && $Config{'archname'} =~ /IA64/);

	# WIN32 standard perl
	return ("win32\\bin\\perl")
		if ($^O =~ /mswin/i && $Config{'archname'} !~ /object/ && -f 'win32/bin/perl.exe');  

	# UNIX or WIN32 Active State perl
	return $ENV{'TOOLSHELL'} if (defined $ENV{'TOOLSHELL'});
	return "perl";
}

sub get_perllib {

	# UNIX
	return "libperl.a" unless ($^O =~ /mswin/i);


	if(defined $Config{'libperl'}){
		return $Config{'libperl'};
	}


	return "perl58.lib"  if (defined $^V && ($^V eq v5.8.4 || 
											$^V eq v5.8.3 || 
											$^V eq v5.8.2 || 
											$^V eq v5.8.1 || 
											$^V eq v5.8.0 ));

	# WIN32 Active State Perl
  	return "PerlCRT.lib" if $Config{'archname'} =~ /object/;
	
	# WIN32 standard perl 5.6
	return "perl56.lib" if (defined $^V && $^V eq v5.6.0);

	# WIN32 standard perl 5.6
	return "perl56.lib" if (defined $^V && $^V eq v5.6.1);

	# WIN32 standard perl 5.0 or earlier
	return "perl.lib";
}

sub get_perllibpath {
	return ("d:\\depot\\tools\\gen\\ntintel\\OpenSource\\perl\\5.6.0\\lib\\MSWin32-x86\\CORE") if ($win_in_wdf != 0);

	$^O =~ /mswin/i &&  $Config{'archname'} =~ /IA64/ ?
	"win64\\lib" :
	$^O =~ /mswin/i ? "win32\\lib" :
	"";
}

sub get_version_pm {
	$^O =~ /mswin/i ? "SAPDB\\Install\\Version.pm" :
	                  "SAPDB/Install/Version.pm";
}

sub get_dldflags {
	$^O =~ /aix/    ? get_dldflags_aix () :
	$^O =~ /mswin/i ? 
	$Config{'lddlflags'}." -libpath:\$(PERL_COREDIR) \$(PERL_PERLLIB)" :
	$Config{'lddlflags'};
}

sub get_dldflags_aix {
	my @in = split (' ', $Config{'lddlflags'});
	my @out = ();
	foreach $_ (@in) {
		next if ($_ =~ /^-bE\:/);
		push @out, $_;
	}
	return (join " ", @out);
}

sub get_extlibs {
	$^O =~ /mswin/i   ? $Config{'libs'} :
	$^O =~ /^aix/     ? "-lm -lbsd" :
	$^O =~ /^dec_osf/ ? "-lm" :
	$^O =~ /^hpux/    ? "-lm" :
	$^O =~ /^linux/ && $Config{'archname'} =~ /^i\d86/ ? "-lm -lcrypt" :
	$^O =~ /^solaris/ ? "-lm -lsocket -lnsl" :
	$^O =~ /^svr4/ && $Config{'archname'} =~ /^RM/ ? 
		"-lm -lsocket -lnsl -L/usr/ucblib -lucb" :
	"";	
}

sub get_xsubpp {
	return ("\$(PERL) -I\$(PERLLIBPATH) d:\\depot\\tools\\gen\\ntintel\\OpenSource\\perl\\5.6.0\\lib\\ExtUtils\\xsubpp") if ($win_in_wdf != 0);

	$^O =~ /^mswin/i  ? 
	"\$(PERL) -I\$(PERLLIBPATH) ".$Config{'privlibexp'}."\\ExtUtils\\xsubpp" :
	"\$(PERL) ".$Config{'privlibexp'}."/ExtUtils/xsubpp";
}

sub get_mkdir {
	$^O =~ /^mswin/i ? "mkdir" : "-mkdir -p";
}

sub get_rm {
	$^O =~ /^mswin/i ? "del" : "-rm";
}

sub get_cp {
	$^O =~ /^mswin/i ? "copy" : "cp";
}

sub get_inst_prefix {
	$^O =~ /^mswin/i ? $ENV{'Tool'}."\\lib\\Perl" :
	$ENV{'TOOL'}."/lib/perl5";
}


sub get_inst_sapdb_install {
	if ($^O =~ /mswin/i) {
		return ((get_inst_prefix ())."\\SAPDB\\Install");
	} 

	return ((get_inst_prefix ())."/SAPDB/Install");
}

sub get_txt2inc {
	$^O =~ /^mswin/i  ? 
	"\$(PERL) tool\\txt2inc" :
	"\$(PERL) tool/txt2inc";
}

sub get_chg2inc {
	$^O =~ /^mswin/i  ? 
	"\$(PERL) tool\\chg2inc" :
	"\$(PERL) tool/chg2inc";
}

sub get_chg2pm {
	$^O =~ /^mswin/i  ? 
	"\$(PERL) tool\\chg2pm" :
	"\$(PERL) tool/chg2pm";
}

sub get_coredir {
	return ("d:\\depot\\tools\\gen\\ntintel\\OpenSource\\perl\\5.6.0\\lib\\MSWin32-x86\\CORE") if ($win_in_wdf != 0);

	$^O =~ /^mswin/i ? $Config{'archlibexp'}."\\CORE" :
	$Config{'archlibexp'}."/CORE"
}

sub get_ldflags {
	$^O =~ /mswin/i ? 
	"-nodefaultlib -libpath:\$(PERL_COREDIR) \$(PERL_PERLLIB)" :
        $^O =~ /hpux/ ? $ENV{'MACH'} =~ /HP_IA64/ ?
                "-DD64 -L\$(PERL_COREDIR) -lperl" :
                "+DA1.1 +DS2.0 -L\$(PERL_COREDIR) -lperl" :
	$^O =~ /svr4/ && $Config{'archname'} =~ /^RM/ ? 
		"-Bstatic -L\$(PERL_COREDIR) -lperl -Bdynamic" :
	"-L\$(PERL_COREDIR) -lperl";
}

sub get_defs {
	$^O =~ /mswin/i ?
	"/Zm200 -DHAS_BYTEORDER=".$Config{'byteorder'} :
	"-DHAS_BYTEORDER=".$Config{'byteorder'};
}

main (@ARGV);

__DATA__
RM = $(PERL_RM)
LD = $(PERL_LD)
CP = $(PERL_CP)
MKDIR = $(PERL_MKDIR)

INST_PREFIX = $(PERL_INST_PREFIX)
INST_SAPDB_INSTALL = $(PERL_INST_SAPDB_INSTALL)

PERL = $(PERL_PERL)
PERLLIBPATH = $(PERL_PERLLIBPATH)

TXT2INC = $(PERL_TXT2INC)
CHG2INC = $(PERL_CHG2INC)
CHG2PM = $(PERL_CHG2PM)
XSUBPP = $(PERL_XSUBPP)

CFLAGS = $(PERL_CFLAGS)
DLD = $(PERL_DLD)
DLD_FLAGS = $(PERL_DLDFLAGS)
LIBS = $(PERL_EXTLIBS)
LD_FLAGS = $(PERL_LDFLAGS)
DLEXT = $(PERL_DLEXT)
OBJEXT = $(PERL_OBJEXT)
EXEEXT = $(PERL_EXEEXT)
PM = pm

.xs.c:
	$(XSUBPP) $*.xs > $*.c
 
.c$(OBJEXT):
	$(PERL_CC) -c $(CFLAGS) $<

SysInfo_OBJ = SysInfo$(OBJEXT)
Jar_OBJ =Jar$(OBJEXT)
PipeExec_OBJ =PipeExec$(OBJEXT)
ProcState_OBJ = ProcState$(OBJEXT)

ZLIB_OBJ = zlib/zlib.ro
ZIPLIB_OBJ = zip/ziplib.ro

ALL_PL_H = SysInfo.h Jar.h PipeExec.h

ALL_XS_C = SysInfo.c Jar.c PipeExec.c ProcState.c

ALL_XS_OBJ = $(SysInfo_OBJ) $(Jar_OBJ) $(PipeExec_OBJ) $(ProcState_OBJ)

ALL_XS_DLL = SysInfo.$(DLEXT) Jar.$(DLEXT) PipeExec.$(DLEXT) ProcState.$(DLEXT)

all: $(ALL_XS_DLL)

$(ZLIB_OBJ):
	cd zlib && $(MAKE)

$(ZIPLIB_OBJ):
	cd zip && $(MAKE)
	
ProcState.$(DLEXT): $(ProcState_OBJ)
	$(DLD) $(DLD_FLAGS) -o ProcState.$(DLEXT) $(ProcState_OBJ) $(LIBS)

ProcState$(OBJEXT): ProcState.c
	$(PERL_CC) -c $(CFLAGS) ProcState.c
	
ProcState.c: ProcState.xs
	$(XSUBPP) $*.xs > $*.c


Jar.$(DLEXT): $(Jar_OBJ) $(ZIPLIB_OBJ) $(ZLIB_OBJ)
	$(DLD) $(DLD_FLAGS) -o Jar.$(DLEXT) $(Jar_OBJ) $(ZIPLIB_OBJ) $(ZLIB_OBJ) $(LIBS)

Jar$(OBJEXT): Jar.c Jar.h
	$(PERL_CC) -c $(CFLAGS) Jar.c

Jar.h: Jar.pl
	$(TXT2INC) Jar.pl Jar.h sz_text

Jar.c: Jar.xs
	$(XSUBPP) $*.xs > $*.c 
 
SysInfo.$(DLEXT): $(SysInfo_OBJ)
	$(DLD) $(DLD_FLAGS) -o SysInfo.$(DLEXT) $(SysInfo_OBJ) $(LIBS)

SysInfo$(OBJEXT): SysInfo.c SysInfo.h
	$(PERL_CC) -c $(CFLAGS) SysInfo.c

SysInfo.h: SysInfo.pl
	$(TXT2INC) SysInfo.pl SysInfo.h sz_text

SysInfo.c: SysInfo.xs SysInfo.h
	$(XSUBPP) $*.xs > $*.c
 
PipeExec.$(DLEXT): $(PipeExec_OBJ)
	$(DLD) $(DLD_FLAGS) -o PipeExec.$(DLEXT) $(PipeExec_OBJ) $(LIBS)

PipeExec$(OBJEXT): PipeExec.c PipeExec.h
	$(PERL_CC) -c $(CFLAGS) PipeExec.c

PipeExec.h: PipeExec.pl
	$(TXT2INC) PipeExec.pl PipeExec.h sz_text

PipeExec.c: PipeExec.xs PipeExec.h
	$(XSUBPP) $*.xs > $*.c
 
install: all
	-$(MKDIR) $(INST_PREFIX)
	-$(MKDIR) $(INST_SAPDB_INSTALL)
	-$(RM) $(INST_PREFIX)/SysInfo.$(DLEXT) 
	-$(RM) $(INST_PREFIX)/PipeExec.$(DLEXT) 
	-$(RM) $(INST_PREFIX)/Jar.$(DLEXT) 
	$(CP) *.$(DLEXT) $(INST_PREFIX)
	$(CP) *.$(PM) $(INST_SAPDB_INSTALL)

clean:
	cd zlib && $(MAKE) clean
	cd zip && $(MAKE) clean
	$(RM) $(ALL_PL_H)
	$(RM) $(ALL_XS_C) 
	$(RM) $(ALL_XS_OBJ) 
	$(RM) $(ALL_XS_DLL)
	$(RM) Makefile

