/***************************************************************************
 *   Copyright (C) 2005-2006 by Robert Maxe                                *
 *   mutex@spray.se                                                        *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
//-----------------------------------------------------------------------------------------------------------------------
#include <kpopupmenu.h>
#include <klocale.h>
#include <kfiledialog.h>
#include <qspinbox.h>
#include <qpushbutton.h>
#include "mainwidget.h"
#include "channelitem.h"
#include "channelview.h"
#include "wrenamedialog.h"
//-----------------------------------------------------------------------------------------------------------------------
ChannelView::ChannelView(MainWidget *parent, KListView *lv)
{
	m_parent = parent;
	m_lv = lv;
//	m_parent->lv_channel->setItemMargin(2);
	connect(m_lv, SIGNAL(contextMenu(KListView*, QListViewItem*, const QPoint&)), this, SLOT(showPopupMenu(KListView*, QListViewItem*, const QPoint&)));
	connect(m_parent->pb_sortmode, SIGNAL(toggled(bool)), this, SLOT(channelSortMode(bool)));
	connect(m_lv, SIGNAL(selectionChanged()), m_parent, SLOT(refresh()));
//	connect(m_parent->cb_noneshowsall, SIGNAL(toggled(bool)), m_parent, SLOT(refresh()));
}
//-----------------------------------------------------------------------------------------------------------------------
void ChannelView::update()
{
	QPtrList<Channel> *channels = m_parent->channels();
	Channel *channel;

	m_lv->clear();
	for(uint i=0; i<channels->count(); i++) {
		channel = channels->at(i);
		new ChannelItem(m_parent, m_lv, channel);
	}
}
//-----------------------------------------------------------------------------------------------------------------------
void ChannelView::showPopupMenu(KListView*, QListViewItem*, const QPoint&)
{
	QListViewItemIterator it(m_lv, QListViewItemIterator::Selected);
	ChannelItem *ci;
	int renCnt = 0, imgCnt = 0, selCnt = 0;
	
	if(!it.current()) return;
	
	while(it.current()) {
		ci = (ChannelItem*)it.current();
		if(ci->channel()->hasCustomName())
			renCnt++;
		if(ci->channel()->hasCustomImage())
			imgCnt++;
		selCnt++;
		++it;
	}
	
	KPopupMenu *chanMenu = new KPopupMenu(m_parent);

	int a = chanMenu->insertItem(i18n("Rename Channel..."), this, SLOT(renameChannel()));
	if(selCnt != 1)
		chanMenu->setItemEnabled(a, false);
	int b = chanMenu->insertItem((renCnt>1?(i18n("Restore Names")):(i18n("Restore Name"))), this, SLOT(restoreName()));
	if(renCnt < 1)
		chanMenu->setItemEnabled(b, false);
	chanMenu->insertSeparator();
	int c = chanMenu->insertItem(i18n("Custom Image..."), this, SLOT(customImage()));
	if(selCnt != 1)
		chanMenu->setItemEnabled(c, false);
	
	int d = chanMenu->insertItem(i18n("Default Image"), this, SLOT(defaultImage()));
	if(imgCnt < 1)
		chanMenu->setItemEnabled(d, false);

	chanMenu->exec(QCursor::pos());

	delete chanMenu;
}
//-----------------------------------------------------------------------------------------------------------------------
void ChannelView::restoreName()
{
	QListViewItemIterator it(m_lv, QListViewItemIterator::Selected);
	ChannelItem *ci;
	
	if(!it.current()) return;
	
	while(it.current()) {
		ci = (ChannelItem*)it.current();
		ci->channel()->setCustomName("");
		++it;
	}
	update();
	m_parent->activeView()->rebuild();
}
//-----------------------------------------------------------------------------------------------------------------------
void ChannelView::renameChannel()
{
	QListViewItemIterator it(m_lv, QListViewItemIterator::Selected);
	ChannelItem *ci;
	
	if(!it.current()) return;
	ci = (ChannelItem*)it.current();

	RenameDialog renDia;
	renDia.le_channame->setText(ci->channel()->customName());
	renDia.tl_originalchanname->setText(i18n("Original") + ": " + ci->channel()->name());
	
	if(renDia.exec() == QDialog::Accepted && renDia.le_channame->text().length() > 0) {
		ci->channel()->setCustomName(renDia.le_channame->text());
		update();
		m_parent->activeView()->rebuild();
	}
}
//-----------------------------------------------------------------------------------------------------------------------
void ChannelView::channelSortMode(bool isOn)
{
	if(isOn) {
		m_lv->setSorting(-1);
		m_lv->setSelectionMode(QListView::Single);
		m_lv->setDragEnabled(true);
		m_lv->setAcceptDrops(true);
	} else {
		QListViewItemIterator it(m_lv);
		int prio = 1000;
		while(it.current()) {
			((ChannelItem*)it.current())->channel()->setPrio(prio--);
			++it;
		}
		m_lv->setDragEnabled(false);
		m_lv->setAcceptDrops(false);
		m_lv->setSelectionMode(QListView::Multi);
		m_lv->setSorting(0);
		m_parent->activeView()->listView()->sort();
	}
}
//-----------------------------------------------------------------------------------------------------------------------
void ChannelView::customImage()
{
	QListViewItemIterator it(m_lv, QListViewItemIterator::Selected);
	ChannelItem *ci = (ChannelItem*)it.current();
	if(!ci) return;

	QString imageLocation = KFileDialog::getOpenFileName(ci->channel()->customImage(), "*.png *.jpg *.gif", m_parent, i18n("Please choose Channel Image to use..."));
	if(imageLocation == "" || imageLocation == QString::null) return;
	ci->channel()->setCustomImage(imageLocation);
	update();
}
//-----------------------------------------------------------------------------------------------------------------------
void ChannelView::defaultImage()
{
	QListViewItemIterator it(m_lv, QListViewItemIterator::Selected);
	ChannelItem *ci = (ChannelItem*)it.current();
	if(!ci) return;

	ci->channel()->setCustomImage("");
	ci->channel()->clearImage();
	update();
}
//-----------------------------------------------------------------------------------------------------------------------
