/***************************************************************************
 *   Copyright (C) 2005 by Robert Maxe                                     *
 *   mutex@spray.se                                                        *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
//-----------------------------------------------------------------------------------------------------------------------
#ifndef __FAVOURITEMASTER_H__
#define __FAVOURITEMASTER_H__
//-----------------------------------------------------------------------------------------------------------------------
#include <klistview.h>
#include <kprocess.h>
#include <kconfig.h>
#include <kglobal.h>
#include <qstringlist.h>
#include <qptrlist.h>
#include <qobject.h>
#include "remindwindow.h"
#include "program.h"
//-----------------------------------------------------------------------------------------------------------------------
class MainWidget;
//-----------------------------------------------------------------------------------------------------------------------
class FavouriteMaster : public QObject
{
	Q_OBJECT
public:
	FavouriteMaster(MainWidget *parent);
	~FavouriteMaster();

	bool isFavourite(QString title);
	void loadFavourites(KConfig *cfg = KGlobal::config());
	void saveFavourites(KConfig *cfg = KGlobal::config());
	void showReminder(QPtrList<Program> *programs, bool showPopup, bool executeCmd);
	void showPopupWindow(Program *program);

public slots:
	void addFavourite();
	void removeFavourite();
	void showPopupMenu(KListView*, QListViewItem*, const QPoint&);
	void removeStringFavourite();
	void processExited(KProcess *proc) { delete proc; }
	void executeCommand();
	void toggleFavourite();

private:
	MainWidget *m_parent;
	QStringList m_favourites;
	QPtrList<RemindWindow> m_dialogs;

};
//-----------------------------------------------------------------------------------------------------------------------
#endif
//-----------------------------------------------------------------------------------------------------------------------
