/***************************************************************************
 *   Copyright (C) 2005 by Robert Maxe                                     *
 *   mutex@spray.se                                                        *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
//-----------------------------------------------------------------------------------------------------------------------
#include <kconfig.h>
#include <kglobal.h>
#include "maxemumtvguide.h"
//-----------------------------------------------------------------------------------------------------------------------
MaxemumTVGuide::MaxemumTVGuide(KUniqueApplication *parent) : KMainWindow(0, "maxemumtvguide"), m_actionCollection(this),
	m_okToClose(false)
{
	m_parent = parent;
	setXMLFile("maxemumtvguideui.rc");
	m_widget = new MainWidget(this);
	setCaption("Maxemum TV-Guide");
	setCentralWidget(m_widget);

	readProperties(0);
	new KAction("Hide", Key_Escape, this, SLOT(hide()), &m_actionCollection, "Hide");
}
//-----------------------------------------------------------------------------------------------------------------------
MaxemumTVGuide::~MaxemumTVGuide()
{
	saveProperties(0);
	delete m_widget;
}
//-----------------------------------------------------------------------------------------------------------------------
bool MaxemumTVGuide::queryClose()
{
	if(m_parent->sessionSaving() || m_widget->okToClose() || m_okToClose)
		return(true);
	hide();
	return(false);
}
//-----------------------------------------------------------------------------------------------------------------------
void MaxemumTVGuide::saveProperties(KConfig*)
{
	KConfig *cfg = KGlobal::config();

	m_widget->saveSettings();
	cfg->setGroup("MTVG");
	saveWindowSize(cfg);
	cfg->writeEntry("position", pos());
	cfg->sync();
}
//-----------------------------------------------------------------------------------------------------------------------
void MaxemumTVGuide::readProperties(KConfig*)
{
	KConfig *cfg = KGlobal::config();

	m_widget->loadSettings();
	cfg->setGroup("MTVG");
	restoreWindowSize(cfg);
	move(cfg->readPointEntry("position", 0));
	hide();
}
//-----------------------------------------------------------------------------------------------------------------------
#include "maxemumtvguide.moc"
//-----------------------------------------------------------------------------------------------------------------------
