""" Deletes a resource. """


# Standard library imports.
import logging, sys

# Enthought library imports.
from enthought.envisage.ui import SelectionListenerAction
from enthought.naming.api import ContextAdapter
from enthought.pyface.api import confirm, error, YES


# Setup a logger for this module.
logger=logging.getLogger(__name__)


class DeleteAction(SelectionListenerAction):
    """ Deletes a resource. """

    ###########################################################################
    # 'Action' interface.
    ###########################################################################

    def perform(self, event):
        """ Performs the action. """

        # fixme: In terms of the whole UI model thang... This method would
        # be a method on the project UI service, and '_delete_nodes' would
        # be a method on the project service?!?  The scripting layer can then
        # expose both methods...
        selection = self.window.selection

        # Give the user a chance to back out!
        prefix = "Are you sure you want to delete %s?"
        if len(selection) == 1:
            resource_type = self.resource_manager.get_type_of(selection[0].obj)
            name = resource_type.node_type.get_text(selection[0])
            message = prefix % "'%s'" % name

        else:
            message = prefix % "these %d resources" % len(selection)

        if confirm(self.window.control, message) == YES:
            try:
                self._delete_nodes(selection)

            except Exception, msg:
                type, value, traceback = sys.exc_info()
                error(self.window.control, "Delete failed\n%s" % str(value))
                logger.exception(traceback)

        return

    ###########################################################################
    # 'SelectionListenerAction' interface.
    ###########################################################################

    def refresh(self):
        """ Refresh the enabled/disabled state of the action. """

        if self.window is not None and len(self.window.selection) > 0:
            for node in self.window.selection:

                # It is the context that the node is contained in that controls
                # its deletion.
                context = node.context

                # If we have actually got a context adapter, not an actual
                # context, then the real owner of the node is the domain
                # object referenced by the adapter.
                if isinstance(context, ContextAdapter):
                    context = context.adaptee

                # Get the resource type of the context.
                resource_type = self.resource_manager.get_type_of(context)
                #print 'DeleteAction.refresh resource_type: ', resource_type

                # Can the node be copied?
                if not resource_type.node_type.can_delete(node):
                    self.enabled = False
                    break

            else:
                self.enabled = True

        else:
            self.enabled = False

        return


    ###########################################################################
    # Private interface.
    ###########################################################################

    def _delete_nodes(self, nodes):
        """ Deletes a list of nodes. """

        for node in nodes:
            node.context.unbind(node.name)

        return

#### EOF ######################################################################
