""" The base class for all resource contexts. """


# Enthought library imports.
from enthought.naming.api import Context, PyFSContext


class ResourceContext(PyFSContext):
    """ The base class for all resource contexts. """

    ###########################################################################
    # 'ResourceContext' interface.
    ###########################################################################

    def get_unique_name(self, prefix):
        """ Returns a name that is unique within the context.

        The name returned will start with the specified prefix.

        """
        
        names = self.list_names('')
        name  = prefix
        
        id = 2
        while name in names:
            name = '%s (%d)' % (prefix, id)
            id += 1

        return name

    def save(self):
        """ Saves the context. """

        self._save_context(self)
                
        return

    ###########################################################################
    # Private interface.
    ###########################################################################

    def _save_context(self, context):
        """ Saves a context. """

        for binding in context.list_bindings(''):
            # fixme: It seems like we should use:-
            #
            # context.is_context(binding.name)
            #
            # BUT that will return true if the object bound to the name is a
            # context OR can be ADAPTED to a context.  Here, we only want
            # real contexts!  Should 'is_context' ignore adapters?
            #
            # Do we even need to save contexts that aren't 'PyFSContext's?
            if isinstance(binding.obj, Context):
                self._save_context(binding.obj)

            else:
                context.rebind(binding.name, binding.obj)
                
        return
    
##### EOF #####################################################################
