""" The absolute filenames of the plugin definitions used in the application.

The only reason that we put this in a separate module is that it often entails
lots of path and filename manipulation code that tends to clutter up 'run.py'.

The important thing to realise is that all we are doing is defining a list of
strings which are the absolute filenames of the plugin definition used in the
application!

"""


# Enthought library imports.
from enthought.envisage.api import join

# We use this package to find the absolute location of the plugin definition
# files.
import enthought.envisage
import enthought.plugins
import enthought.charm
import enthought.plugins.debug


# The plugin definitions that make up the application.
PLUGIN_DEFINITIONS = [
    # Envisage plugins.
    join(enthought.envisage, 'core/core_plugin_definition.py'),
    join(enthought.envisage, 'resource/resource_plugin_definition.py'),
    join(enthought.envisage, 'workbench/workbench_plugin_definition.py'),
    join(enthought.envisage, 'action/action_plugin_definition.py'),
    join(enthought.envisage, 'workbench/action/action_plugin_definition.py'),

    # Enthought plugins.
    join(enthought.plugins, 'python_shell/python_shell_plugin_definition.py'),
    join(enthought.plugins, 'text_editor/text_editor_plugin_definition.py'),

    # Charm plugins.
    join(enthought.charm, 'plugin/charm/plugin_definition.py'),

    # Debugging.
    join(enthought.envisage, 'internal/internal_plugin_definition.py'),
    join(enthought.plugins.debug, 'fbi_plugin_definition.py'),
]

# The plugin definitions that we want to import from but don't want as part of
# the application.
INCLUDE = []

#### EOF ######################################################################
