""" The absolute filenames of the plugin definitions used in the application.

The only reason that we put this in a separate module is that it often entails
lots of path and filename manipulation code that tends to clutter up 'run.py'.

The important thing to realise is that all we are doing is defining a list of
strings which are the absolute filenames of the plugin definition used in the
application!

"""


# Enthought library imports.
from enthought.envisage.api import join

# We use this package to find the absolute location of the plugin definition
# files.
from enthought import envisage


# The plugin definitions required by the application.
PLUGIN_DEFINITIONS = [
    # Envisage plugins.
    join(envisage, 'core/core_plugin_definition.py'),
    join(envisage, 'ui/ui_plugin_definition.py'),
    join(envisage, 'ui/preference/preference_plugin_definition.py'),
    join(envisage, 'ui/python_shell/python_shell_plugin_definition.py'),
    
    # Application plugins.
    join(envisage, 'examples/plugin/simple_ui/plugin_definition.py'),
]

# The plugin definitions that we want to import from but don't want as part of
# the application.
INCLUDE = []

#### EOF ######################################################################
