""" Displays the 'new project' wizard. """


# Enthought library imports.
from enthought.pyface.api import OK

# Plugin imports.
from enthought.envisage.project.project_plugin import ProjectPlugin
from enthought.envisage.project.wizard import NewProjectWizard

# Local imports.
from new_resource_action import NewResourceAction


class NewProjectAction(NewResourceAction):
    """ Displays the 'new project' wizard. """

    ###########################################################################
    # 'Action' interface.
    ###########################################################################

    def perform(self, event = None):
        """ Performs the action. """                

        # The available project templates.
        templates = ProjectPlugin.instance.templates
        
        wizard = NewProjectWizard(parent=self.window.control, root=templates)
        if wizard.open() == OK:
            wizard.create_resource()
            
        return

#### EOF ######################################################################
