""" A resource reference. """


# Enthought library imports.
from enthought.traits.api import Any, HasTraits


class ResourceReference(HasTraits):
    """ A resource reference.

    This is pickleable reference to a resource that has the ability to create
    (or simply find and return) the resource that it references.

    """

    #### 'ResourceReference' interface ########################################
    
    # An arbitrary piece of data that allows the reference to create (or simply
    # find and return) the resource that it references.
    data = Any

    ###########################################################################
    # 'ResourceFactory' interface.
    ###########################################################################
    
    def create_resource(self):
        """ Create the actual resource. """
        
        return self.data
    
#### EOF ######################################################################
