""" The absolute filenames of the plugin definitions used in the application.

The only reason that we put this in a separate module is that it often entails
lots of path and filename manipulation code that tends to clutter up 'run'.

The important thing to realise is that all we are doing is defining a list of
strings which are the absolute filenames of the plugin definition used in the
application!

"""


# Enthought library imports.
from enthought.envisage.api import find_definition

# The plugin definitions that make up the application.
PLUGIN_DEFINITIONS = [
    # Envisage plugins.
    find_definition('enthought.envisage.core.core_plugin_definition'),
    find_definition('enthought.envisage.resource.resource_plugin_definition'),
    find_definition('enthought.envisage.workbench.workbench_plugin_definition'),
    find_definition('enthought.envisage.action.action_plugin_definition'),
    find_definition('enthought.envisage.workbench.action.action_plugin_definition'),

    # Enthought plugins.
    find_definition('enthought.plugins.python_shell.python_shell_plugin_definition'),
    find_definition('enthought.plugins.text_editor.text_editor_plugin_definition'),

    # Charm plugins.
    find_definition('enthought.charm.plugin.charm.plugin_definition'),

    # Debugging.
    find_definition('enthought.envisage.internal.internal_plugin_definition'),
    find_definition('enthought.plugins.debug.fbi_plugin_definition'),
]

# The plugin definitions that we want to import from but don't want as part of
# the application.
INCLUDE = []

#### EOF ######################################################################
