# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.object import Object


class FunctionParser(Object):
    r"""
    FunctionParser - Parse and evaluate a mathematical expression
    
    Superclass: Object
    
    FunctionParser is a class that takes in a mathematical expression
    as a char string, parses it, and evaluates it at the specified values
    of the variables in the input string.
    
    You can use the "if" operator to create conditional expressions such
    as if ( test, trueresult, falseresult). These evaluate the boolean
    valued test expression and then evaluate either the trueresult or the
    falseresult expression to produce a final (scalar or vector valued)
    value. "test" may contain <,>,=,|,&, and () and all three
    subexpressions can evaluate arbitrary function operators (ln, cos, +,
    if, etc)
    
    @par Thanks: Juha Nieminen (juha.nieminen@gmail.com) for relicensing
    this branch of the function parser code that this class is based upon
    under the new BSD license so that it could be used in VTK. Note, the
    BSD license applies to this version of the function parser only (by
    permission of the author), and not the original library.
    
    @par Thanks: Thomas Dunne (thomas.dunne@iwr.uni-heidelberg.de) for
    adding code for two-parameter-parsing and a few functions (sign, min,
    max).
    
    @par Thanks: Sid Sydoriak (sxs@lanl.gov) for adding boolean
    operations and conditional expressions and for fixing a variety of
    bugs.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkFunctionParser, obj, update, **traits)
    
    replace_invalid_values = tvtk_base.false_bool_trait(desc=\
        r"""
        When replace_invalid_values is on, all invalid values (such as
        sqrt(-2), note that function parser does not handle complex
        numbers) will be replaced by replacement_value. Otherwise an error
        will be reported
        """
    )

    def _replace_invalid_values_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetReplaceInvalidValues,
                        self.replace_invalid_values_)

    function = traits.Trait(None, None, traits.String(enter_set=True, auto_set=False), desc=\
        r"""
        Set/Get input string to evaluate.
        """
    )

    def _function_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetFunction,
                        self.function)

    replacement_value = traits.Float(0.0, enter_set=True, auto_set=False, desc=\
        r"""
        
        """
    )

    def _replacement_value_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetReplacementValue,
                        self.replacement_value)

    def get_scalar_variable_value(self, *args):
        """
        get_scalar_variable_value(self, variableName:str) -> float
        C++: double get_scalar_variable_value(
            const std::string &variableName)
        get_scalar_variable_value(self, i:int) -> float
        C++: double get_scalar_variable_value(int i)"""
        ret = self._wrap_call(self._vtk_obj.GetScalarVariableValue, *args)
        return ret

    def set_scalar_variable_value(self, *args):
        """
        set_scalar_variable_value(self, variableName:str, value:float)
            -> None
        C++: void set_scalar_variable_value(const std::string &variableName,
            double value)
        set_scalar_variable_value(self, i:int, value:float) -> None
        C++: void set_scalar_variable_value(int i, double value)"""
        ret = self._wrap_call(self._vtk_obj.SetScalarVariableValue, *args)
        return ret

    def get_vector_variable_value(self, *args):
        """
        get_vector_variable_value(self, variableName:str) -> (float, float,
            float)
        C++: double *get_vector_variable_value(
            const std::string &variableName)
        get_vector_variable_value(self, variableName:str, value:[float,
            float, float]) -> None
        C++: void get_vector_variable_value(const std::string &variableName,
            double value[3])
        get_vector_variable_value(self, i:int) -> (float, float, float)
        C++: double *get_vector_variable_value(int i)
        get_vector_variable_value(self, i:int, value:[float, float, float])
            -> None
        C++: void get_vector_variable_value(int i, double value[3])"""
        ret = self._wrap_call(self._vtk_obj.GetVectorVariableValue, *args)
        return ret

    def set_vector_variable_value(self, *args):
        """
        set_vector_variable_value(self, variableName:str, xValue:float,
            yValue:float, zValue:float) -> None
        C++: void set_vector_variable_value(const std::string &variableName,
            double xValue, double yValue, double zValue)
        set_vector_variable_value(self, variableName:str, values:(float,
            float, float)) -> None
        C++: void set_vector_variable_value(const std::string &variableName,
            const double values[3])
        set_vector_variable_value(self, i:int, xValue:float, yValue:float,
            zValue:float) -> None
        C++: void set_vector_variable_value(int i, double xValue,
            double yValue, double zValue)
        set_vector_variable_value(self, i:int, values:(float, float, float))
            -> None
        C++: void set_vector_variable_value(int i, const double values[3])"""
        ret = self._wrap_call(self._vtk_obj.SetVectorVariableValue, *args)
        return ret

    def _get_number_of_scalar_variables(self):
        return self._vtk_obj.GetNumberOfScalarVariables()
    number_of_scalar_variables = traits.Property(_get_number_of_scalar_variables, desc=\
        r"""
        Get the number of scalar variables.
        """
    )

    def _get_number_of_vector_variables(self):
        return self._vtk_obj.GetNumberOfVectorVariables()
    number_of_vector_variables = traits.Property(_get_number_of_vector_variables, desc=\
        r"""
        Get the number of vector variables.
        """
    )

    def _get_scalar_result(self):
        return self._vtk_obj.GetScalarResult()
    scalar_result = traits.Property(_get_scalar_result, desc=\
        r"""
        Get a scalar result from evaluating the input function.
        """
    )

    def get_scalar_variable_index(self, *args):
        """
        get_scalar_variable_index(self, name:str) -> int
        C++: int get_scalar_variable_index(const std::string &name)"""
        ret = self._wrap_call(self._vtk_obj.GetScalarVariableIndex, *args)
        return ret

    def get_scalar_variable_name(self, *args):
        """
        get_scalar_variable_name(self, i:int) -> str
        C++: const char *get_scalar_variable_name(int i)
        Get the ith scalar variable name.
        """
        ret = self._wrap_call(self._vtk_obj.GetScalarVariableName, *args)
        return ret

    def get_scalar_variable_needed(self, *args):
        """
        get_scalar_variable_needed(self, i:int) -> bool
        C++: bool get_scalar_variable_needed(int i)
        get_scalar_variable_needed(self, variableName:str) -> bool
        C++: bool get_scalar_variable_needed(const std::string &variableName)
        Returns whether a scalar variable is needed for the function
        evaluation. This is only valid after a successful Parse(). Thus,
        call get_scalar_result() or is_scalar_result() or similar method
        before calling this.
        """
        ret = self._wrap_call(self._vtk_obj.GetScalarVariableNeeded, *args)
        return ret

    def _get_vector_result(self):
        return self._vtk_obj.GetVectorResult()
    vector_result = traits.Property(_get_vector_result, desc=\
        r"""
        Get a vector result from evaluating the input function.
        """
    )

    def get_vector_result(self, *args):
        """
        get_vector_result(self) -> (float, float, float)
        C++: double *get_vector_result()
        get_vector_result(self, result:[float, float, float]) -> None
        C++: void get_vector_result(double result[3])
        Get a vector result from evaluating the input function.
        """
        ret = self._wrap_call(self._vtk_obj.GetVectorResult, *args)
        return ret

    def get_vector_variable_index(self, *args):
        """
        get_vector_variable_index(self, name:str) -> int
        C++: int get_vector_variable_index(const std::string &name)"""
        ret = self._wrap_call(self._vtk_obj.GetVectorVariableIndex, *args)
        return ret

    def get_vector_variable_name(self, *args):
        """
        get_vector_variable_name(self, i:int) -> str
        C++: const char *get_vector_variable_name(int i)
        Get the ith vector variable name.
        """
        ret = self._wrap_call(self._vtk_obj.GetVectorVariableName, *args)
        return ret

    def get_vector_variable_needed(self, *args):
        """
        get_vector_variable_needed(self, i:int) -> bool
        C++: bool get_vector_variable_needed(int i)
        get_vector_variable_needed(self, variableName:str) -> bool
        C++: bool get_vector_variable_needed(const std::string &variableName)
        Returns whether a vector variable is needed for the function
        evaluation. This is only valid after a successful Parse(). Thus,
        call get_vector_result() or is_vector_result() or similar method
        before calling this.
        """
        ret = self._wrap_call(self._vtk_obj.GetVectorVariableNeeded, *args)
        return ret

    def invalidate_function(self):
        """
        invalidate_function(self) -> None
        C++: void invalidate_function()
        Allow the user to force the function to be re-parsed
        """
        ret = self._vtk_obj.InvalidateFunction()
        return ret
        

    def is_scalar_result(self):
        """
        is_scalar_result(self) -> int
        C++: int is_scalar_result()
        Check whether the result is a scalar result.  If it isn't, then
        either the result is a vector or an error has occurred.
        """
        ret = self._vtk_obj.IsScalarResult()
        return ret
        

    def is_vector_result(self):
        """
        is_vector_result(self) -> int
        C++: int is_vector_result()
        Check whether the result is a vector result.  If it isn't, then
        either the result is scalar or an error has occurred.
        """
        ret = self._vtk_obj.IsVectorResult()
        return ret
        

    def remove_all_variables(self):
        """
        remove_all_variables(self) -> None
        C++: void remove_all_variables()
        Remove all the current variables.
        """
        ret = self._vtk_obj.RemoveAllVariables()
        return ret
        

    def remove_scalar_variables(self):
        """
        remove_scalar_variables(self) -> None
        C++: void remove_scalar_variables()
        Remove all the scalar variables.
        """
        ret = self._vtk_obj.RemoveScalarVariables()
        return ret
        

    def remove_vector_variables(self):
        """
        remove_vector_variables(self) -> None
        C++: void remove_vector_variables()
        Remove all the vector variables.
        """
        ret = self._vtk_obj.RemoveVectorVariables()
        return ret
        

    _updateable_traits_ = \
    (('replace_invalid_values', 'GetReplaceInvalidValues'), ('debug',
    'GetDebug'), ('global_warning_display', 'GetGlobalWarningDisplay'),
    ('function', 'GetFunction'), ('replacement_value',
    'GetReplacementValue'), ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'global_warning_display', 'replace_invalid_values',
    'function', 'replacement_value'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(FunctionParser, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit FunctionParser properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['replace_invalid_values'], [], ['function',
            'replacement_value']),
            title='Edit FunctionParser properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit FunctionParser properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

