# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.open_gl_render_window import OpenGLRenderWindow


class GenericOpenGLRenderWindow(OpenGLRenderWindow):
    r"""
    GenericOpenGLRenderWindow - platform independent render window
    
    Superclass: OpenGLRenderWindow
    
    GenericOpenGLRenderWindow provides a skeleton for implementing a
    render window using one's own open_gl context and drawable. To be
    effective, one must register an observer for window_make_current_event,
    window_is_current_event and window_frame_event.  When this class sends a
    window_is_current_event, the call data is an bool* which one can use to
    return whether the context is current.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkGenericOpenGLRenderWindow, obj, update, **traits)
    
    back_left_buffer = traits.Int(0, enter_set=True, auto_set=False, desc=\
        r"""
        
        """
    )

    def _back_left_buffer_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetBackLeftBuffer,
                        self.back_left_buffer)

    back_right_buffer = traits.Int(0, enter_set=True, auto_set=False, desc=\
        r"""
        
        """
    )

    def _back_right_buffer_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetBackRightBuffer,
                        self.back_right_buffer)

    current_cursor = traits.Int(0, enter_set=True, auto_set=False, desc=\
        r"""
        Overridden to invoke Command::CursorChangedEvent
        """
    )

    def _current_cursor_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetCurrentCursor,
                        self.current_cursor)

    force_maximum_hardware_line_width = traits.Trait(0.0, traits.Range(0.0, 9.999999680285692e+37, enter_set=True, auto_set=False), desc=\
        r"""
        Specify a non-zero line width to force the hardware line width
        determined by the window.
        """
    )

    def _force_maximum_hardware_line_width_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetForceMaximumHardwareLineWidth,
                        self.force_maximum_hardware_line_width)

    front_left_buffer = traits.Int(0, enter_set=True, auto_set=False, desc=\
        r"""
        set the drawing buffers to use
        """
    )

    def _front_left_buffer_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetFrontLeftBuffer,
                        self.front_left_buffer)

    front_right_buffer = traits.Int(0, enter_set=True, auto_set=False, desc=\
        r"""
        
        """
    )

    def _front_right_buffer_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetFrontRightBuffer,
                        self.front_right_buffer)

    mapped = traits.Int(0, enter_set=True, auto_set=False, desc=\
        r"""
        
        """
    )

    def _mapped_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetMapped,
                        self.mapped)

    ready_for_rendering = traits.Bool(True, enter_set=True, auto_set=False, desc=\
        r"""
        Set this to true to indicate that the context is now ready. For
        backwards compatibility reasons, it's set to true by default. If
        set to false, the `Render` call will be skipped entirely.
        """
    )

    def _ready_for_rendering_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetReadyForRendering,
                        self.ready_for_rendering)

    screen_size = traits.Array(enter_set=True, auto_set=False, shape=(2,), dtype="int", value=(0, 0), cols=2, desc=\
        r"""
        Set the size of the screen in pixels. An HDTV for example would
        be 1920 x 1080 pixels.
        """
    )

    def _screen_size_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetScreenSize,
                        self.screen_size)

    def create_a_window(self):
        """
        create_a_window(self) -> None
        
        Create a not-off-screen window.
        """
        ret = self._vtk_obj.CreateAWindow()
        return ret
        

    def destroy_window(self):
        """
        destroy_window(self) -> None
        
        Destroy a not-off-screen window.
        """
        ret = self._vtk_obj.DestroyWindow()
        return ret
        

    def pop_state(self):
        """
        pop_state(self) -> None
        C++: void pop_state()
        no-op (for API compat with open_gl1).
        """
        ret = self._vtk_obj.PopState()
        return ret
        

    def push_state(self):
        """
        push_state(self) -> None
        C++: void push_state()
        no-op (for API compat with open_gl1).
        """
        ret = self._vtk_obj.PushState()
        return ret
        

    def set_is_current(self, *args):
        """
        set_is_current(self, newValue:bool) -> None
        C++: void set_is_current(bool newValue)"""
        ret = self._wrap_call(self._vtk_obj.SetIsCurrent, *args)
        return ret

    def set_is_direct(self, *args):
        """
        set_is_direct(self, newValue:int) -> None
        C++: void set_is_direct(TypeBool newValue)
        Allow to update state within observer callback without changing
        data argument and MTime.
        """
        ret = self._wrap_call(self._vtk_obj.SetIsDirect, *args)
        return ret

    def set_own_context(self, *args):
        """
        set_own_context(self, __a:int) -> None
        C++: void set_own_context(TypeBool)"""
        ret = self._wrap_call(self._vtk_obj.SetOwnContext, *args)
        return ret

    def set_supports_open_gl(self, *args):
        """
        set_supports_open_gl(self, newValue:int) -> None
        C++: void set_supports_open_gl(int newValue)"""
        ret = self._wrap_call(self._vtk_obj.SetSupportsOpenGL, *args)
        return ret

    _updateable_traits_ = \
    (('framebuffer_flip_y', 'GetFramebufferFlipY'), ('borders',
    'GetBorders'), ('full_screen', 'GetFullScreen'), ('line_smoothing',
    'GetLineSmoothing'), ('point_smoothing', 'GetPointSmoothing'),
    ('polygon_smoothing', 'GetPolygonSmoothing'), ('stencil_capable',
    'GetStencilCapable'), ('stereo_capable_window',
    'GetStereoCapableWindow'), ('stereo_render', 'GetStereoRender'),
    ('swap_buffers', 'GetSwapBuffers'), ('use_srgb_color_space',
    'GetUseSRGBColorSpace'), ('double_buffer', 'GetDoubleBuffer'),
    ('erase', 'GetErase'), ('off_screen_rendering',
    'GetOffScreenRendering'), ('show_window', 'GetShowWindow'),
    ('use_off_screen_buffers', 'GetUseOffScreenBuffers'), ('debug',
    'GetDebug'), ('global_warning_display', 'GetGlobalWarningDisplay'),
    ('frame_blit_mode', 'GetFrameBlitMode'), ('stereo_type',
    'GetStereoType'), ('back_left_buffer', 'GetBackLeftBuffer'),
    ('back_right_buffer', 'GetBackRightBuffer'), ('current_cursor',
    'GetCurrentCursor'), ('force_maximum_hardware_line_width',
    'GetForceMaximumHardwareLineWidth'), ('front_left_buffer',
    'GetFrontLeftBuffer'), ('front_right_buffer', 'GetFrontRightBuffer'),
    ('mapped', 'GetMapped'), ('ready_for_rendering',
    'GetReadyForRendering'), ('screen_size', 'GetScreenSize'),
    ('global_maximum_number_of_multi_samples',
    'GetGlobalMaximumNumberOfMultiSamples'), ('abort_render',
    'GetAbortRender'), ('alpha_bit_planes', 'GetAlphaBitPlanes'),
    ('anaglyph_color_mask', 'GetAnaglyphColorMask'),
    ('anaglyph_color_saturation', 'GetAnaglyphColorSaturation'),
    ('cursor_file_name', 'GetCursorFileName'), ('desired_update_rate',
    'GetDesiredUpdateRate'), ('device_index', 'GetDeviceIndex'),
    ('in_abort_check', 'GetInAbortCheck'), ('multi_samples',
    'GetMultiSamples'), ('number_of_layers', 'GetNumberOfLayers'), ('dpi',
    'GetDPI'), ('position', 'GetPosition'), ('size', 'GetSize'),
    ('tile_scale', 'GetTileScale'), ('tile_viewport', 'GetTileViewport'),
    ('window_name', 'GetWindowName'), ('object_name', 'GetObjectName'),
    ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['borders', 'debug', 'double_buffer', 'erase', 'framebuffer_flip_y',
    'full_screen', 'global_warning_display', 'line_smoothing',
    'off_screen_rendering', 'point_smoothing', 'polygon_smoothing',
    'show_window', 'stencil_capable', 'stereo_capable_window',
    'stereo_render', 'swap_buffers', 'use_off_screen_buffers',
    'use_srgb_color_space', 'frame_blit_mode', 'stereo_type',
    'abort_render', 'alpha_bit_planes', 'anaglyph_color_mask',
    'anaglyph_color_saturation', 'back_left_buffer', 'back_right_buffer',
    'current_cursor', 'cursor_file_name', 'desired_update_rate',
    'device_index', 'dpi', 'force_maximum_hardware_line_width',
    'front_left_buffer', 'front_right_buffer',
    'global_maximum_number_of_multi_samples', 'in_abort_check', 'mapped',
    'multi_samples', 'number_of_layers', 'object_name', 'position',
    'ready_for_rendering', 'screen_size', 'size', 'tile_scale',
    'tile_viewport', 'window_name'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(GenericOpenGLRenderWindow, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit GenericOpenGLRenderWindow properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['borders', 'double_buffer', 'erase', 'framebuffer_flip_y',
            'full_screen', 'line_smoothing', 'off_screen_rendering',
            'point_smoothing', 'polygon_smoothing', 'show_window',
            'stencil_capable', 'stereo_capable_window', 'stereo_render',
            'swap_buffers', 'use_off_screen_buffers', 'use_srgb_color_space'],
            ['frame_blit_mode', 'stereo_type'], ['abort_render',
            'alpha_bit_planes', 'anaglyph_color_mask',
            'anaglyph_color_saturation', 'back_left_buffer', 'back_right_buffer',
            'current_cursor', 'cursor_file_name', 'desired_update_rate',
            'device_index', 'dpi', 'force_maximum_hardware_line_width',
            'front_left_buffer', 'front_right_buffer',
            'global_maximum_number_of_multi_samples', 'in_abort_check', 'mapped',
            'multi_samples', 'number_of_layers', 'object_name', 'position',
            'ready_for_rendering', 'screen_size', 'size', 'tile_scale',
            'tile_viewport', 'window_name']),
            title='Edit GenericOpenGLRenderWindow properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit GenericOpenGLRenderWindow properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

