# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.random_sequence import RandomSequence


class MinimalStandardRandomSequence(RandomSequence):
    r"""
    MinimalStandardRandomSequence - Park and Miller Sequence of pseudo
    random numbers
    
    Superclass: RandomSequence
    
    MinimalStandardRandomSequence is a sequence of statistically
    independent pseudo random numbers uniformly distributed between 0.0
    and 1.0.
    
    The sequence is generated by a prime modulus multiplicative linear
    congruential generator (PMMLCG) or "Lehmer generator" with multiplier
    16807 and prime modulus 2^(31)-1. The authors calls it "minimal standard random number
    generator"
    
    ref: "Random Number Generators: Good Ones are Hard to Find," by
    Stephen K. Park and Keith W. Miller in Communications of the ACM, 31,
    10 (Oct. 1988) pp. 1192-1201. Code is at page 1195, "Integer version
    2"
    
    Correctness test is described in first column, page 1195: A seed of 1
    at step 1 should give a seed of 1043618065 at step 10001.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkMinimalStandardRandomSequence, obj, update, **traits)
    
    seed = traits.Int(1, enter_set=True, auto_set=False, desc=\
        r"""
        Set the seed of the random sequence. The following pre-condition
        is stated page 1197, second column: valid_seed: value>=1 &&
        value<=2147483646 2147483646=(2^31)-2 This method does not have
        this criterium as a pre-condition (ie it will not fail if an
        incorrect seed value is passed) but the value is silently changed
        to fit in the valid range [1,2147483646]. 2147483646 is added to
        a null or negative value. 2147483647 is changed to be 1 (ie
        2147483646 is subtracted). Implementation note: it also performs
        3 calls to Next() to avoid the bad property that the first random
        number is proportional to the seed value.
        """
    )

    def _seed_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetSeed,
                        self.seed)

    def get_next_range_value(self, *args):
        """
        get_next_range_value(self, rangeMin:float, rangeMax:float) -> float
        C++: double get_next_range_value(double rangeMin, double rangeMax)
        Get the next value in the sequence within a range.
        
        \\see MinimalStandardRandomSequence::GetRangeValue
        """
        ret = self._wrap_call(self._vtk_obj.GetNextRangeValue, *args)
        return ret

    def get_range_value(self, *args):
        """
        get_range_value(self, rangeMin:float, rangeMax:float) -> float
        C++: virtual double get_range_value(double rangeMin,
            double rangeMax)
        Convenient method to return a value in a specific range from the
        range [0,1. There is an initial implementation that can be
        overridden by a subclass. There is no pre-condition on the range:
        - it can be in increasing order: rangeMin<rangeMax
        - it can be empty: rangeMin=rangeMax
        - it can be in decreasing order: rangeMin>rangeMax
        \\post result_in_range:
        (rangeMin<=rangeMax && result>=rangeMin && result<=rangeMax) ||
        (rangeMax<=rangeMin && result>=rangeMax && result<=rangeMin)
        """
        ret = self._wrap_call(self._vtk_obj.GetRangeValue, *args)
        return ret

    def set_seed_only(self, *args):
        """
        set_seed_only(self, value:int) -> None
        C++: void set_seed_only(int value)
        Set the seed of the random sequence. There is no extra internal
        adjustment. Only useful for writing correctness test. The
        following pre-condition is stated page 1197, second column
        2147483646=(2^31)-2 This method does not have this criterium as a
        pre-condition (ie it will not fail if an incorrect seed value is
        passed) but the value is silently changed to fit in the valid
        range [1,2147483646]. 2147483646 is added to a null or negative
        value. 2147483647 is changed to be 1 (ie 2147483646 is
        subtracted).
        """
        ret = self._wrap_call(self._vtk_obj.SetSeedOnly, *args)
        return ret

    _updateable_traits_ = \
    (('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('seed', 'GetSeed'), ('object_name',
    'GetObjectName'), ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'global_warning_display', 'object_name', 'seed'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(MinimalStandardRandomSequence, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit MinimalStandardRandomSequence properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], [], ['object_name', 'seed']),
            title='Edit MinimalStandardRandomSequence properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit MinimalStandardRandomSequence properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

