/* -*- C -*- 
   mboxgrep - scan mailbox for messages matching a regular expression
   Copyright (C) 2000, 2001, 2002, 2003  Daniel Spiljar
   
   Mboxgrep is free software; you can redistribute it and/or modify it 
   under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   Mboxgrep is distributed in the hope that it will be useful, but 
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with mboxgrep; if not, write to the Free Software Foundation, 
   Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
   
   $Id: mbox.h,v 1.7 2003/03/30 23:07:10 dspiljar Exp $ */

#ifndef MBOX_H
#define MBOX_H 1

#include <config.h>

#include "mboxgrep.h"           /* for message_t structure */

typedef struct
{
  void *fp;
  char *postmark_cache;
} mbox_t;


mbox_t *mbox_open (const char *path, const char *mode);
void *tmpfile_open (void);
void mbox_close (mbox_t * mbp);
message_t *mbox_read_message (mbox_t * mbp);

#endif /* MBOX_H */
