/*     Copyright (C) 1999, 2000, 2001, 2002, 2003, 2004 Stijn van Dongen
 *
 * This file is part of MCL.  You can redistribute and/or modify MCL under the
 * terms of the GNU General Public License; either version 2 of the License or
 * (at your option) any later version.  You should have received a copy of the
 * GPL along with MCL, in the file COPYING.
*/

/* TODO
 *    parsing code is ugly. Some header parsing is now line-based,
 *    some other part is not.
*/

#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>

#include "io.h"
#include "iface.h"

#include "util/compile.h"
#include "util/types.h"
#include "util/err.h"
#include "util/minmax.h"
#include "util/alloc.h"
#include "util/ting.h"
#include "util/io.h"
#include "util/hash.h"
#include "util/array.h"

static const char *mclxar = "mclxaRead";


static void tell_read_native
(  const mclMatrix* mx
,  const char* mode
)
   {  mcxTell
      (  "mclIO"
      ,  "read native %s %ldx%ld matrix with %ld entries"
      ,  mode
      ,  (long) N_ROWS(mx)
      ,  (long) N_COLS(mx)
      ,  (unsigned long) mclxNEntries(mx)
      )
;  }


static void tell_wrote_native
(  const mclMatrix* mx
,  const char* mode
,  const mcxIO* xf
)
   {  mcxTell
      (  "mclIO"
      ,  "wrote native %s %ldx%ld matrix with %ld entries to stream <%s>"
      ,  mode
      ,  (long) N_ROWS(mx)
      ,  (long) N_COLS(mx)
      ,  (unsigned long) mclxNEntries(mx)
      ,  xf->fn->str
      )
;  }


static mcxstatus mclxa_ParseDimPart
(  mcxIO          *xf
,  mcxHash        *header
)  ;

static mcxstatus mclxa_ParseDomain
(  mcxIO        *xf
,  mclVector**  dompp
)  ;

static void mclxa_write_header
(  const mclMatrix* mx
,  FILE* fp
)  ;


/* reads a vector (ascii format)
 * ensures it is in ascending format and has no negative entries
 * or repeated entries.
*/

static mcxstatus mclxa_ReaDaVec
(  mcxIO*      xf
,  mclVector*  vec
,  mclpAR*     ar
,  int         fintok
,  mcxbits     bits              /* inherited from mcl{x,v}aReadRaw */
,  void      (*ivpmerge)(void* ivp1, const void* ivp2)
,  double    (*fltbinary)(pval val1, pval val2)
)  ;


unsigned long get_env_flags
(  const char* opt
)
   {  unsigned long val = 0
   ;  const char* envp  =  getenv(opt)
   ;  if (envp)
      val = strtol(envp, NULL, 10)
   ;  return val
;  }


unsigned long get_quad_mode
(  const char* opt
)
   {  unsigned long val
      
   ;  if ((val = get_env_flags(opt)))

   ;  else if (!strcmp(opt, "MCLXIOVERBOSITY"))
      val = 8     /* default verbose,  apps can not override */
   ;  else if (!strcmp(opt, "MCLXIOFORMAT"))
      val = 2     /* do default ascii, apps can not override */

   ;  return val
;  }


mcxbool mclxIOsetQMode
(  const char* opt
,  unsigned long newmode
)
   {  int mode = get_quad_mode(opt)
   ;  mcxTing* tmp = mcxTingPrint(NULL, "%ld", (unsigned long) (newmode & 10))
   ;  mcxbool ok = FALSE

   ;  while (1)
      {  if (mode & 5)     /* modes 1 and 4 cannot be overridden */
         break
      ;  if (setenv(opt, tmp->str, 1))
         break
      ;  ok = TRUE
      ;  break
   ;  }

      mcxTingFree(&tmp)
   ;  return ok
;  }



mcxbool mclxIOgetQMode
(  const char* opt
)
   {  int mode = get_quad_mode(opt)
   ;  if (mode & 3)
      return 0
   ;  else if (mode & 12)
      return 1
   ;  return 1
;  }


int set_ascii_digits
(  int valdigits
)
   {  const char* envp  =  getenv("MCLXASCIIDIGITS")

   ;  if (valdigits == MCLXIO_VALUE_GETENV)
      {  if (envp)
         valdigits = strtol(envp, NULL, 10)
      ;  else
         valdigits = 4
   ;  }

      if (valdigits < -1)     /* 0 is valid and means: no digits please */
      valdigits = 4
   ;  else if (valdigits > 16)
      valdigits = 16

   ;  return valdigits
;  }


mcxstatus mclxbReadDimensions
(  mcxIO          *xf
,  long           *pn_cols
,  long           *pn_rows
)
   {  mcxDie(1, "mclxbReadDimensions", "not implemented")
   ;  return STATUS_OK
;  }


mcxstatus mclxReadDimensions
(  mcxIO          *xf
,  long           *pn_cols
,  long           *pn_rows
)
   {  if (!xf->fp && mcxIOopen(xf, RETURN_ON_FAIL) != STATUS_OK)
      return STATUS_FAIL

   ;  if (mcxFPisSeekable(xf->fp) && mcxIOtryCookie(xf, mclxCookie))
      {  fread(pn_cols, sizeof(long), 1, xf->fp)
      ;  fread(pn_rows, sizeof(long), 1, xf->fp)
   ;  }
      else if (mclxaReadDimensions(xf, pn_rows, pn_cols) != STATUS_OK)
      {  mcxErr("mclxReadDimensions", "could not parse header")
      ;  return STATUS_FAIL
   ;  }
      return STATUS_OK
;  }


mclMatrix* mclxSubRead
(  mcxIO* xf
,  mclVector* colmask
,  mclVector* rowmask
,  mcxOnFail ON_FAIL
)
   {  mclxFormatFound   = 'a'
      
   ;  if (!xf->fp && mcxIOopen(xf, ON_FAIL) != STATUS_OK)
      {  mcxIOerr(xf, "mclxSubRead", "can not be opened")
      ;  return NULL
   ;  }

      if (mcxFPisSeekable(xf->fp) && mcxIOtryCookie(xf, mclxCookie))
      return mclxbSubRead(xf, colmask, rowmask, FALSE, ON_FAIL)

   ;  return mclxaSubRead(xf, colmask, rowmask, ON_FAIL)
;  }


mclMatrix* mclxbSubRead
(  mcxIO* xf
,  mclVector* colmask
,  mclVector* rowmask
,  mcxbool   getcookie
,  mcxOnFail ON_FAIL
)
   {  mclMatrix* mx     =  NULL
   ;  long n_rows       =  0
   ;  long n_cols       =  0
   ;  int level         =  0
   ;  int szl           =  sizeof(long)
   ;  mcxstatus status  =  STATUS_FAIL
   ;  long n_mod        =  0
   ;  mclv* dom_cols    =  NULL
   ;  mclv* dom_rows    =  NULL
   ;  mcxbool  progress =     isatty(fileno(stderr))
                           && mclxIOgetQMode("MCLXIOVERBOSITY")

   ;  if (progress)
      fprintf(stderr, "[mclIO] reading <%s> ", xf->fn->str)

   ;  mclxFormatFound   = 'b'

   ;  if
      (  !mcxFPisSeekable(xf->fp)
      || (getcookie && !mcxIOtryCookie(xf, mclxCookie))
      )
      return NULL

   ;  dom_cols = mclvNew(NULL, 0)
   ;  dom_rows = mclvNew(NULL, 0)

   ;  while (1)
      {  if (mclxbReadDomains(xf, dom_cols, dom_rows, &level)) break

      ;  n_cols = dom_cols->n_ivps
      ;  n_rows = dom_rows->n_ivps

      ;  n_mod = MAX(1+(n_cols-1)/40, 1)

      ;  if (!colmask)
         colmask = dom_cols
      ;  if (!rowmask)
         rowmask = dom_rows

      ;  if (!(mx = mclxAllocZero(colmask, rowmask)))       break ; level++

      ;  {  long oa_start =  ftell(xf->fp)     /* start of offset array */
         ;  long k      =  0
         ;  long vec_os = -1
         ;  long v_pos
         ;  level += 100

         ;  if (oa_start < 0)                                        break

         ;  while (k < colmask->n_ivps)
            {  long vec_idx = colmask->ivps[k].idx   /* MUST be sorted */
            ;  vec_os = mclvGetIvpOffset(dom_cols, vec_idx, vec_os)

            ;  if (progress && (k+1) % n_mod == 0)
               fputc('.', stderr)

            ;  if (vec_os < 0)               /* mask entry not present */
               {  k++
               ;  continue
            ;  }
                                             /* fetch the offset */
               if (fseek(xf->fp, oa_start + vec_os * szl, SEEK_SET))
                                                               break ;  level++
            ;  if (1 != fread(&v_pos, szl, 1, xf->fp))         break ;  level++
            ;  if (fseek(xf->fp, v_pos, SEEK_SET))             break ;  level++
            ;  if (mclvEmbedRead(mx->cols+k, xf, ON_FAIL))     break ;  level++
            ;  if (mclvCheck(mx->cols+k,-1,MCLV_CHECK_DEFAULT, RETURN_ON_FAIL))
                                                               break ;  level++
            ;  if (mcldCountSet(mx->cols+k, dom_rows, MCLD_CT_LDIFF))
                                                               break ;  level++

            ;  if (rowmask != dom_rows)
               mcldMeet(mx->cols+k, rowmask, mx->cols+k)

            ;  k++
         ;  }

            if (k != colmask->n_ivps)
            break
         ;  level++
                                    /*  fetch end of matrix offset */
         ;  if (fseek(xf->fp, oa_start + n_cols * szl, SEEK_SET))    break
         ;  if (1 != fread(&v_pos, szl, 1, xf->fp))                  break
         ;  if (fseek(xf->fp, v_pos, SEEK_SET))                      break
      ;  }
         status = STATUS_OK
      ;  break
   ;  }
      if (progress)
      fputc('\n', stderr)

   ;  if (status)
      {  mcxErr
         (  "mclIO"
         ,  "failed to read native binary "
            "%ldx%ld matrix from stream <%s> at level <%ld>"
         ,  (long) N_ROWS(mx)
         ,  (long) N_COLS(mx)
         ,  xf->fn->str
         ,  (long) level
         )
      ;  mclxFree(&mx)
      ;  if (ON_FAIL == EXIT_ON_FAIL)
         mcxDie(1, "mclIO", "exiting")
   ;  }
      else if (mclxIOgetQMode("MCLXIOVERBOSITY"))
      tell_read_native(mx, "binary")

   ;  return mx
;  }


mcxstatus mclxReadDomains
(  mcxIO* xf
,  mclv* dom_cols
,  mclv* dom_rows
)
   {  if (!xf->fp && !mcxIOopen(xf, RETURN_ON_FAIL))
      return STATUS_FAIL

   ;  if (mcxFPisSeekable(xf->fp) && mcxIOtryCookie(xf, mclxCookie))
      {  if (mclxbReadDomains(xf, dom_cols, dom_rows, NULL))
         return STATUS_FAIL
   ;  }
      else
      {  mclv* tmp_cols = NULL      /* fixme change the areaddomains iface */
      ;  mclv* tmp_rows = NULL
      ;  if (mclxaReadDomains(xf, &tmp_cols, &tmp_rows, NULL))
         return STATUS_FAIL
      ;  mclvCopy(dom_cols, tmp_cols)
      ;  mclvCopy(dom_rows, tmp_rows)
      ;  mclvFree(&tmp_cols)
      ;  mclvFree(&tmp_rows)
   ;  }
      return STATUS_OK
;  }


mcxstatus mclxbReadDomains    /* fixme; no fp checking */
(  mcxIO* xf
,  mclv* dom_cols
,  mclv* dom_rows
,  int* levelp
)
   {  long n_read =  0
   ;  int level   =  0
   ;  mcxstatus status = STATUS_FAIL
   ;  long n_cols =  0
   ;  long n_rows =  0
   ;  long flags  =  0
   ;  int szl     =  sizeof(long)

   ;  n_read += fread(&n_cols, szl, 1, xf->fp)
   ;  n_read += fread(&n_rows, szl, 1, xf->fp)
   ;  n_read += fread(&flags, szl, 1, xf->fp)

   ;  while (1)
      {  if (n_read != 3)                                      break ; level++

      ;  if (flags & 1)
         mclvCanonical(dom_cols, n_cols, 1.0)                        , level++
      ;  else if (mclvEmbedRead(dom_cols, xf, RETURN_ON_FAIL)) break ; level++

      ;  if (flags & 2)
         mclvCanonical(dom_rows, n_rows, 1.0)                        , level++
      ;  else if (mclvEmbedRead(dom_rows, xf, RETURN_ON_FAIL)) break ; level++
      ;  status = STATUS_OK
      ;  break
   ;  }
      if (levelp)
      *levelp += level
   ;  return status
;  }


mcxstatus mclxbWrite
(  const mclMatrix*  mx
,  mcxIO*            xf
,  mcxOnFail         ON_FAIL
)
   {  long      n_cols  =  N_COLS(mx)
   ;  long      n_rows  =  N_ROWS(mx)
   ;  long      flags   =  0
   ;  mclVector*vec     =  mx->cols
   ;  mcxstatus status  =  STATUS_FAIL
   ;  long      v_pos   =  0
   ;  int       szl     =  sizeof(long)
   ;  FILE*     fout    =  xf->fp
   ;  long      n_mod   =  MAX(1+(n_cols-1)/40, 1)
   ;  mcxbool progress  =     isatty(fileno(stderr))
                           && mclxIOgetQMode("MCLXIOVERBOSITY")

   ;  if (progress)
      fprintf(stderr, "[mclIO] writing <%s> ", xf->fn->str)

   ;  if (mcldIsCanonical(mx->dom_cols))
      flags |= 1
   ;  if (mcldIsCanonical(mx->dom_rows))
      flags |= 2

   ;  while (1)
      {  if (xf->fp == NULL && (mcxIOopen(xf, ON_FAIL) != STATUS_OK))   break
      ;  if (!mcxIOwriteCookie(xf, mclxCookie))                         break
      ;  if (1 != fwrite(&n_cols, szl, 1, fout))                        break
      ;  if (1 != fwrite(&n_rows, szl, 1, fout))                        break
      ;  if (1 != fwrite(&flags, szl, 1, fout))                         break
      ;  if (!(flags & 1) && STATUS_FAIL == mclvEmbedWrite(mx->dom_cols, xf))
                                                                        break
      ;  if (!(flags & 2) && STATUS_FAIL == mclvEmbedWrite(mx->dom_rows, xf))
                                                                        break

            /* Write vector offsets (plus one for end of matrix body)
             * offsets are written relative to beginning.
            */
      ;  if ((v_pos = ftell(fout)) < 0)                                 break
      ;  v_pos += (1 + n_cols) * szl

      ;  while (vec < mx->cols+n_cols)
         {  if (1 != fwrite(&v_pos, szl, 1, fout))                      break
         ;  v_pos += 2 * szl + sizeof(double)+ vec->n_ivps * sizeof(mclIvp)
                                        /* -^- vid, n_ivps, val, ivps */
         ;  vec++
         ;  if (progress && (vec-mx->cols) % n_mod == 0)
            fputc('.', stderr)
      ;  }
         if (vec != mx->cols+n_cols)                                    break
      ;  if (1 != fwrite(&v_pos, sizeof(long), 1, fout))                break
                                       /* Write columns */   
      ;  n_cols      =  N_COLS(mx)
      ;  vec         =  mx->cols

      ;  while (vec < mx->cols+n_cols)
         if (STATUS_FAIL == mclvEmbedWrite(vec++, xf))                  break
      ;  if (vec != mx->cols+n_cols)                                    break

      ;  status = STATUS_OK
      ;  break
   ;  }
      if (progress)
      fputc('\n', stderr)

   ;  if (STATUS_FAIL == status)
      {  mcxErr
         (  "mclIO"
         ,  "failed to write native binary %ldx%ld matrix to stream <%s>"
         ,  (long) N_ROWS(mx)
         ,  (long) N_COLS(mx)
         ,  xf->fn->str
         )
      ;  if (ON_FAIL == EXIT_ON_FAIL)
         mcxDie(1, "mclIO", "exiting")
   ;  }
      else if (mclxIOgetQMode("MCLXIOVERBOSITY"))
      tell_wrote_native(mx, "binary", xf)

   ;  return status
;  }


/* reads single required part, so does not read too far
 * This thing was coded way too heavy and cumbersome.
*/
mcxstatus mclxaReadDimensions
(  mcxIO*   xf
,  long     *pn_rows
,  long     *pn_cols
)
   {  mcxHash* header      =  mcxHashNew(4, mcxTingHash, mcxTingCmp)
   ;  mcxTing* txtmx       =  mcxTingNew("mcltype")
   ;  mcxTing* txtdim      =  mcxTingNew("dimensions")
   ;  mcxKV    *kvtp, *kvdim
   ;  mcxstatus status     =  STATUS_OK

   ;  if(mcxIOfind(xf, "(mclheader", RETURN_ON_FAIL) != STATUS_OK)
      {  mcxHashFree(&header, NULL, NULL) /* hash still empty */
      ;  return STATUS_FAIL
   ;  }

      mclxa_ParseDimPart(xf, header)  /* fills hash */
   /* fixme; check return status etc; (errors are noticed below though) */

   ;  kvtp  =  mcxHashSearch(txtmx, header, MCX_DATUM_FIND)
   ;  kvdim =  mcxHashSearch(txtdim, header, MCX_DATUM_FIND)

   ;  mcxTingFree(&txtmx)
   ;  mcxTingFree(&txtdim)

   ;  if (!kvtp)
      {  mcxErr(mclxar, "expected <mcltype matrix> specification not found")
      ;  mcxIOpos(xf, stderr)
      ;  status =  STATUS_FAIL
   ;  }
      else if
      (  !kvdim
      || (  sscanf
            (  ((mcxTing*) kvdim->val)->str
            ,  "%ldx%ld"
            ,  pn_rows
            ,  pn_cols
            )
            < 2
         )
      )
      {  mcxErr(mclxar, "expected <dimensions MxN> specification not found")
      ;  mcxIOpos(xf, stderr)
      ;  status =  STATUS_FAIL
   ;  }
      else if (*pn_rows < 0 || *pn_cols < 0)
      {  mcxErr
         (  mclxar
         ,  "each dimension must be nonnegative (found %ldx%ld pair)"
         ,  (long) *pn_rows
         ,  (long) *pn_cols
         )
      ;  status =  STATUS_FAIL
   ;  }

      mcxHashFree(&header, mcxTingFree_v, mcxTingFree_v)
   ;  return status
;  }


/* may read too far, hence line */
static mcxstatus mclxa_ReadDomPart
(  mcxIO        *xf
,  mclVector**  dom_colspp
,  mclVector**  dom_rowspp
,  mcxTing*     line
)
   {  mclVector*  dom_cols =  NULL
   ;  mclVector*  dom_rows =  NULL
   ;  mcxstatus   status   =  STATUS_OK

   ;  line = mcxTingEmpty(line, 80)

   ;  while (STATUS_OK == mcxIOreadLine(xf, line, MCX_READLINE_CHOMP))
      {  if (strncmp(line->str, "(mcl", 4))
         continue

      ;  if (!strncmp(line->str, "(mclcols", 8))
         {  if (dom_cols || mclxa_ParseDomain(xf, &dom_cols) == STATUS_FAIL)
            {  mcxErr(mclxar, "error parsing column domain")
            ;  goto fail
         ;  }
         }
         else if (!strncmp(line->str, "(mclrows", 8))
         {  if (dom_rows || mclxa_ParseDomain(xf, &dom_rows) == STATUS_FAIL)
            {  mcxErr(mclxar, "error parsing row domain")
            ;  goto fail
         ;  }
         }
         else if (!strncmp(line->str, "(mcldoms", 8))
         {  if
            (  dom_cols
            || dom_rows
            || mclxa_ParseDomain(xf, &dom_cols) == STATUS_FAIL
            )
            {  mcxErr(mclxar, "error parsing row domain")
            ;  goto fail
         ;  }
            dom_rows = mclvClone(dom_cols)
         ;  break
      ;  }
         else if (!strncmp(line->str, "(mclmatrix", 10))
         break
      ;  else
         {  mcxErr(mclxar, "unknown header type <%s>", line->str)
         ;  goto fail
      ;  }
   ;  }

      if (0)
      {  fail
      :  status = STATUS_FAIL
      ;  mclvFree(&dom_cols)
      ;  mclvFree(&dom_rows)
   ;  }
      else
      status = STATUS_OK

   ;  *dom_colspp = dom_cols  /* possibly NULL */
   ;  *dom_rowspp = dom_rows  /* possibly NULL */
   ;  return status
;  }


/* may read too far, hence returns line */
/* todo: rather try to fseek back ? */

mcxstatus mclxaReadDomains
(  mcxIO* xf
,  mclVector **dom_colspp
,  mclVector **dom_rowspp
,  mcxTing *line
)
   {  long n_cols = 0, n_rows = 0
   ;  mclVector* dom_cols = NULL
   ;  mclVector* dom_rows = NULL
   ;  mcxstatus status = STATUS_OK

   ;  line = mcxTingEmpty(line, 80)

   ;  *dom_colspp = NULL
   ;  *dom_rowspp = NULL

   ;  if (mclxaReadDimensions(xf, &n_rows, &n_cols) != STATUS_OK)
      {  mcxErr(mclxar, "error parsing dimension part")
      ;  goto fail
   ;  }

      status = mclxa_ReadDomPart(xf, dom_colspp, dom_rowspp, line)

   ;  if (status != STATUS_OK)
      {  mcxErr(mclxar, "error constructing domains")
      ;  goto fail
   ;  }
      dom_rows = *dom_rowspp
   ;  dom_cols = *dom_colspp

   ;  if (!dom_rows)
      {  dom_rows = mclvCanonical(NULL, n_rows, 1.0)
      ;  *dom_rowspp = dom_rows
   ;  }
      else if (dom_rows->n_ivps != n_rows)
      {  mcxErr
         (  mclxar
         ,  "row domain count <%ld> != dimension <%ld>"
         ,  (long) dom_rows->n_ivps
         ,  (long) n_rows
         )
      ;  goto fail
   ;  }

      if (!dom_cols)
      {  dom_cols = mclvCanonical(NULL, n_cols, 1.0)
      ;  *dom_colspp = dom_cols
   ;  }
      else if (dom_cols->n_ivps != n_cols)
      {  mcxErr
         (  mclxar
         ,  "col domain count <%ld> != dimension <%ld>"
         ,  (long) dom_cols->n_ivps
         ,  (long) n_cols
         )
      ;  goto fail
   ;  }

      if (0)
      {  fail
      :  status = STATUS_FAIL
      ;  mclvFree(&dom_cols)
      ;  mclvFree(&dom_rows)
   ;  }
      else
      status = STATUS_OK

   ;  *dom_colspp = dom_cols
   ;  *dom_rowspp = dom_rows
   ;  return status
;  }


mclMatrix* mclxbRead
(  mcxIO          *xf
,  mcxOnFail      ON_FAIL
)
   {  return mclxbSubRead(xf, NULL, NULL, TRUE, ON_FAIL)
;  }


mclMatrix* mclxaRead
(  mcxIO          *xf
,  mcxOnFail      ON_FAIL
)
   {  return mclxaSubRead(xf, NULL, NULL, ON_FAIL)
;  }


mclMatrix* mclxaSubRead
(  mcxIO          *xf
,  mclv*          colmask
,  mclv*          rowmask
,  mcxOnFail      ON_FAIL
)
   {  mclVector*  dom_cols =  NULL
   ;  mclVector*  dom_rows =  NULL
   ;  mcxstatus   status   =  STATUS_FAIL
   ;  mcxTing*    line     =  mcxTingEmpty(NULL, 80)
   ;  mclMatrix*  mx       =  NULL
   ;  mcxbits     bits     =  MCLV_WARN_REPEAT

   ;  if (!xf->fp && (mcxIOopen(xf, ON_FAIL) != STATUS_OK))
      goto fail

   ;  status = mclxaReadDomains(xf, &dom_cols, &dom_rows, line)
   ;  if (status != STATUS_OK)
      goto fail

   ;  while
      (  strncmp(line->str, "(mclmatrix", 10)
      && STATUS_OK == mcxIOreadLine(xf, line, MCX_READLINE_CHOMP)
      )
      ;
      /* fixme should add section parsing [ delimited by ^(mcl .. ^) ] */

      if (!line->len)
      {  mcxErr(mclxar, "(mclmatrix section not found")
      ;  goto fail
   ;  }

      if (mcxIOfind(xf, "begin", RETURN_ON_FAIL) == STATUS_FAIL)
      {  mcxErr(mclxar, "begin token not found in matrix specification")
      ;  goto fail
   ;  }

                        /* fixleak: if col,rowmask must free dom_col,rows */
      if (!colmask)
      colmask  = dom_cols
   ;  if (!rowmask)
      rowmask  = dom_rows
   ;  mx = mclxAllocZero(colmask, rowmask)

   ;  if
      (  mclxaSubReadRaw
        (xf, mx, dom_cols, dom_rows, ON_FAIL, ')', bits, mclpMergeLeft, fltLeft
        )!= STATUS_OK
      )
      {  mx = NULL      /* twas freed by mclxaSubReadRaw */
      ;  goto fail
   ;  }

      if (mclxIOgetQMode("MCLXIOVERBOSITY"))
      tell_read_native(mx, "ascii")

   ;  mcxTingFree(&line)
   ;

      if (0)
      {  fail:
      ;  if (ON_FAIL == RETURN_ON_FAIL)
         {  mcxTingFree(&line)
         ;  mclxFree(&mx)
         ;  return NULL
      ;  }
         else
         mcxExit(1)
   ;  }

      return mx
;  }


/* fixme; can't I make this more general,
 * with callback and void* argument ?
 *
 * fixme; remove offset == vid constraint [allready fixed?].
*/

mcxstatus mclxTaggedWrite
(  const mclMatrix*     mx
,  const mclMatrix*     el2dom
,  mcxIO                *xfout
,  int                  valdigits
,  mcxOnFail            ON_FAIL
)
   {  int   i
   ;  FILE* fp
   ;  const char* me = "mclxTaggedWrite"  

   ;  if (!xfout->fp && mcxIOopen(xfout, ON_FAIL) != STATUS_OK)
      {  mcxErr(me, "cannot open stream <%s>", xfout->fn->str)
      ;  return STATUS_FAIL
   ;  }

      fp =  xfout->fp
   ;  mclxa_write_header(mx, fp)

   ;  for (i=0;i<N_COLS(mx);i++)
      {  mclVector*  mvec  =  mx->cols+i
      ;  mclVector*  dvec  =  mclxGetVector
                              (  el2dom, mvec->vid, RETURN_ON_FAIL, NULL)
                             /*  fixme; make more efficient */
      ;  long tag = dvec && dvec->n_ivps ? dvec->ivps[0].idx : -1
      ;  int j

      ;  if (!mvec->n_ivps)
         continue

      ;  fprintf(fp, "%ld(%ld)  ", (long) mvec->vid, (long) tag)

      ;  for (j=0;j<mvec->n_ivps;j++)
         {  long  hidx  =  (mvec->ivps+j)->idx
         ;  double hval =  (mvec->ivps+j)->val

         ;  dvec  =  mclxGetVector(el2dom, hidx, RETURN_ON_FAIL, NULL)
         ;  tag   =  dvec && dvec->n_ivps ? dvec->ivps[0].idx : -1

         ;  if (valdigits > -1)
            fprintf
            (  fp
            ,  " %ld(%ld):%.*f"
            ,  (long) hidx
            ,  (long) tag
            ,  (int) valdigits
            ,  (double) hval
            )
         ;  else
            fprintf
            (  fp
            ,  " %ld(%ld)"
            ,  (long) hidx
            ,  (long) tag
            )
      ;  }
         fprintf(fp, " $\n")
   ;  }

      fprintf(fp, ")\n")
   ;  if (mclxIOgetQMode("MCLXIOVERBOSITY"))
      tell_wrote_native(mx, "ascii tagged", xfout)

   ;  return STATUS_OK
;  }


void mclxa_write_header
(  const mclMatrix* mx
,  FILE* fp
)
   {  int  leadwidth =  log10(MAXID_ROWS(mx)+1) + 2

   ;  fprintf
      (  fp
      ,  "(mclheader\nmcltype matrix\ndimensions %ldx%ld\n)\n"
      ,  (long) N_ROWS(mx)
      ,  (long) N_COLS(mx)
      )

   ;  if
      (  !mcldIsCanonical(mx->dom_rows)
      || !mcldIsCanonical(mx->dom_cols)
      )
      {  if (mcldEquate(mx->dom_rows, mx->dom_cols, MCLD_EQ_EQUAL))
         {  fputs("(mcldoms\n", fp)
         ;  mclvaDump
            (  mx->dom_cols
            ,  fp
            ,  leadwidth
            ,  MCLXIO_VALUE_NONE
            ,  FALSE
            )
         ;  fputs(")\n", fp)
      ;  }
         else
         {  if (!mcldIsCanonical(mx->dom_rows))
            {  fputs("(mclrows\n", fp)
            ;  mclvaDump
               (  mx->dom_rows
               ,  fp
               ,  leadwidth
               ,  MCLXIO_VALUE_NONE
               ,  FALSE
               )
            ;  fputs(")\n", fp)
         ;  }
            if (!mcldIsCanonical(mx->dom_cols))
            {  fputs("(mclcols\n", fp)
            ;  mclvaDump
               (  mx->dom_cols
               ,  fp
               ,  leadwidth
               ,  MCLXIO_VALUE_NONE
               ,  FALSE
               )
            ;  fputs(")\n", fp)
         ;  }
         }
      }

      fputs("(mclmatrix\nbegin\n", fp)
;  }


mcxstatus mclxWrite
(  const mclMatrix*        mx
,  mcxIO*                  xfout
,  int                     valdigits
,  mcxOnFail               ON_FAIL
)
   {  if (!xfout->fp && mcxIOopen(xfout, RETURN_ON_FAIL) != STATUS_OK)
      return STATUS_FAIL
   ;  if (mclxIOgetQMode("MCLXIOFORMAT"))
      return mclxbWrite(mx, xfout, ON_FAIL)
   ;  return mclxaWrite(mx, xfout, valdigits, ON_FAIL)
;  }


mcxstatus mclxaWrite
(  const mclMatrix*        mx
,  mcxIO*                  xfout
,  int                     valdigits
,  mcxOnFail               ON_FAIL
)
   {  int   i
                  /* fixme; need more sanity checks on N_ROWS(mx) ? ? */
   ;  int   leadwidth   =  log10(MAXID_ROWS(mx)+1) + 2
   ;  FILE* fp
   ;  const char* me    =  "mclxaWrite"
   ;  unsigned long flags =  get_env_flags("MCLXASCIIFLAGS")
   ;  long n_mod        =  MAX(1+(N_COLS(mx)-1)/40, 1)
   ;  mcxbool progress  =     isatty(fileno(stderr))
                           && mclxIOgetQMode("MCLXIOVERBOSITY")

   ;  valdigits = set_ascii_digits(valdigits)

   ;  if (progress)
      fprintf(stderr, "[mclIO] writing <%s> ", xfout->fn->str)

   ;  if (!xfout->fp && mcxIOopen(xfout, RETURN_ON_FAIL) != STATUS_OK)
      {  mcxErr(me, "cannot open stream <%s>", xfout->fn->str)
      ;  return STATUS_FAIL
   ;  }

      fp =  xfout->fp
   ;  mclxa_write_header(mx, fp)

   ;  for (i=0;i<N_COLS(mx);i++)
      {  if ((mx->cols+i)->n_ivps || flags & 1)
         mclvaDump
         (  mx->cols+i
         ,  fp
         ,  leadwidth
         ,  valdigits
         ,  FALSE
         )
      ;  if (progress && (i+1) % n_mod == 0)
         fputc('.', stderr)
   ;  }
      if (progress)
      fputc('\n', stderr)

   ;  fprintf(fp, ")\n")

   ;  if (mclxIOgetQMode("MCLXIOVERBOSITY"))
      tell_wrote_native(mx, "ascii", xfout)

   ;  return STATUS_OK
;  }


void mcxPrettyPrint
(  const mclMatrix*        mx
,  FILE*                   fp
,  int                     width
,  int                     digits
,  const char              msg[]
)
   {  int   i
   ;  char     bgl[]       =  " [ "
   ;  char     eol[]       =  "  ]"
   ;  mclMatrix*  tp       =  mclxTranspose(mx)
   ;  char  voidstring[20]

   ;  width                =  MAX(2, width)
   ;  width                =  MIN(width, 15)

   ;  memset(voidstring, ' ', width-2)
   ;  *(voidstring+width-2) = '\0'

   ;  for (i=0;i<N_COLS(tp);i++)
      {  mclVector*  rowVec   =  tp->cols+i
      ;  mclIvp*  domIvp      =  tp->dom_rows->ivps - 1
      ;  mclIvp*  domIvpMax   =  tp->dom_rows->ivps + tp->dom_rows->n_ivps

      ;  fprintf(fp, "%s", bgl)

      ;  while (++domIvp < domIvpMax)
         {  mclIvp* ivp = mclvGetIvp(rowVec, domIvp->idx, NULL)
         ;  if (!ivp)
            fprintf(fp, " %s--", voidstring)
         ;  else
            fprintf(fp, " %*.*f", (int) width, (int) digits, (double) ivp->val)
      ;  }
         fprintf(fp, "%s\n", eol)
   ;  }

      mclxFree(&tp)
   ;  if (msg)
      fprintf(fp, "^ %s\n", msg)
;  }


void mclxBoolPrint
(  mclMatrix*     mx
,  int            mode
)
   {  int      i, t                 
   ;  const char  *space   =  mode & 1 ? "" : " "
   ;  const char  *empty   =  mode & 1 ? " " : "  "

   ;  fprintf(stdout, "\n  ")        
   ;  for (i=0;i<N_ROWS(mx);i++)    
      fprintf(stdout, "%d%s", (int) i % 10, space)   
   ;  fprintf(stdout, "\n")

   ;  for (i=0;i<N_COLS(mx);i++)
      {  int         last        =  0
      ;  mclIvp*     ivpPtr      =  (mx->cols+i)->ivps
      ;  mclIvp*     ivpPtrMax   =  ivpPtr + (mx->cols+i)->n_ivps
      ;  fprintf(stdout, "%d ", (int) i%10)
                                    
      ;  while (ivpPtr < ivpPtrMax) 
         {  for (t=last;t<ivpPtr->idx;t++) fprintf(stdout, "%s", empty)
         ;  fprintf(stdout, "@%s", space)
         ;  last = (ivpPtr++)->idx + 1
      ;  }        
         for (t=last;t<N_ROWS(mx);t++) fprintf(stdout, "%s", empty)
      ;  fprintf(stdout, " %d\n", (int) i%10)   
   ;  }           

      fprintf(stdout, "  ")
   ;  for (i=0;i<N_ROWS(mx);i++)
      fprintf(stdout, "%d%s", (int) i%10, space)
   ;  fprintf(stdout, "\n")
;  }


void mclvaDump
(  const mclVector*  vec
,  FILE*    fp
,  int      leadwidth
,  int      valdigits
,  mcxbool  doHeader
)
   {  int vid = vec->vid
   ;  int nr_chars   =     0
   ;  const char* eov =    " $\n"
   ;  int n_converted = 0
   ;  int i

   ;  if (leadwidth > 20)
      leadwidth = 20
   ;  if (leadwidth < 0)
      leadwidth = 0

   ;  if (doHeader)
      {  fprintf(fp , "(mclheader\nmcltype vector\n)\n" "(mclvector\nbegin\n")
      ;  eov = " $\n)\n"
   ;  }

      if (vid>=0)
      {  fprintf(fp, "%ld%n", (long) vid, &n_converted)
      ;  nr_chars += n_converted
      ;  if (vec->val != 0.0)
            fprintf(fp, ":%.*f%n", valdigits, (double) vec->val, &n_converted)
         ,  nr_chars += n_converted
      ;  while (nr_chars < leadwidth -1)  /* we get one below */
         {  fputs(" ", fp)
         ;  nr_chars++
      ;  }
      }

      for (i=0; i<vec->n_ivps;i++)
      {  if (valdigits > -1)
         {  fprintf
            (  fp
            ,  " %ld:%.*f%n"
            ,  (long) (vec->ivps+i)->idx
            ,  (int) valdigits
            ,  (double) (vec->ivps+i)->val
            ,  &n_converted
            )
         ;  nr_chars += n_converted
      ;  }
         else if (valdigits == MCLXIO_VALUE_NONE)
         {  fprintf(fp, " %ld%n",  (long) (vec->ivps+i)->idx, &n_converted)
         ;  nr_chars += n_converted
      ;  }

                     /* assume leadwidth is correlated to index range */
         if (nr_chars > 70-leadwidth && i < vec->n_ivps-1)
         {  int j
         ;  fputc('\n', fp)
         ;  nr_chars = 0
         ;  if (vid >= 0)
            {  for (j=0;j<leadwidth-1;j++)     /* somewhat stupid */
                  fputc(' ', fp)
               ,  nr_chars++
         ;  }
         }
      }
      fputs(eov, fp)
;  }


static void report_vector_size
(  const char*             action
,  const mclVector*           vec
)
   {  char                 report[80]

   ;  sprintf
      (  report, "%s %ld pair%s\n"
      ,  action
      ,  (long) vec->n_ivps
      ,  vec->n_ivps == 1 ? "" : "s"
      )
   ;  mcxTell(NULL, report)
;  }


mcxstatus mclvEmbedRead
(  mclVector*     vec
,  mcxIO*         xf
,  mcxOnFail      ON_FAIL
)
   {  long n_ivps =  0      /* fixme; check vec             */
   ;  long n_read =  0
   ;  mcxstatus status = STATUS_FAIL

   ;  while (1)
      {  n_read += fread(&n_ivps, sizeof(long), 1, xf->fp)
      ;  n_read += fread(&(vec->vid), sizeof(long), 1, xf->fp)
      ;  n_read += fread(&(vec->val), sizeof(double), 1, xf->fp)

      ;  if (n_read != 3)
         break

      ;  if (n_ivps)
         {  if (!mclvResize(vec, n_ivps))
            break

         ;  if
            (  n_ivps
            != (n_read = fread(vec->ivps, sizeof(mclIvp), n_ivps, xf->fp))
            )
            {  if (n_read >= 0)
               mclvResize(vec, n_read)
            ;  break
         ;  }
         }
         else
         mclvResize(vec, 0)

      ;  status = STATUS_OK
      ;  break
   ;  }

      if (status && ON_FAIL == EXIT_ON_FAIL)
      mcxDie(1, "mclvEmbedRead", "failed to read vector")

   ;  return status
;  }


mclpAR* mclpReaDaList
(  mcxIO   *xf
,  mclpAR  *ar
,  int     *sortbits
,  int      fintok
)
   {  int n_ivps = 0
   ;  const char* me = "mclpReaDaList"
   ;  mcxbool ok = FALSE
   ;  int sorted = 1
   ;  int noduplicates = 1
   ;  long previdx = -1

   ;  if (sortbits)
      *sortbits = 0

   ;  if (!ar)
      ar = mclpARresize(NULL, 100)

   ;  while (1)
      {  long idx
      ;  double val
      ;  mclIvp* ivp
      ;  int c = mcxIOskipSpace(xf)  /* c is ungotten */

      ;  if (c == fintok)
         {  mcxIOstep(xf)  /* discard '$' or EOF etc */
         ;  ok = TRUE
         ;  break
      ;  }
         else if (c == '#')
         {  mcxIOdiscardLine(xf)
         ;  continue
      ;  }

         if (mcxIOexpectNum(xf, &idx, RETURN_ON_FAIL) == STATUS_FAIL)
         {  mcxErr(me, "expected row index")
         ;  break
      ;  }
         else if (idx < 0)
         {  mcxErr(me, "found negative index <%ld>", (long) idx)
         ;  break
      ;  }

         if (idx < previdx)
         sorted = 0
      ;  if (idx == previdx)
         noduplicates = 0
      ;
         n_ivps++
      ;
      expect_val

      :  if (':' == (c = mcxIOskipSpace(xf)))
         {  mcxIOstep(xf) /* discard ':' */
         ;  if (mcxIOexpectReal(xf, &val, RETURN_ON_FAIL) == STATUS_FAIL)
            {  mcxErr(me, "expected value after row index <%ld>", (long) idx)
            ;  break
         ;  }
         }
         else if ('(' == c)
         {  if (mcxIOfind(xf, ")", RETURN_ON_FAIL) == STATUS_FAIL)
            {  mcxErr(me, "could not skip over s-expression <%ld>", (long) idx)
            ;  break
         ;  }
            goto expect_val
      ;  }
         else
         val = 1.0

      ;  if (ar->n_alloc <= n_ivps)
         mcxResize
         (  &(ar->ivps)
         ,  sizeof(mclp)
         ,  &(ar->n_alloc)
         ,  n_ivps * 2
         ,  EXIT_ON_FAIL   /* fixme; respect ON_FAIL */
         )

      ;  ivp      =  ar->ivps + n_ivps - 1
      ;  ivp->val =  val
      ;  ivp->idx =  idx
      ;  previdx  =  idx
   ;  }

      if (!ok)
      {  mclpARfree(&ar)
      ;  return NULL
   ;  }

      if (sortbits && sorted)
      {  *sortbits |= 1
      ;  if (noduplicates)
         *sortbits |= 2
   ;  }
      /* don't set noduplicates unless the thing is sorted */

      ar->n_ivps = n_ivps
   ;  return ar
;  }


static mcxstatus mclxa_ReaDaVec
(  mcxIO*      xf
,  mclv*       dst
,  mclpAR*     ar
,  int         fintok
,  mcxbits     warn_repeat
,  void (*ivpmerge)(void* ivp1, const void* ivp2)
,  double (*fltbinary)(pval val1, pval val2)
)
   {  mclpAR* arcp = ar
   ;  int sortbits = 0  /* 1: in sorted order, 2: no duplicates present. */

   ;  if (!(ar = mclpReaDaList(xf, ar, &sortbits, fintok)))
      return STATUS_FAIL

   ;  mclvFromIvps_x
      (dst,ar->ivps,ar->n_ivps,warn_repeat, sortbits, ivpmerge, fltbinary)
   ;  if (!arcp)
      mclpARfree(&ar)
   ;  return STATUS_OK
;  }


mcxstatus mclvEmbedWrite
(  const mclVector*     vec
,  mcxIO*               xf
)
   {  long sz     =  vec->n_ivps
   ;  long vid    =  vec->vid
   ;  double val  =  vec->val
   ;  long n_written = 0

   ;  n_written += fwrite(&sz, sizeof(long), 1, xf->fp)
   ;  n_written += fwrite(&vid, sizeof(long), 1, xf->fp)
   ;  n_written += fwrite(&val, sizeof(double), 1, xf->fp)

   ;  if (vec->n_ivps)
      n_written += fwrite(vec->ivps, sizeof(mclIvp), vec->n_ivps, xf->fp)

   ;  if (n_written != 3 + vec->n_ivps)
      return STATUS_FAIL

   ;  return STATUS_OK
;  }


/*
 * fixme this interface is obsolete
*/

mcxstatus mclvbWrite
(  const mclVector      *vec
,  mcxIO                *xfout
,  mcxOnFail            ON_FAIL
)
   {  mcxstatus         status

   ;  if (xfout->fp == NULL && mcxIOopen(xfout, ON_FAIL) != STATUS_OK)
      {  mcxErr("mclvbWrite", "cannot open stream <%s>", xfout->fn->str)
      ;  return STATUS_FAIL
   ;  }

      if (!mcxIOwriteCookie(xfout, mclvCookie))
      return STATUS_FAIL

   ;  if (STATUS_OK == (status = mclvEmbedWrite(vec, xfout)))
      report_vector_size("wrote", vec)

   ;  return status
;  }


static mcxstatus mclxa_ParseDomain
(  mcxIO        *xf
,  mclVector**  dompp
)
   {  mclVector *dom = *dompp

   ;  if (!dom)
      dom = mclvInit(NULL)

   ;  *dompp = dom

   ;  if
      (  mclxa_ReaDaVec
         (  xf
         ,  dom
         ,  NULL
         ,  '$'
         ,  MCLV_WARN_REPEAT
         ,  mclpMergeLeft
         ,  NULL
         )
         == STATUS_OK
      )
      {  if (')' == mcxIOskipSpace(xf))
         {  mcxIOstep(xf) /* discard ')' */
         ;  return STATUS_OK
      ;  }
         return STATUS_FAIL
   ;  }
      return STATUS_FAIL
;  }


static mcxstatus mclxa_ParseDimPart
(  mcxIO        *xf
,  mcxHash      *header
)
   {  int  n
   ;  mcxTing   *keyTxt  =   mcxTingEmpty(NULL, 30)
   ;  mcxTing   *valTxt  =   mcxTingEmpty(NULL, 30)
   ;  mcxTing   *line    =   mcxTingEmpty(NULL, 30)

   ;  while (STATUS_OK == mcxIOreadLine(xf, line, MCX_READLINE_CHOMP))
      {  if (*(line->str+0) == ')')
         break

      ;  mcxTingEnsure(keyTxt, line->len)
      ;  mcxTingEnsure(valTxt, line->len)

      ;  n = sscanf(line->str, "%s%s", keyTxt->str, valTxt->str)

      ;  if (n < 2)
         continue
      ;  else
         {  mcxTing* key   =  mcxTingNew(keyTxt->str)
         ;  mcxTing* val   =  mcxTingNew(valTxt->str)
         ;  mcxKV*   kv    =  mcxHashSearch(key, header, MCX_DATUM_INSERT)
         ;  kv->val        =  val
      ;  }
      }

      mcxTingFree(&line)
   ;  mcxTingFree(&valTxt)
   ;  mcxTingFree(&keyTxt)
   ;  return STATUS_OK
;  }



mclMatrix* mclxRead
(  mcxIO       *xf
,  mcxOnFail   ON_FAIL
)  
   {  return mclxSubRead(xf, NULL, NULL, ON_FAIL)
;  }


void mclFlowPrettyPrint
(  const mclMatrix*  mx
,  FILE*             fp
,  int               digits
,  const char        msg[]
)
   {  mcxPrettyPrint
      (  mx
      ,  fp
      ,  digits+2
      ,  digits
      ,  msg
      )
;  }


void mclvaWrite               /* fixme should use set_ascii_digits */
(  const mclVector*  vec
,  FILE*             fp
,  int               valdigits
)  
   {  mclvaDump
      (  vec
      ,  fp
      ,  0
      ,  valdigits
      ,  TRUE
      )
;  }



mclpAR *mclpaReadRaw
(  mcxIO       *xf
,  mcxOnFail   ON_FAIL
,  int         fintok     /* e.g. EOF or '$' */
)
   {  mclpAR* ar = mclpReaDaList(xf, NULL, NULL, fintok)
   ;  if (!ar && ON_FAIL != RETURN_ON_FAIL)
      mcxExit(1)
   ;  return ar
;  }



/* fixme; add expect_vid argument */
/* fixme;? add ar buffer argument */
mclVector* mclvaReadRaw
(  mcxIO          *xf
,  mclpAR*        ar
,  mcxOnFail      ON_FAIL
,  int            fintok     /* e.g. EOF or '$' */
,  mcxbits        warn_repeat
,  void (*ivpmerge)(void* ivp1, const void* ivp2)
)
   {  mclVector* vec = mclvInit(NULL)  /* cannot use create; vec must be ok */
   ;  if
      (  mclxa_ReaDaVec(xf, vec, ar, fintok, warn_repeat, ivpmerge, NULL)
      != STATUS_OK
      )
      {  mcxErr("mclvaReadRaw", "read failed in <%s>", xf->fn->str)
      ;  if (ON_FAIL == EXIT_ON_FAIL)
         mcxExit(1)
      ;  return NULL
   ;  }
      if (0 && mclxIOgetQMode("MCLXIOVERBOSITY"))
      mcxTell
      (  "mclIO"
      ,  "read raw ascii <%ld> vector from stream <%s>"
      ,  (long) vec->n_ivps
      ,  xf->fn->str
      )
   ;  return vec
;  }


mcxstatus mclxaSubReadRaw
(  mcxIO          *xf
,  mclMatrix      *mx            /* fit raw matrix onto domains of mx   */
,  mclv           *tst_cols      /* raw matrix must satisfy this domain */
,  mclv           *tst_rows      /* raw matrix must satisfy this domain */
,  mcxOnFail      ON_FAIL
,  int            fintok         /* e.g. EOF or ')' */
,  mcxbits        bits
,  void (*ivpmerge)(void* ivp1, const void* ivp2)
,  double (*fltbinary)(pval val1, pval val2)
)
   {  const char* me       =  "mclxaSubReadRaw"
   ;  mclpAR*     ar       =  mclpARresize(NULL, 100)
   ;  mclv*       discardv =  mclvNew(NULL, 0)

   ;  int         N_cols   =  N_COLS(mx)
   ;  int         n_cols   =  0
   ;  int         n_mod    =  MAX(1+(N_cols-1)/40, 1)
   ;  mcxbool     progress =     isatty(fileno(stderr))
                              && mclxIOgetQMode("MCLXIOVERBOSITY")

   ;  if (progress)
      fprintf(stderr, "[mclIO] reading <%s> ", xf->fn->str)

   ;  if (xf->fp == NULL && (mcxIOopen(xf, ON_FAIL) != STATUS_OK))
      goto fail

   ;  while (1)                  /* fixme get rid of goto; status-based */
      {  long           cidx
      ;  double         cval   = 0.0
      ;  mclVector*     vec
      ;  mclp*          tstivp
      ;  int a = mcxIOskipSpace(xf)
      ;  int            discardb = ~0

      ;  if (a == fintok)
         break
      ;  else if (a == '#')
         {  mcxIOdiscardLine(xf)
         ;  continue
      ;  }

         if (mcxIOexpectNum(xf, &cidx, RETURN_ON_FAIL) == STATUS_FAIL)
         {  mcxErr(me, "expected column index")
         ;  goto fail
      ;  }

      ;  if (':' == (a = mcxIOskipSpace(xf)))
         {  mcxIOstep(xf) /* discard ':' */
         ;  if (mcxIOexpectReal(xf, &cval, RETURN_ON_FAIL) == STATUS_FAIL)
            {  mcxErr
               (me, "expected value after column identifier <%ld>", (long) cidx)
            ;  goto fail
         ;  }
         }

         tstivp = mclvGetIvp(tst_cols, cidx, NULL)

      ;  if (!tstivp)
         {  mcxErr(me, "found alien col index <%ld>", (long) cidx)
         ;  goto fail
      ;  }

         if (!(vec = mclxGetVector(mx, cidx, RETURN_ON_FAIL, NULL)))
            vec = discardv
         ,  discardb = 0

      ;  vec->val = cval

      ;  if
         (  mclxa_ReaDaVec(xf,vec,ar,'$', bits & discardb, ivpmerge, fltbinary)
         == STATUS_FAIL
         )
         {  mcxErr(me, "vector read failed for column <%ld>", (long) cidx)
         ;  goto fail
      ;  }

         if (mcldCountSet(vec, tst_rows, MCLD_CT_LDIFF))
         {  mclv* ldif = mcldMinus(vec, tst_rows, NULL)
         ;  mcxErr
            (  me
            ,  "alien row indices in column <%ld> - (a total of %ld)"
            ,  (long) cidx
            ,  (long) ldif->n_ivps
            )
         ;  mcxErr(me, "the first is <%ld>", (long) ldif->ivps[0].idx)
         ;  mclvFree(&ldif)
         ;  goto fail
      ;  }

         if (vec != discardv && tst_rows != mx->dom_rows)
         mcldMeet(vec, mx->dom_rows, vec)

      ;  n_cols++
      ;  if (progress && n_cols % n_mod == 0)
         fputc('.', stderr)
   ;  }
      if (progress)
      fputc('\n', stderr)

                        /* hack: if fintok == ')' then caller is verbose */
   ;  if (fintok == EOF && mclxIOgetQMode("MCLXIOVERBOSITY"))
      mcxTell
      (  "mclIO"
      ,  "read raw ascii %ldx%ld matrix from stream <%s>"
      ,  (long) N_ROWS(mx)
      ,  (long) N_COLS(mx)
      ,  xf->fn->str
      )
   ;  mclpARfree(&ar)
   ;

      if (0)
      {  fail
      :  if (ON_FAIL == RETURN_ON_FAIL)
         {  mclxFree(&mx)  
         ;  return STATUS_FAIL
      ;  }
         else
         mcxExit(1)
   ;  }

      mclvFree(&discardv)
   ;  return STATUS_OK
;  }

