/*      Copyright (C) 2001, 2002, 2003, 2004 Stijn van Dongen
 *
 * This file is part of MCL.  You can redistribute and/or modify MCL under the
 * terms of the GNU General Public License; either version 2 of the License or
 * (at your option) any later version.  You should have received a copy of the
 * GPL along with MCL, in the file COPYING.
*/

/* todo; couple suf with xf_sym */


#include <string.h>
#include <stdio.h>

#include "impala/matrix.h"
#include "impala/vector.h"
#include "impala/pval.h"
#include "impala/io.h"
#include "impala/iface.h"
#include "mcl/interpret.h"

#include "util/io.h"
#include "util/err.h"
#include "util/opt.h"
#include "util/types.h"

const char* me = "mcxassemble";

const char* usagelines[] =
{  "Usage: mcxassemble [options]"
,  "Default output is the symmetrized result of the matrix built from the"
   " raw data"
,  ""
,  "Options:"
,  "-b <base>        [use base.raw, base.hdr, and optionally base.map]"
,  ""
,  "-hdr <fname>     [read header file]"
,  "-raw <fname>     [read raw data file]"
,  ""
,  "-map <fname>     [apply row/col map in file]"
,  "-tag <tag>       [apply row/col map in base.tag]"
,  "--map            [apply row/col map in base.map]"
,  "-cmap <fname>    [apply col map in file]"
,  "-ctag <tag>      [apply col map in base.tag]"
,  "--cmap           [apply col map in base.cmap]"
,  "-rmap <fname>    [apply row map in file]"
,  "-rtag <tag>      [apply row map in base.tag]"
,  "--rmap           [apply row map in base.cmap]"
,  ""
,  "-skw <fname>     [write skew matrix to file]"
,  "--skw            [write skew matrix to base.skw]"
,  "-prm <fname>     [write primary result to file]"
,  "--prm            [write primary result matrix to base.prm]"
,  ""
,  "-xo <suf>        [write symmetric result to base.suf (default .sym)]"
,  "-o <fname>       [write to file fname]"
,  "-n               [do not write default symmetrized result]"
,  "-i <fname>       [read from single data file]"
,  "-digits <int>    [digits width]"
,  ""
,  "-s               [check primary result symmetry by creating skew matrix]"
,  ""
,  "-rv <add|max|mul|left|right> [action for repeated vectors]"
,  "-re <add|max|mul|left|right> [action for repeated entries]"
,  "-ri <add|max|mul>            [action for adding image with mirror]"
,  "-r <add|max|mul|left|right>  [same for entries and vectors and matrix]"
,  ""
,  "--quiet-re       [do not warn for repeated entries]"
,  "--quiet-rv       [do not warn for repeated vectors]"
,  "-q               [the two above combined]"
,  NULL
}  ;


#define MAP_COLS 1
#define MAP_ROWS 2
#define MAP_DOMS 4


int main
(  int                  argc
,  const char*          argv[]
)
   {  int a = 1
   ;  mcxTing* obase = mcxTingNew("out"), *ibase = NULL
   ;  mcxIO* xf_hdr = NULL, *xf_raw = NULL
      ,  *xf_prm = NULL, *xf_map = NULL, *xf_skew = NULL, *xf_sym = NULL
      ,  *xf_rmap = NULL, *xf_cmap = NULL
   ;  mclVector* dom_rows = NULL, *dom_cols = NULL
   ;  const char* suf = NULL, *re = NULL, *rv = NULL, *ra = NULL, *ri = NULL
   ;  const char* tag = NULL, *rtag = NULL, *ctag = NULL
   ;  mclx *mx = NULL, *tp = NULL, *sym = NULL, *skew = NULL
   ;  mclx *cmap = NULL, *rmap = NULL
   ;  mcxbits maptype = 0
   ;  mcxbool write_skw = FALSE
   ;  mcxbool noput_sym = FALSE
   ;  mcxbool write_prm = FALSE
   ;  mcxbool check_sym   = FALSE
   ;  mcxbool single_data_file = FALSE
   ;  mcxbits warn_repeat = MCLV_WARN_REPEAT
   ;  int digits = MCLXIO_VALUE_GETENV
   ;  int EODATA = EOF

   ;  void (*ivpmerge)(void* ivp1, const void* ivp2)  = mclpMergeAdd
   ;  double (*fltvecbinary)(pval val1, pval val2)       = fltAdd
   ;  double (*fltmxbinary) (pval val1, pval val2)       = fltAdd

   ;  mclxIOsetQMode("MCLXIOVERBOSITY", MCL_APP_VB_YES)

   ;  if (argc == 1)
      goto help

   ;  while (a<argc)
      {  if (!strcmp(argv[a], "-h"))
         {  help
         :  mcxUsage(stdout, me, usagelines)
         ;  return 0
      ;  }

         else if (!strcmp(argv[a], "-map"))
         {  if (a++ + 1 < argc)
               xf_map = mcxIOnew(argv[a], "r")
            ,  maptype |= MAP_DOMS
         ;  else goto arg_missing
      ;  }
         else if (!strcmp(argv[a], "-digits"))
         {  if (a++ + 1 < argc)
            digits = strtol(argv[a], NULL, 10)
         ;  else goto arg_missing
      ;  }
         else if (!strcmp(argv[a], "-rmap"))
         {  if (a++ + 1 < argc)
               xf_rmap = mcxIOnew(argv[a], "r")
            ,  maptype |= MAP_ROWS
         ;  else goto arg_missing
      ;  }
         else if (!strcmp(argv[a], "-cmap"))
         {  if (a++ + 1 < argc)
               xf_cmap = mcxIOnew(argv[a], "r")
            ,  maptype |= MAP_COLS
         ;  else goto arg_missing
      ;  }
         else if
         (  !strcmp(argv[a], "--map"))
         {  maptype |= MAP_DOMS
      ;  }
         else if
         (  !strcmp(argv[a], "--rmap"))
         {  maptype |= MAP_ROWS
      ;  }
         else if
         (  !strcmp(argv[a], "--cmap"))
         {  maptype |= MAP_COLS
      ;  }

         else if (!strcmp(argv[a], "-raw"))
         {  if (a++ + 1 < argc)
            xf_raw = mcxIOnew(argv[a], "r")
         ;  else goto arg_missing
      ;  }
         else if (!strcmp(argv[a], "-hdr"))
         {  if (a++ + 1 < argc)
            xf_hdr = mcxIOnew(argv[a], "r")
         ;  else goto arg_missing
      ;  }

         else if (!strcmp(argv[a], "-prm"))
         {  if (a++ + 1 < argc)
               xf_prm = mcxIOnew(argv[a], "w")
            ,  write_prm = TRUE
         ;  else goto arg_missing
      ;  }
         else if (!strcmp(argv[a], "-skw"))
         {  if (a++ + 1 < argc)
               xf_skew = mcxIOnew(argv[a], "w")
            ,  write_skw = TRUE
         ;  else goto arg_missing
      ;  }
         else if (!strcmp(argv[a], "--skw"))
         {  write_skw = TRUE     /* use base.sym */
      ;  }
         else if (!strcmp(argv[a], "--prm"))
         {  write_prm = TRUE     /* use base.sym */
      ;  }

         else if (!strcmp(argv[a], "-i"))
         {  if (a++ + 1 >= argc)
            goto arg_missing
         ;  xf_hdr = mcxIOnew(argv[a], "r")
         ;  xf_raw = xf_hdr
         ;  single_data_file = TRUE
         ;  EODATA = ')'
      ;  }
         else if (!strcmp(argv[a], "-o"))
         {  if (a++ + 1 < argc)
            xf_sym = mcxIOnew(argv[a], "w")
         ;  else goto arg_missing
      ;  }
         else if (!strcmp(argv[a], "-tag"))
         {  if (a++ + 1 < argc)
            tag = argv[a]
         ;  else goto arg_missing
      ;  }
         else if (!strcmp(argv[a], "-ctag"))
         {  if (a++ + 1 < argc)
            ctag = argv[a]
         ;  else goto arg_missing
      ;  }
         else if (!strcmp(argv[a], "-rtag"))
         {  if (a++ + 1 < argc)
            rtag = argv[a]
         ;  else goto arg_missing
      ;  }
         else if (!strcmp(argv[a], "-xo"))
         {  if (a++ + 1 < argc)
            suf = argv[a]
         ;  else goto arg_missing
      ;  }
         else if (!strcmp(argv[a], "-n"))
         {  noput_sym = TRUE
      ;  }
         else if (!strcmp(argv[a], "-re"))
         {  if (a++ + 1 < argc)
            re = argv[a]
         ;  else goto arg_missing
      ;  }
         else if (!strcmp(argv[a], "-ri"))
         {  if (a++ + 1 < argc)
            ri = argv[a]
         ;  else goto arg_missing
      ;  }
         else if (!strcmp(argv[a], "-rv"))
         {  if (a++ + 1 < argc)
            rv = argv[a]
         ;  else goto arg_missing
      ;  }
         else if (!strcmp(argv[a], "-r"))
         {  if (a++ + 1 < argc)
            ra = argv[a]
         ;  else goto arg_missing
      ;  }

         else if (!strcmp(argv[a], "-b"))
         {  if (a++ + 1 < argc)
               ibase = mcxTingNew(argv[a])
            ,  mcxTingWrite(obase, argv[a])
         ;  else goto arg_missing
      ;  }
         else if (!strcmp(argv[a], "-q"))
         {  warn_repeat = 0
      ;  }
         else if
         (!strcmp(argv[a], "--quiet-re"))
         {  warn_repeat |= MCLV_WARN_REPEAT_ENTRIES
         ;  warn_repeat ^= MCLV_WARN_REPEAT_ENTRIES
      ;  }
         else if
         (!strcmp(argv[a],"--quiet-rv"))
         {  warn_repeat |= MCLV_WARN_REPEAT_VECTORS
         ;  warn_repeat ^= MCLV_WARN_REPEAT_VECTORS
      ;  }
         else if
         (!strcmp(argv[a], "-s"))
         {  check_sym = TRUE
      ;  }
         else if (0)
         {  arg_missing
         :  mcxTell(me, "flag <%s> needs argument; see help (-h)", argv[argc-1])
         ;  mcxExit(1)
      ;  }
         else
         {  mcxErr(me, "not an option: <%s>", argv[a])
         ;  return 1
      ;  }
         a++
   ;  }

      if (single_data_file && xf_raw != xf_hdr)
         mcxErr(me, "some other option conflicts -i usage")
      ,  mcxExit(1)

   ;  if (ibase)
      {  if (!xf_raw)
            xf_raw = mcxIOnew(ibase->str, "r")
         ,  mcxIOappendName(xf_raw, ".raw")
      ;  if (!xf_hdr)
            xf_hdr = mcxIOnew(ibase->str, "r")
         ,  mcxIOappendName(xf_hdr, ".hdr")

      ;  if (!xf_map && (tag || maptype & MAP_DOMS))
         {  xf_map = mcxIOnew(ibase->str, "r")
         ;  if (tag)
               mcxIOappendName(xf_map, ".")
            ,  mcxIOappendName(xf_map, tag)
         ;  else
            mcxIOappendName(xf_map, ".map")
      ;  }

      ;  if (!xf_map && !xf_rmap && (rmap || maptype & MAP_ROWS))
         {  xf_rmap = mcxIOnew(ibase->str, "r")
         ;  if (rtag)
               mcxIOappendName(xf_rmap, ".")
            ,  mcxIOappendName(xf_rmap, rtag)
         ;  else
            mcxIOappendName(xf_rmap, ".rmap")
      ;  }

      ;  if (!xf_map && !xf_cmap && (cmap || maptype & MAP_COLS))
         {  xf_cmap = mcxIOnew(ibase->str, "r")
         ;  if (ctag)
               mcxIOappendName(xf_cmap, ".")
            ,  mcxIOappendName(xf_cmap, ctag)
         ;  else
            mcxIOappendName(xf_cmap, ".cmap")
      ;  }
      }

      if (obase)
      {  if (!xf_prm && write_prm)
            xf_prm = mcxIOnew(obase->str, "w")
         ,  mcxIOappendName(xf_prm, ".prm")
      ;  if (!xf_skew && write_skw)
            xf_skew = mcxIOnew(obase->str, "w")
         ,  mcxIOappendName(xf_skew, ".skw")
      ;  if (!xf_sym && !noput_sym)
            xf_sym = mcxIOnew(obase->str, "w")
         ,  mcxIOappendName(xf_sym, ".")
         ,  mcxIOappendName(xf_sym, suf ? suf : "sym")
   ;  }

      if (ra || re)
      {  re = ra ? ra : re
      ;  if (!strcmp(re, "add"))
         ivpmerge = mclpMergeAdd
      ;  else if (!strcmp(re, "max"))
         ivpmerge = mclpMergeMax
      ;  else if (!strcmp(re, "mul"))
         ivpmerge = mclpMergeMul
      ;  else if (!strcmp(re, "left"))
         ivpmerge = mclpMergeLeft
      ;  else if (!strcmp(re, "right"))
         ivpmerge = mclpMergeRight
   ;  }

      if (ra || rv)
      {  rv = ra ? ra : rv
      ;  if (!strcmp(rv, "add"))
         fltvecbinary = fltAdd
      ;  else if (!strcmp(rv, "max"))
         fltvecbinary = fltMax
      ;  else if (!strcmp(rv, "mul"))
         fltvecbinary = fltCross
      ;  else if (!strcmp(rv, "left"))
         fltvecbinary = fltLeft
      ;  else if (!strcmp(rv, "right"))
         fltvecbinary = fltRight
   ;  }

      if (ra || ri)
      {  ri = ra ? ra : ri
      ;  if (!strcmp(rv, "add"))
         fltmxbinary = fltAdd
      ;  else if (!strcmp(ri, "max"))
         fltmxbinary = fltMax
      ;  else if (!strcmp(rv, "mul"))
         fltmxbinary = fltCross
      ;  else if (!strcmp(rv, "left"))
         fltmxbinary = fltLeft
      ;  else if (!strcmp(rv, "right"))
         fltmxbinary = fltRight
   ;  }

      if (!xf_raw || !xf_hdr)
         mcxErr(me, "raw file and header file required")
      ,  mcxExit(1)

   ;  mcxIOopen(xf_hdr, EXIT_ON_FAIL)
   ;  if (xf_raw != xf_hdr)
      mcxIOopen(xf_raw, EXIT_ON_FAIL)
   /* else: -i option was used */
   ;  if (xf_prm)
      mcxIOopen(xf_prm, EXIT_ON_FAIL)
   ;  if (xf_map)
      mcxIOopen(xf_map, EXIT_ON_FAIL)
   ;  else
      {  if (xf_rmap)
         mcxIOopen(xf_rmap, EXIT_ON_FAIL)
      ;  if (xf_cmap)
         mcxIOopen(xf_cmap, EXIT_ON_FAIL)
   ;  }
      if (xf_skew)
      mcxIOopen(xf_skew, EXIT_ON_FAIL)

   ;  if (mclxaReadDomains(xf_hdr, &dom_cols, &dom_rows, NULL))
         mcxErr(me, "error parsing header file")
      ,  mcxExit(1)

   ;  if (single_data_file)
      mcxIOexpect(xf_raw, "begin", EXIT_ON_FAIL)

   ;  mx = mclxAllocZero(dom_cols, dom_rows)

   ;  if (xf_map)
         cmap = mclxRead(xf_map, EXIT_ON_FAIL)
      ,  rmap = cmap
      ,  mcxIOclose(xf_map)
   ;  else
      {  if (xf_cmap)
         cmap = mclxRead(xf_cmap, EXIT_ON_FAIL)
      ;  if (xf_rmap)
         rmap = mclxRead(xf_rmap, EXIT_ON_FAIL)
   ;  }

      mclxaSubReadRaw
         (  xf_raw
         ,  mx
         ,  dom_cols
         ,  dom_rows
         ,  EXIT_ON_FAIL
         ,  EODATA
         ,  warn_repeat
         ,  ivpmerge
         ,  fltvecbinary
         )
      ,  mcxIOclose(xf_raw)

   ;  if (cmap)
      mclxMapCols(mx, cmap)
   ;  if (rmap)
      mclxMapRows(mx, rmap)

   ;  if (xf_prm)
      mclxWrite(mx, xf_prm, digits, EXIT_ON_FAIL)

   ;  if (!noput_sym)
      {  tp = mclxTranspose(mx)
      ;  sym = mclxBinary(mx, tp, fltmxbinary)
      ;  mclxWrite(sym, xf_sym, digits, EXIT_ON_FAIL)
      ;  mclxFree(&sym)
   ;  }

      if (write_skw || check_sym)
      {  double min = -1.0
      ;  long n
      ;  tp = tp ? tp : mclxTranspose(mx)
      ;  mclxScale(tp, min)
      ;  skew = mclxAdd(mx, tp)
      ;  if (write_skw)
         mclxWrite(skew, xf_skew, digits, EXIT_ON_FAIL)
      ;  n = mclxNrofEntries(skew)
      ;  fprintf(stdout, "symmetry check: %ld skew edges\n", (long) (n/2))
   ;  }

      return 0
;  }


