/*
 * Copyright © 2016 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3,
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by: Gary Wang <gary.wang@canonical.com>
 */

#ifndef MCLOUD_API_DISKINFO_H_
#define MCLOUD_API_DISKINFO_H_

#include <mcloud/api/visibility.h>

#include <memory>

namespace tinyxml2 {
    class XMLElement;
}

namespace mcloud {
namespace api {

/*!
    \class DiskInfo
    \brief DiskInfo is a class that provides basic user's mcloud storage usage information.
 */

class MCLOUD_API_DLL_PUBLIC DiskInfo {
public:
    virtual ~DiskInfo() = default;

    /*!
     * \brief Returns available free disk size of user cloud storage in MB.
     */
    int free_disk_size() const;

    /*!
     * \brief Returns total disk size assigned by mcloud in MB.
     */
    int disk_size() const;

private:
    DiskInfo(const tinyxml2::XMLElement *root);

    friend class ClientPriv;

    class Priv;
    std::shared_ptr<Priv>   p_;
};

}
}

#endif // MCLOUD_API_DISKINFO_H_
