/*
 * Copyright © 2016 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3,
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by: Gary Wang <gary.wang@canonical.com>
 */

#include <mcloud/api/diskinfo.h>

#include <tinyxml2.h>

using namespace mcloud::api;
using namespace std;

class DiskInfo::Priv {
public:
    Priv(const tinyxml2::XMLElement *result) {
        const tinyxml2::XMLElement *root = result->FirstChildElement();
        free_disk_size_ = std::atoi(root->FirstChildElement("freeDiskSize")->GetText());
        disk_size_ = std::atoi(root->FirstChildElement("diskSize")->GetText());
    }

    int free_disk_size_;

    int disk_size_;
};

DiskInfo::DiskInfo(const tinyxml2::XMLElement *result)
    : p_(std::make_shared<Priv>(result)){
}

int DiskInfo::free_disk_size() const {
    return p_->free_disk_size_;
}

int DiskInfo::disk_size() const {
    return p_->disk_size_;
}
