/*
 * Copyright © 2016 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3,
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by: Gary Wang <gary.wang@canonical.com>
 */

#include <mcloud/api/outlink.h>

#include <tinyxml2.h>

using namespace mcloud::api;
using namespace std;

class Outlink::Priv {
public:
    Priv(const tinyxml2::XMLElement *root) {
        id_ = root->FirstChildElement("objID")->GetText();
        link_ = root->FirstChildElement("linkUrl")->GetText();
    }

    std::string id_;

    std::string link_;
};

Outlink::Outlink(const tinyxml2::XMLElement *root)
    : p_(std::make_shared<Priv>(root)){
}

const string &Outlink::id() const {
    return p_->id_;
}

const string &Outlink::link() const {
    return p_->link_;
}
