/*
 * Copyright © 2016 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3,
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by: Gary Wang <gary.wang@canonical.com>
 */

#ifndef MCLOUD_API_UPLOADTASKPRIV_H_
#define MCLOUD_API_UPLOADTASKPRIV_H_

#include <mcloud/api/task.h>

#include <memory>
#include <fstream>

namespace tinyxml2 {
    class XMLElement;
}

namespace mcloud {
namespace api {

class TaskHandler;

class UploadTaskPriv {
public:
    typedef std::shared_ptr<UploadTaskPriv>  Ptr;

    UploadTaskPriv(const tinyxml2::XMLElement *root,
                   const std::string &task_id,
                   const std::string &redirection_url,
                   const std::string &file_path);

    UploadTaskPriv(const tinyxml2::XMLElement *root,
                   const std::string &task_id,
                   const std::string &redirection_url,
                   size_t buffer_size,
                   Task::Buffer_Callback buffer_callback);

    const std::string & task_id() const;

    const std::string & content_id() const;

    const std::string & content_name() const;

    const std::string & file_path() const;

    const std::string & task_url() const;

    Task::Status status() const;

    Task::ProgressHandler & progress_changed();

    Task::StatusHandler & status_changed();

    Task::Buffer_Callback & buffer_callback();

    const std::string & error_string() const;

    void set_error_string(const std::string & err);

    void cancel();

    size_t file_size() const;

    bool is_need_upload() const;

    std::shared_ptr<TaskHandler> task_handler() const;

    std::ifstream & ifstream();

protected:
    void fillRequest(const tinyxml2::XMLElement *root);

private:
    std::string file_path_;

    size_t      file_size_;

    std::string upload_task_id_;

    std::string task_url_;

    std::string content_id_;

    std::string content_name_;

    std::string error_string_;

    bool        is_need_upload_;

    std::ifstream   ifs_;

    Task::ProgressHandler progress_handler_;

    Task::StatusHandler status_handler_;

    Task::Buffer_Callback buffer_callback_;

    std::shared_ptr<TaskHandler> task_handler_;
};

}
}

#endif // MCLOUD_API_UPLOADTASKPRIV_H_
