/*
 * Copyright (C) 2008 Michael Lamothe
 *
 * This file is part of Me TV
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor Boston, MA 02110-1301,  USA
 */
 
#ifndef __DVB_DVR_H__
#define __DVB_DVR_H__

#include <sys/poll.h>
#include <fcntl.h>
#include "exception.h"

#define PACKET_SIZE			188

class DvbDvr : public IO::Channel
{
private:
	struct pollfd pfd[1];
	
	static int create_fd(const String& device_path)
	{
		int result = open(device_path.c_str(), O_RDONLY|O_NONBLOCK);
		if(result < 0)
		{
			throw SystemException("Failed to open dvr device");
		}
		
		return result;
	}
	
public:
	DvbDvr(const String& device_path) : IO::Channel(create_fd(device_path))
	{
		pfd[0].fd = get_fd();
		pfd[0].events = POLLIN;
	}

	int read(void* ts_packet, unsigned int length)
	{
		int bytes_read = 0;

		if (poll(pfd,1,100))
		{
			if (pfd[0].revents & POLLIN)
			{
				bytes_read = ::read(get_fd(), (char *)ts_packet, length);

				if (bytes_read < 0)
				{
					throw SystemException("Failed to read from DVR device");
				}
			}
		}
				
		return bytes_read;
	}
};

#endif
