#include <mecab.h>
#include <stdio.h>
#include <stdlib.h>

int main (int argc, char **argv)
{
   char p[] = "ϺϼϺäƤܤֻҤϤ";
   mecab_t *c = mecab_new (argc, argv);
   mecab_node_t *n;
   char *r;
   int i;

   if (!c) {
      fprintf (stderr, "Exception: [%s]\n", mecab_strerror (0));
      return -1;
   }

   r = mecab_sparse_tostr (c, p);
   

   if (!r) {
      fprintf (stderr, "Exception: [%s]\n", mecab_strerror (c));
      return -1;
   }

   fprintf (stdout, "%s\n", r);

   /* mecab_lock (c); */

   n = mecab_sparse_tonode (c, p);

   if (!n) {
      fprintf (stderr, "Exception: [%s]\n", mecab_strerror (c));
      return -1;
   }
   
   for (;  n ; n = n->next) {
      fwrite (n->surface, n->length, sizeof (char), stdout);
      fprintf (stdout, "\t%s\n",n->feature);
   }
   fprintf (stdout, "EOS\n");    

   /* mecab_unlock (c); */
   
   r = mecab_nbest_sparse_tostr (c, 10, p);

   if (!r) {
      fprintf (stderr, "Exception: [%s]\n", mecab_strerror (c));
      return -1;
   }

   fprintf (stdout, "%s", r);

   if (! mecab_nbest_init (c, p)) {
      fprintf (stderr, "Exception: [%s]\n", mecab_strerror (c));
      return -1;
   };
   
   for (i = 0; i < 10; ++i) {
      fprintf (stdout, "%s", mecab_nbest_next_tostr (c));
   }
   
   mecab_destroy (c);

   return 0;
} 
