/*
  MeCab -- Yet Another Part-of-Speech and Morphological Analyzer
 
  $Id: csv.cpp,v 1.6 2004/08/06 18:05:14 taku-ku Exp $;

  Copyright (C) 2001-2004 Taku Kudo <taku-ku@is.aist-nara.ac.jp>
  This is free software with ABSOLUTELY NO WARRANTY.
  
  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.
  
  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.
  
  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/  
#include "csv.h"

namespace MeCab {

  std::ostream &Csv::toCsv (std::ostream &os)
  {
     for (unsigned int i = 0; i < size(); i++) {
	if (i != 0) os << fieldsep;
	size_t k = (*this)[i].find_first_of (fieldsep, 0);
	if (k == std::string::npos) // not found
	  os << (*this)[i];
	else {
	  os << '"';
	  unsigned int length = (*this)[i].size();
	  for (unsigned int j = 0; j < length; j++) {
	     if ((*this)[i][j] == '"')
	       os << '"';
	     os << (*this)[i][j];
	  }
	  os << '"';
	}
     }
     
     return os;
  }

  unsigned int Csv::advplain (const std::string &s, std::string &fld, unsigned int i)
  {
    size_t j = s.find_first_of (fieldsep, i);
    if (j == std::string::npos) j = s.length ();
    fld = std::string (s, i, j-i);
    return j;
  }

  unsigned int Csv::advquoted (const std::string &s, std::string &fld, unsigned int i)
  {
    unsigned int j;
    fld = "";
    for (j = i; j < s.length (); j++) {
      if (s[j] == '"' && s[++j] != '"') {
	size_t k = s.find_first_of (fieldsep, j);
	 if (k == std::string::npos) k = s.length ();
	for (k -=j; k-- > 0;)
	  fld += s[j++];
	break;
      }
      fld += s[j];
    }

    return j;
  }

   unsigned int Csv::split (const std::string &line)
  {
    clear ();
    fieldPos.clear ();
    if (line.length () == 0) return 0;

    std::string fld;
    unsigned int i,j;
    unsigned int length = line.length ();

    i = 0;
    do {
      if (i < length && line[i] == '"') {
	j = advquoted (line, fld, ++i); // skip quote
	fieldPos.push_back (std::pair <unsigned int, unsigned int> (i,j-1));
      }
      else {
	j = advplain (line, fld, i);
	fieldPos.push_back (std::pair <unsigned int, unsigned int> (i,j));
      }
      push_back (fld);
      i = j + 1;
    } while (j < length);

    return size ();
  }
}


