/*
  MeCab -- Yet Another Part-of-Speech and Morphological Analyzer

  $Id: dictionary_rewriter.h,v 1.3 2006/07/09 11:26:27 taku-ku Exp $;

  Copyright (C) 2001-2006 Taku Kudo <taku@chasen.org>
  Copyright (C) 2004-2006 Nippon Telegraph and Telephone Corporation

*/
#ifndef MECAB_DICTIONARY_REWRITER_H
#define MECAB_DICTIONARY_REWRITER_H

#include <vector>
#include <string>
#include <map>
#include "common.h"

namespace MeCab {

  class RewritePattern {
  private:
    std::vector<std::string> spat_;
    std::vector<std::string> dpat_;
    bool match(const char *, const char *);
  public:
    bool set_pattern(const char *, const char *);
    bool rewrite(size_t,
                 char **,
                 std::string &output);
  };

  class RewriteRules: public std::vector<RewritePattern> {
  public:
    bool rewrite(size_t,
                 char **,
                 std::string &output);
  };

  struct FeatureSet {
    std::string ufeature;
    std::string lfeature;
    std::string rfeature;
  };

  class DictionaryRewriter {
  private:
    RewriteRules unigram_rewrite_;
    RewriteRules left_rewrite_;
    RewriteRules right_rewrite_;
    std::map<std::string, FeatureSet> cache_;
    void append(RewriteRules &r, char* str);

  public:
    bool open(const char *filename);
    void clear();
    bool rewrite(const std::string &feature,
                 std::string &ufeature,
                 std::string &lfeature,
                 std::string &rfeature);

    bool rewrite2(const std::string &feature,
                  std::string &ufeature,
                  std::string &lfeature,
                  std::string &rfeature);
  };

  class POSIDGenerator {
  private:
    RewriteRules rewrite_;
  public:
    bool open(const char *filename);
    void clear();
    int id(const char *);
  };
}
#endif

