/*************************************************************************
* COPYRIGHT (C) 1999 - 2003  EDF R&D
* THIS LIBRARY IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
* IT UNDER THE TERMS OF THE GNU LESSER GENERAL PUBLIC LICENSE 
* AS PUBLISHED BY THE FREE SOFTWARE FOUNDATION; 
* EITHER VERSION 2.1 OF THE LICENSE, OR (AT YOUR OPTION) ANY LATER VERSION.
*  
* THIS LIBRARY IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
* WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
* MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
* LESSER GENERAL PUBLIC LICENSE FOR MORE DETAILS.
*
* YOU SHOULD HAVE RECEIVED A COPY OF THE GNU LESSER GENERAL PUBLIC LICENSE
* ALONG WITH THIS LIBRARY; IF NOT, WRITE TO THE FREE SOFTWARE FOUNDATION,
* INC., 59 TEMPLE PLACE, SUITE 330, BOSTON, MA 02111-1307 USA
*
*************************************************************************/

/******************************************************************************
 * - Nom du fichier : test11.c
 *
 * - Description : lecture de champs de resultats MED 
 *
 *****************************************************************************/

#include <med.h>
#include <med_utils.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#define USER_INTERLACE MED_FULL_INTERLACE


med_err getFieldsOn(med_idt fid, char * nomcha, med_type_champ typcha, med_int ncomp,
		    med_entite_maillage entite, med_mode_switch stockage);

int main (int argc, char **argv)
{
  med_err ret,lret;
  med_idt fid;
  char * fichier;
  char maa[MED_TAILLE_NOM+1];
  char desc[MED_TAILLE_DESC+1];
  char pflname[MED_TAILLE_NOM+1],nomlien[MED_TAILLE_NOM+1];
  char * lien = NULL;
  char *comp, *unit;
  char nomcha  [MED_TAILLE_NOM+1];
  med_int mdim,ncomp,ncha,npro,nln,pflsize,*pflval,nval;
  med_type_champ typcha;
  med_maillage type;
  int i,j;
  
  if (argc != 2) {
    MESSAGE("Aucun nom de fichier prcis, fichier test10.med utilis ");
    fichier = "test10.med";
  } else {
    fichier = argv[1];
  };


  /* Ouverture du fichier med */
  if ((fid = MEDouvrir(fichier,MED_LECTURE)) < 0){
    MESSAGE("Erreur  l'ouverture du fichier : ");SSCRUTE(fichier);
    return -1;
  }
   
  ret = 0;
  
  /* infos sur le premier maillage */
  if ( (ret = MEDmaaInfo(fid,1,maa,&mdim,&type,desc)) <0 ) {
    MESSAGE("Erreur  l'ouverture du fichier : ");
    return ret;
  }
  
  printf("Maillage de nom %s et de dimension %d \n",maa,mdim);

  /* combien de champs dans le fichier */
  if ((ncha = MEDnChamp(fid,0)) < 0) {
    MESSAGE("Impossible de lire le nombre de champs : ");ISCRUTE(ncha);
    return ncha;
  }
  
  printf("Nombre de champs : |%d| \n",ncha);
  
  /* lecture de tous les champs  */
  for (i =0;i<ncha;i++) {
    lret = 0;
    printf("\nChamp numero : |%d| \n",i+1);
    
    /* Lecture du nombre de composantes */
    if ((ncomp = MEDnChamp(fid,i+1)) < 0) {
      MESSAGE("Erreur  la lecture du nombre de composantes : "); ISCRUTE(ncomp); 
      ret = -1; continue;
    }
    
    /* Lecture du type du champ, des noms des composantes et du nom de l'unit*/
    comp = (char*) malloc(ncomp*MED_TAILLE_PNOM+1);
    EXIT_IF(comp == NULL,NULL,NULL);
    unit = (char*) malloc(ncomp*MED_TAILLE_PNOM+1);
    EXIT_IF(unit == NULL,NULL,NULL);
      
    if ( MEDchampInfo(fid,i+1,nomcha,&typcha,comp,unit,ncomp) < 0 ) {
      MESSAGE("Erreur  la demande d'information sur les champs : "); 
      ret = -1; continue;
    }
      
    printf("Nom du champ : |%s| de type |%d|\n",nomcha,typcha);
    printf("Nom des composantes : |%s|\n",comp);
    printf("Unites des composantes : |%s| \n",unit);
    
    free(comp);
    free(unit);
    
      
    lret = getFieldsOn(fid, nomcha, typcha, ncomp, MED_NOEUD,USER_INTERLACE );
    
    if (lret == 0) lret = getFieldsOn(fid, nomcha, typcha, ncomp, MED_MAILLE, USER_INTERLACE );
    else { MESSAGE("Erreur  la lecture des champs aux noeuds "); ret = -1; continue;}
   
    if (lret == 0) lret = getFieldsOn(fid, nomcha, typcha, ncomp, MED_FACE,USER_INTERLACE);
    else { MESSAGE("Erreur  la lecture des champs aux mailles "); ret = -1; continue;}
   
    if (lret == 0) lret = getFieldsOn(fid, nomcha, typcha, ncomp, MED_ARETE,USER_INTERLACE);
    else {MESSAGE("Erreur  la lecture des champs aux faces "); ret = -1; continue;}
    
    if  (lret != 0) {MESSAGE("Erreur  la lecture des champs aux aretes "); ret = -1;};
  } 
  

  /* Interrogation des profils */
  npro = MEDnProfil(fid);
  
  printf("\nNombre de profils stocks : %i\n",npro);
  for (i=1 ; i <= npro ; i++ ) {
    if ( MEDprofilInfo(fid, i, pflname, &nval) < 0)  {
      MESSAGE("Erreur  la demande d'information sur le profil n : "); ISCRUTE(i);
      ret = -1;continue;
    }
    printf("\t- Profil n%i de nom |%s| et de taille %i\n",i,pflname,nval);
    pflval = (med_int*) malloc(sizeof(med_int)*nval);
    if ( MEDprofilLire(fid, pflval, pflname) < 0) {
      MESSAGE("Erreur  la lecture des valeurs du profil : "); 
      SSCRUTE(pflname);
      ret = -1;continue;
    }
    for (j=0;j<nval;j++) printf("\t\t%i\n",*(pflval+j));
    free(pflval);
  }
  
  /* Interrogation des liens */
  nln = MEDnLien(fid);
  
  printf("\nNombre de liens stocks : %i\n",nln);
  for (i=1 ; i <= nln ; i++ ) {
    if ( MEDlienInfo(fid, i, nomlien, &nval) < 0)  {
      MESSAGE("Erreur  la demande d'information sur le lien n : "); ISCRUTE(i);
      ret = -1;continue;
    }
    printf("\t- Lien n%i de nom |%s| et de taille %i\n",i,nomlien,nval);

    lien = malloc(nval*sizeof(char));
    EXIT_IF(lien == NULL,NULL,NULL);

    if ( MEDlienLire(fid, lien, nomlien) < 0 )  {
      MESSAGE("Erreur  la lecture du lien : "); 
      SSCRUTE(nomlien);SSCRUTE(lien);
      ret = -1; continue;
    }
    printf("\t\t|%s|\n",lien);
    free(lien);
  }
  

  /* fermeture du fichier */
  if ( MEDfermer(fid) < 0) return -1;
  
  return ret;
}
	
med_err getFieldsOn(med_idt fid, char * nomcha, med_type_champ typcha, med_int ncomp,
		    med_entite_maillage entite, med_mode_switch stockage) {
	      
  int j,k,l,m,nb_geo;
  med_int nbpdtnor,pflsize,*pflval,ngauss,*vale,nval;
  med_int numdt,numo,lnsize,nbrefmaa;
  med_float *valr,dt;
  med_err ret=0;
  med_booleen local;
  char pflname [MED_TAILLE_NOM+1];
  char locname [MED_TAILLE_NOM+1];
  char * lien = NULL;
  char maa_ass [MED_TAILLE_NOM+1];
  char dt_unit [MED_TAILLE_PNOM+1]="";

  med_geometrie_element * type_geo;
  med_geometrie_element typ_noeud[1] = { (med_geometrie_element) 0 };
  med_geometrie_element typmai[MED_NBR_GEOMETRIE_MAILLE+2] = {MED_POINT1,MED_SEG2, 
							      MED_SEG3,MED_TRIA3,
							      MED_TRIA6,MED_QUAD4,
							      MED_QUAD8,MED_TETRA4,
							      MED_TETRA10,MED_HEXA8,
							      MED_HEXA20,MED_PENTA6,
							      MED_PENTA15,MED_PYRA5,
							      MED_PYRA13,
							      MED_POLYGONE,
							      MED_POLYEDRE};
  med_geometrie_element typfac[MED_NBR_GEOMETRIE_FACE+1] = {MED_TRIA3,MED_TRIA6,
							    MED_QUAD4,MED_QUAD8,
							    MED_POLYGONE};
  med_geometrie_element typare[MED_NBR_GEOMETRIE_ARETE] = {MED_SEG2,MED_SEG3};  
  
  switch (entite) {
  case MED_NOEUD : 
    type_geo = typ_noeud;
    nb_geo   = 1;
    break;
  case  MED_MAILLE : 
    type_geo = typmai;
    nb_geo   = MED_NBR_GEOMETRIE_MAILLE+2;
    break;
  case  MED_FACE : 
    type_geo = typfac;
    nb_geo   = MED_NBR_GEOMETRIE_FACE+1;
    break;
  case  MED_ARETE : 
    type_geo = typare;
    nb_geo   = MED_NBR_GEOMETRIE_ARETE;
    break;
  }
	
      
  for (k=0;k<nb_geo;k++) {
    
    /* Combien de (PDT,NOR) a lire */
    nbpdtnor = MEDnPasdetemps(fid,nomcha,entite,type_geo[k]); 
    if (nbpdtnor < 1 ) continue;
	      
    for (j=0;j<nbpdtnor;j++) {
		
      if ( MEDpasdetempsInfo(fid,nomcha,entite,type_geo[k],
			      j+1, &ngauss, &numdt, &numo, dt_unit,
			     &dt, maa_ass, &local, &nbrefmaa) <0) {
	MESSAGE("Erreur  la demande d'information sur (pdt,nor) : "); 
	ISCRUTE(numdt); ISCRUTE(numo);
	ret = -1; continue;
      };
	
      printf("\n\tPas de Temps n |%4i| (%f), Nd'ordre |%4i|, avec |%i| pts de gauss.\n",
	     numdt,dt,numo,ngauss);
      
      printf("\tLe maillage par dfaut est : |%s|, sur un total de : |%i| maillages associs\n",
	     maa_ass, nbrefmaa);

      /* Le maillage rfrenc est-il port par un autre fichier */
      if ( !local ) {
	
	if ( (lnsize=MEDnValLien(fid,maa_ass) ) < 0 )  {
	  MESSAGE("Erreur  la lecture de la taille du lien : "); 
	  SSCRUTE(maa_ass);
	  ret = -1;
	} else {

	  lien = malloc(lnsize*sizeof(char));
	  EXIT_IF(lien == NULL,NULL,NULL);

	  if ( MEDlienLire(fid, lien, maa_ass) < 0 )  {
	    MESSAGE("Erreur  la lecture du lien : "); 
	    SSCRUTE(maa_ass);SSCRUTE(lien);
	    ret = -1; 
	  } else {
	    printf("\tLe maillage |%s| est port par un fichier distant |%s|\n",maa_ass,lien);
	  }
	  free(lien);
	}
      }

      /* Combien de maillages lis aux (nomcha,ent,geo,numdt,numo)  */
      /* Notons que cette information est galement disponible  partir de MEDpasdetempsInfo */
      if ( (nbrefmaa = MEDnChampRef(fid,nomcha,entite,type_geo[k],numdt,numo) ) < 0 ) {
	MESSAGE("Erreur  la demande du nombre de maillages rfrencs par le champ : "); 
	SSCRUTE(nomcha); ISCRUTE(numdt); ISCRUTE(numo);
	ret = -1; continue;
      };

      for (l=0;l<nbrefmaa;l++) {
	
	if ( MEDchampRefInfo(fid,nomcha,entite,type_geo[k],
			     l+1,numdt, numo, maa_ass, &local, &ngauss) <0 ) {
	  MESSAGE("Erreur  la demande d'information sur le maillage utilis par le champ n : "); 
	  ISCRUTE(l+1);
	  ret = -1; continue;
	};		  
		  
	/*prend en compte le nbre de pt de gauss automatiquement */
	if ((nval = MEDnVal(fid,nomcha,entite,type_geo[k],numdt,numo,maa_ass)) <= 0)   {
	  MESSAGE("Erreur  la lecture du nombre de valeurs du champ : "); 
	  SSCRUTE(nomcha);ISCRUTE(entite);ISCRUTE(type_geo[k]);ISCRUTE(numdt);ISCRUTE(numo);SSCRUTE(maa_ass);
	  ret = -1; continue;
	};	
	  
	  
	printf("\t- Il y a %d valeurs (%s) avec |%i| pts de gauss \
sur les mailles de type %d associs au maillage |%s|\n",
	       nval,dt_unit,ngauss,type_geo[k],maa_ass);                    

	
	/*Lecture des valeurs du champ */
	if (typcha == MED_FLOAT64) {
	  
	  valr = (med_float*) calloc(ncomp*nval,sizeof(med_float));
	  EXIT_IF(valr == NULL,NULL,NULL);
	  if ( MEDchampLire(fid,maa_ass,nomcha,(unsigned char*)valr,stockage,MED_ALL,locname,
			    pflname,entite,type_geo[k],numdt,numo) < 0 ) {
	    MESSAGE("Erreur  la lecture du nombre de valeurs du champ : "); 
	    SSCRUTE(nomcha);ISCRUTE(entite);ISCRUTE(type_geo[k]);
	    ISCRUTE(numdt);ISCRUTE(numo);SSCRUTE(maa_ass);
	    ret = -1;
	  };		  
	  for (m=0;m<nval*ncomp;m++) printf("\t- Valeurs : %f\n",*(valr+m));
	  free(valr);
	  
	} else {
	  
	  vale = (med_int*) calloc(ncomp*nval,sizeof(med_int));
	  EXIT_IF(vale == NULL,NULL,NULL);
	  if ( MEDchampLire(fid,maa_ass,nomcha,(unsigned char*)vale,MED_FULL_INTERLACE,MED_ALL,locname,
			    pflname,entite,type_geo[k],numdt,numo) < 0 ) {
	    MESSAGE("Erreur  la lecture des valeurs du champ : "); 
	    SSCRUTE(nomcha);ISCRUTE(entite);ISCRUTE(type_geo[k]);
	    ISCRUTE(numdt);ISCRUTE(numo);SSCRUTE(maa_ass);
	    ret = -1;
	  };	
	  for (m=0;m<nval*ncomp;m++) printf("\t- Valeurs : %i\n",*(vale+m));
	  free(vale);
	}
	
	/*Lecture du profil associ */
	if (strcmp(pflname,MED_NOPFL) == 0 )
	  printf("\t- Profil : MED_NOPFL\n");
	else {
	
	  if ( (pflsize = MEDnValProfil(fid,pflname)) <0 )  {
	    MESSAGE("Erreur  la lecture du nombre de valeurs du profil : "); 
	    SSCRUTE(pflname);
	    ret = -1; continue;
	  }
		  
	  printf("\t- Profil : |%s| de taille |%i|\n",pflname,pflsize);
	  
	  pflval = (med_int*) malloc(sizeof(med_int)*pflsize);
	  EXIT_IF(pflval == NULL,NULL,NULL);
	  if ( MEDprofilLire(fid,pflval,pflname) <0) {
	    MESSAGE("Erreur  la lecture des valeurs du profil : "); 
	    SSCRUTE(pflname);
	    ret = -1;
	  }
	  for (m=0;m<pflsize;m++) printf("\t%i\n",*(pflval+m));
	  free(pflval);
	  
	}
	
      }
    } 
  } /* fin for sur les mailles*/
  
  return ret;
}
