C*************************************************************************
C COPYRIGHT (C) 1999 - 2003  EDF R&D
C THIS LIBRARY IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
C IT UNDER THE TERMS OF THE GNU LESSER GENERAL PUBLIC LICENSE 
C AS PUBLISHED BY THE FREE SOFTWARE FOUNDATION; 
C EITHER VERSION 2.1 OF THE LICENSE, OR (AT YOUR OPTION) ANY LATER VERSION.
C
C THIS LIBRARY IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
C WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
C MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
C LESSER GENERAL PUBLIC LICENSE FOR MORE DETAILS.
C
C YOU SHOULD HAVE RECEIVED A COPY OF THE GNU LESSER GENERAL PUBLIC LICENSE
C ALONG WITH THIS LIBRARY; IF NOT, WRITE TO THE FREE SOFTWARE FOUNDATION,
C INC., 59 TEMPLE PLACE, SUITE 330, BOSTON, MA 02111-1307 USA
C
C**************************************************************************

C******************************************************************************
C* - Nom du fichier : test21.f
C*
C* - Description : ecriture de valeurs scalaires numeriques dans un fichier MED
C*
C ******************************************************************************
      program test21
C     
      implicit none
      include 'med.hf'
C
      integer cret, fid
      character*16 edtuni,dtunit1
      character*32 nom1, nom2
      character*200 desc1, desc2
      integer vali1, vali2
      real*8 valr1,dt
C
      parameter (nom1="VariableEntiere")
      parameter (nom2="VariableFlottante")
      data desc1 / "Une premiere description" /
      data desc2 / "Une seconde description" /
      parameter (vali1 = 56,vali2 = -789)
      parameter (valr1 = 67.98)
      parameter (edtuni="",dtunit1="ms")
      parameter (dt = 5.5)
C
C     
C     Creation du fichier test21.med
C
      call efouvr(fid,'test21.med',MED_CREATION,cret)
      print *,cret
      print *,'Creation du fichier test21.med'
C
C     Creation d'une variable scalaire entiere 
C
      if (cret .eq. 0) then
         call efscac(fid,nom1,MED_INT,desc1,cret)
         print *,cret
         print *,'Creation d une variable scalaire entiere'
      endif
C
C     Ecriture d'une valeur sans pas de temps ni numero d'ordre
C
      if (cret .eq. 0) then
         call efscee(fid,nom1,vali1,MED_NOPDT,edtuni,0.0,MED_NONOR,cret)
         print *,cret
         print *,'Ecriture valeur entiere sans pas de temps'
      endif
C
C     Ecriture d'une valeur avec pas de temps et sans numero d'ordre
C
      if (cret .eq. 0) then
         call efscee(fid,nom1,vali2,1,dtunit1,dt,MED_NONOR,cret)
         print *,cret
         print *,'Ecriture valeur entiere avec pas de temps'
      endif
C
C     Creation d'une variable scalaire flottante
C
      if (cret .eq. 0) then
         call efscac(fid,nom2,MED_FLOAT64,desc2,cret)
         print *,cret
         print *,'Creation d une variable scalaire flottante'
      endif
C
C     Ecriture d'une valeur flottante avec pas de temps et numero d'ordre
C
      if (cret .eq. 0) then
         call efscfe(fid,nom2,valr1,1,dtunit1,dt,2,cret)
         print *,cret
         print *,'Ecriture valeur entiere avec pas de temps'
      endif
C
C     Fermeture du fichier      
C
      call efferm(fid,cret)
      print *,cret
      print *,'Fermeture du fichier test21.med'
C
      end
C
