/*************************************************************************
* COPYRIGHT (C) 1999 - 2006  EDF R&D
* THIS LIBRARY IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
* IT UNDER THE TERMS OF THE GNU LESSER GENERAL PUBLIC LICENSE 
* AS PUBLISHED BY THE FREE SOFTWARE FOUNDATION; 
* EITHER VERSION 2.1 OF THE LICENSE, OR (AT YOUR OPTION) ANY LATER VERSION.
*  
* THIS LIBRARY IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
* WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
* MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
* LESSER GENERAL PUBLIC LICENSE FOR MORE DETAILS.
*
* YOU SHOULD HAVE RECEIVED A COPY OF THE GNU LESSER GENERAL PUBLIC LICENSE
* ALONG WITH THIS LIBRARY; IF NOT, WRITE TO THE FREE SOFTWARE FOUNDATION,
* INC., 59 TEMPLE PLACE, SUITE 330, BOSTON, MA 02111-1307 USA
*
*************************************************************************/

#include <med.h>
#include <med_config.h>
#include <med_outils.h>
#include <stdlib.h>
#include <string.h>

#define nedffamc F77_FUNC(edffamc,EDFFAMC)
#define nedffame F77_FUNC(edffame,EDFFAME)
#define nedffaml F77_FUNC(edffaml,EDFFAML)
#define nedffami F77_FUNC(edffami,EDFFAMI)
#define nedfnfam F77_FUNC(edfnfam,EDFNFAM)
#define nedfngro F77_FUNC(edfngro,EDFNGRO)
#define nedfnatt F77_FUNC(edfnatt,EDFNATT)


#ifdef PPRO_NT
med_int
__stdcall EDFFAMC(med_int *fid, char *maa, unsigned int bidon1, med_int *lon1,
                  char *fam, unsigned int bidon2, med_int *lon2, 
	          med_int *num, med_int *attr_ident, med_int *attr_val,
                  char *attr_desc, unsigned int bidon3, 
	          med_int *lon3, med_int *n_attr, char *groupe , 
                  unsigned int bidon4, med_int *lon4, med_int *n_groupe)
#else
med_int
nedffamc(med_int *fid,char *maa,med_int *lon1,char *fam,med_int *lon2, 
	 med_int *num,med_int *attr_ident,med_int *attr_val,char *attr_desc, 
	 med_int *lon3,med_int *n_attr,char *groupe ,med_int *lon4, 
	 med_int *n_groupe)
#endif
{
  med_int ret;
  char *  fn1, *fn2, *fn3, *fn4;

  fn1 = _MED2cstring(maa, (int) * lon1);
  fn2 = _MED1cstring(fam, (int) * lon2,MED_TAILLE_NOM);
  fn3 = _MED1cstring(attr_desc,(int) * lon3,
		     (int) *n_attr*MED_TAILLE_DESC);
  fn4 = _MED1cstring(groupe, (int) * lon4,
		     (int) *n_groupe*MED_TAILLE_LNOM);
  
  if (!fn1 || !fn2 || !fn3 || !fn4)
    return -1; 

  ret = (med_int) MEDfamCr((med_idt) *fid,fn1,fn2,(med_int) *num, 
			   (med_int *) attr_ident,
			   (med_int *) attr_val, fn3, (med_int) *n_attr, fn4, 
			   (med_int) *n_groupe);

  _MEDcstringFree(fn1);
  _MEDcstringFree(fn2); 
  _MEDcstringFree(fn3);
  _MEDcstringFree(fn4);

  return(ret);   
}

#ifdef PPRO_NT
med_int
__stdcall EDFFAME (med_int *fid, char *maa, unsigned int bidon, med_int *lon1,
                   med_int *fam, med_int *n, med_int *type_ent,
                   med_int *type_geo)
#else
med_int
nedffame(med_int *fid,char *maa,med_int *lon1,med_int *fam, 
	 med_int *n, med_int *type_ent,med_int *type_geo)
#endif
{
  med_int ret;
  char *  fn1;
  
  fn1 = _MED2cstring(maa, (int) * lon1);
  if (!fn1 )
    return(-1);

  ret = (med_int) MEDfamEcr((med_idt) *fid,fn1,(med_int *)fam,
			   (med_int) *n,
			   (med_entite_maillage) *type_ent,
			   (med_geometrie_element) *type_geo); 

  _MEDcstringFree(fn1);

  return(ret);
}


#ifdef PPRO_NT
med_int
__stdcall EDFFAML(med_int *fid, char *maa, unsigned int bidon, med_int *lon1,
                  med_int *fam, med_int *n, med_int *type_ent,
                  med_int *type_geo)
#else
med_int
nedffaml(med_int *fid, char *maa, med_int *lon1, med_int *fam, 
	 med_int *n,med_int *type_ent,med_int *type_geo)
#endif
{
  med_int ret;
  char *  fn1;
  
  fn1 = _MED2cstring(maa, (int) * lon1);
  if (!fn1 )
    return(-1);

  ret = (med_int) MEDfamLire((med_idt) *fid,fn1,(med_int*) fam,(med_int) *n, 
			     (med_entite_maillage) *type_ent,
			     (med_geometrie_element) *type_geo); 

  _MEDcstringFree(fn1);

  return(ret);
}


#ifdef  PPRO_NT
int
__stdcall EDFFAMI(med_int *fid, char *maa, unsigned int bidon1, med_int *lon1,
                  med_int *ind, char *fam, unsigned int bidon2, med_int *num,
                  med_int *attr_ident, med_int *attr_val, 
	          char *attr_desc, int unsigned bidon3, med_int *n_attr,
	          char *groupe , int unsigned bidon4, med_int *n_groupe)
#else
med_int
nedffami(med_int *fid, char *maa,med_int *lon1,med_int *ind, 
	 char *fam,med_int *num,med_int *attr_ident,med_int *attr_val, 
	 char *attr_desc,med_int *n_attr,
	 char *groupe ,med_int *n_groupe)
#endif
{
  med_int ret;
  char * fn1,* fs1, * fs2;
  char fs3[MED_TAILLE_NOM+1];
  int natt,ngro,j;
  char str[MED_TAILLE_LNOM+1];

  fn1 = _MED2cstring(maa, (int) * lon1);
  if (!fn1)
    return(-1);

  if ((ngro = MEDnGroupe  ((med_idt) *fid,fn1,*ind)) < 0) return -1; 
  if ((natt = MEDnAttribut((med_idt) *fid,fn1,*ind)) < 0) return -1; 

  fs1 = (char *) malloc(MED_TAILLE_DESC*natt+1);
  fs2 = (char *) malloc(MED_TAILLE_LNOM*ngro+1);

  ret = (med_int) MEDfamInfo((med_idt) *fid,fn1,(int) *ind, (char *)fs3 , 
			     (med_int *)num, 
			     (med_int *) attr_ident,(med_int *) attr_val,
			     (char *) fs1,
			     (med_int *) n_attr,
			     (char *)fs2 ,(med_int *) n_groupe);

  strncpy(fam,fs3,MED_TAILLE_NOM);
  _MEDfstring(fam,MED_TAILLE_NOM);
  strncpy(attr_desc,fs1,MED_TAILLE_DESC*natt);
  _MEDfstring(attr_desc,MED_TAILLE_DESC*natt);

  for (j=0;j<ngro;j++) {
      strncpy(str,fs2+j*MED_TAILLE_LNOM,MED_TAILLE_LNOM);
      _MEDfstring(str,MED_TAILLE_LNOM);
      str[MED_TAILLE_LNOM] = '\0';
      if (j == 0) 
	      strcpy(groupe,str);
      else
	      strcat(groupe,str);
  } 
  _MEDfstring(groupe,MED_TAILLE_LNOM*ngro);
  free(fs1);
  free(fs2);
  
  _MEDcstringFree(fn1);
  
  return(ret);
}

#ifdef PPRO_NT
int
__stdcall EDFNFAM(med_int *fid, char *maa, unsigned int bidon, med_int *lon1)
#else
med_int
nedfnfam(med_int *fid,char *maa,med_int *lon1)
#endif
{
  med_int ret;
  char *  fn1;
  
  fn1 = _MED2cstring(maa, (int) * lon1);
  if (!fn1)
    return(-1); 

  ret = (med_int) MEDnFam((med_idt)*fid,fn1); 

  _MEDcstringFree(fn1);

  return(ret);  
}

#ifdef PPRO_NT
int
__stdcall EDFNGRO(med_int *fid, char *maa, unsigned int bidon, med_int *lon1, med_int *indice)
#else
med_int
nedfngro(med_int *fid,char *maa,med_int *lon1,med_int *indice)
#endif
{
  med_int ret;
  char *  fn1;
  
  fn1 = _MED2cstring(maa, (int) * lon1);
  if (!fn1)
    return(-1); 

  ret = (med_int) MEDnGroupe((med_idt)*fid,fn1,(int)*indice); 

  _MEDcstringFree(fn1);

  return(ret);  
}


#ifdef PPRO_NT
int
__stdcall EDFNATT(med_int *fid, char *maa, unsigned int bidon, med_int *lon1, med_int *indice)
#else
med_int
nedfnatt(med_int *fid,char *maa,med_int *lon1,med_int *indice)
#endif
{
  med_int ret;
  char *  fn1;
  
  fn1 = _MED2cstring(maa, (int) * lon1);
  if (!fn1)
    return(-1); 

  ret = (med_int) MEDnAttribut((med_idt)*fid,fn1,(int)*indice); 

  _MEDcstringFree(fn1);

  return(ret);  
}





