/*************************************************************************
* COPYRIGHT (C) 1999 - 2003  EDF R&D
* THIS LIBRARY IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
* IT UNDER THE TERMS OF THE GNU LESSER GENERAL PUBLIC LICENSE 
* AS PUBLISHED BY THE FREE SOFTWARE FOUNDATION; 
* EITHER VERSION 2.1 OF THE LICENSE, OR (AT YOUR OPTION) ANY LATER VERSION.
*  
* THIS LIBRARY IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
* WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
* MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
* LESSER GENERAL PUBLIC LICENSE FOR MORE DETAILS.
*
* YOU SHOULD HAVE RECEIVED A COPY OF THE GNU LESSER GENERAL PUBLIC LICENSE
* ALONG WITH THIS LIBRARY; IF NOT, WRITE TO THE FREE SOFTWARE FOUNDATION,
* INC., 59 TEMPLE PLACE, SUITE 330, BOSTON, MA 02111-1307 USA
*
*************************************************************************/

/*
 * - Nom de la fonction : MEDgaussLire 
 * - Description : Itrateur renvoyant (npdt,nor), le nbre de point de GAUSS pour le type d'lment,
 *                 et le  maillage par dfaut avec son eventuel lien  un autre fichier. 
 * - Parametres :
 *     - fid      (IN) : ID du fichier HDF courant
 *     - refcoo   (OUT) : Les coordonnes des noeuds de l'lment de rfrence (tableau de taille(typegeo%100)*(typegeo/100) )
 *     - gscoo    (OUT) : Les coordonnes des points de Gauss pour l'lment de rfrence (tableau de taille ngauss*type_geo/100)
 *     - wg       (OUT) : Poids  appliquer aux points d'intgration (tableau de taille ngauss)
 *     - mode_coo (IN) : Choix du type d'entrelacement utilis en mmoire pour refcoo et gscoo 
 *                        { MED_FULL_INTERLACE(x1,y1,z1,x2,...)) , MED_NO_INTERLACE(x1,x2,y1,y2,z1,z2) }
 *     - locname (IN) : Nom  associer  la localisation (MED_TAILLe_NOM) 

 REM :
   <locname> est  passer en paramtre de MEDchampEcrire.
 */

#include <med.h>
#include <med_config.h>
#include <med_outils.h>

#include <string.h>
#include <stdlib.h>

med_err 
MEDgaussLire(med_idt fid, med_float *refcoo, med_float *gscoo, med_float * wg, med_mode_switch mode_coo, char *locname)
{
  med_err ret = -1;
  med_idt locid=0;
  char chemin[MED_TAILLE_GAUSS+MED_TAILLE_NOM+1]=""; 
  med_int type_geo;
  
  /*
   * On inhibe le gestionnaire d'erreur HDF 5
   */
  _MEDmodeErreurVerrouiller();

  /* 
   * ouverture du groupe /PROFILS/"nom"
   */  
  strcpy(chemin,MED_GAUSS);
  strcat(chemin,locname); 
  if ((locid = _MEDdatagroupOuvrir(fid,chemin)) < 0) {
    MESSAGE("Impossible d'ouvrir le datagroup : ");
    SSCRUTE(chemin); goto ERROR;
  }

  
  /* Lecture <type_geo> sous forme d'attribut */
  if (_MEDattrEntierLire(locid,MED_NOM_GEO,&type_geo) < 0) {
    MESSAGE("Erreur  la lecture de l'attribut MED_NOM_GEO : ");
    ISCRUTE(type_geo);goto ERROR;
  };

  /*
   * Lecture de la localisation
   */

  /*
   * On stocke les coordonnes de rfrence dans un dataset
   */
 
  if ( _MEDdatasetNumLire(locid,MED_NOM_COO,MED_FLOAT64,mode_coo,(type_geo/100),MED_ALL,MED_NOPF,MED_NO_PFLMOD,0,MED_NOPG,
			  (unsigned char*) refcoo)  < 0 ) {
    MESSAGE("Impossible de lire le dataset : ");SSCRUTE(MED_NOM_COO);
    goto ERROR;
  }

  /*
   * On stocke les points d'intgration dans un dataset
   */
   
  if ( _MEDdatasetNumLire(locid,MED_NOM_GAU,MED_FLOAT64,mode_coo,(type_geo/100),MED_ALL,MED_NOPF,MED_NO_PFLMOD,0,MED_NOPG,
			  (unsigned char*) gscoo)  < 0 ) {
    MESSAGE("Impossible de lire le dataset : ");SSCRUTE(MED_NOM_GAU);
    goto ERROR;
  }
  
  /*
   * On stocke les poids dans un dataset
   */
   
  if ( _MEDdatasetNumLire(locid,MED_NOM_VAL,MED_FLOAT64,mode_coo,1,MED_ALL,MED_NOPF,MED_NO_PFLMOD,0,MED_NOPG,
			  (unsigned char*) wg)  < 0 ) {
    MESSAGE("Impossible de lire le dataset : ");SSCRUTE(MED_NOM_VAL);
    goto ERROR;
  }
  

  /*
   * On ferme tout
   */

  ret = 0;
 ERROR:

  if ( locid > 0 ) if ( _MEDdatagroupFermer(locid) < 0) {
    MESSAGE("Impossible de fermer le datagroup : ");
    ISCRUTE(locid); ret = -1;
  }
  
  return ret;
}

