C*************************************************************************
C COPYRIGHT (C) 1999 - 2003  EDF R&D
C THIS LIBRARY IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
C IT UNDER THE TERMS OF THE GNU LESSER GENERAL PUBLIC LICENSE 
C AS PUBLISHED BY THE FREE SOFTWARE FOUNDATION; 
C EITHER VERSION 2.1 OF THE LICENSE, OR (AT YOUR OPTION) ANY LATER VERSION.
C
C THIS LIBRARY IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
C WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
C MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
C LESSER GENERAL PUBLIC LICENSE FOR MORE DETAILS.
C
C YOU SHOULD HAVE RECEIVED A COPY OF THE GNU LESSER GENERAL PUBLIC LICENSE
C ALONG WITH THIS LIBRARY; IF NOT, WRITE TO THE FREE SOFTWARE FOUNDATION,
C INC., 59 TEMPLE PLACE, SUITE 330, BOSTON, MA 02111-1307 USA
C
C**************************************************************************

C ******************************************************************************
C * - Nom du fichier : test2.f
C *
C * - Description : exemples de creations de maillage MED
C *
C ******************************************************************************
      program test2
C     
      implicit none
      include 'med.hf'
C
C
      integer cret,ret
      integer fid
      character*200 des

C  ** verifie que le fichier test1.med est au bon format **
      call effoco('test1.med',cret)
      print *,cret
      if (cret .ne. 0 ) then
         print *,'Erreur  la vrification du format'
         call efexit(-1)
      endif      

C  ** Ouverture en mode de lecture du fichier test1.med
      call efouvr(fid,'test1.med',MED_LECTURE, cret)
      print *,cret
      if (cret .ne. 0 ) then
         print *,'Erreur ouverture du fichier en lecture'
         call efexit(-1)
      endif      

C  ** Lecture de l'en-tete du fichier
      call effien (fid, MED_FICH_DES,des,cret)
      print *,cret
      if (cret .ne. 0 ) then
         print *,'Erreur lecture en-tete du fichier'
         call efexit(-1)
      endif      
      print *,"DESCRIPTEUR DE FICHIER : ",des

 
C  ** Fermeture du fichier test1.med 
      call efferm (fid,cret)
      print *,cret
      if (cret .ne. 0 ) then
         print *,'Erreur fermeture du fichier'
         call efexit(-1)
      endif      

      
C  ** Ouverture en mode de creation du fichier test2.med
      call efouvr(fid,'test2.med',MED_CREATION, cret)
      print *,cret
      if (cret .ne. 0 ) then
         print *,'Erreur creation du fichier'
         call efexit(-1)
      endif      
      
C  **  Creation du maillage maa1 de type MED_NON_STRUCTURE
C  **  et de dimension 3
      call efmaac(fid,'maa1',3,
     &     MED_NON_STRUCTURE,
     &     'un premier maillage',ret)
      cret = cret + ret
C     **  Creation du nom universel
      call efunvc(fid,'maa1',ret)
      cret = cret + ret
      print *,cret
      if (cret .ne. 0 ) then
         print *,'Erreur creation du maillage'
         call efexit(-1)
      endif      
      
C  **  Creation du maillage maa2 de type MED_NON_STRUCTURE
C  **  et de dimension 2
      call efmaac(fid,'maa2',2,
     &     MED_NON_STRUCTURE,
     &     'un second maillage',ret)
      cret = cret + ret 
C  **  Ecriture de la dimension de l'espace : maillage
C  **  de dimension 2 dans un espace de dimension 3
      call efespc(fid,'maa2',3,ret)
      cret = cret + ret
      print *,cret
      if (cret .ne. 0 ) then
         print *,'Erreur creation du maillage'
         call efexit(-1)
      endif      

C  ** Creation du maillage maa3 de type MED_STRUCTURE
C  **  et de dimension 1
      call efmaac(fid,'maa3',1,
     &     MED_STRUCTURE,
     &     'un troisieme  maillage',ret)
      cret = cret + ret
      print *,cret
      if (cret .ne. 0 ) then
         print *,'Erreur creation du maillage'
         call efexit(-1)
      endif      

C **  Fermeture du fichier
      call efferm (fid,cret)
      print *,cret
      if (cret .ne. 0 ) then
         print *,'Erreur fermeture du fichier'
         call efexit(-1)
      endif      
C      
      end 





