C*************************************************************************
C COPYRIGHT (C) 1999 - 2003  EDF R&D
C THIS LIBRARY IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
C IT UNDER THE TERMS OF THE GNU LESSER GENERAL PUBLIC LICENSE 
C AS PUBLISHED BY THE FREE SOFTWARE FOUNDATION; 
C EITHER VERSION 2.1 OF THE LICENSE, OR (AT YOUR OPTION) ANY LATER VERSION.
C
C THIS LIBRARY IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
C WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
C MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
C LESSER GENERAL PUBLIC LICENSE FOR MORE DETAILS.
C
C YOU SHOULD HAVE RECEIVED A COPY OF THE GNU LESSER GENERAL PUBLIC LICENSE
C ALONG WITH THIS LIBRARY; IF NOT, WRITE TO THE FREE SOFTWARE FOUNDATION,
C INC., 59 TEMPLE PLACE, SUITE 330, BOSTON, MA 02111-1307 USA
C
C**************************************************************************


C ******************************************************************************
C * - Nom du fichier : test33.f
C *
C * - Description : lecture d'une numerotation globale inexistante dans un maillage MED
C *
C ******************************************************************************
	program test33

C     
	implicit none
	include 'med.hf'
C
C
        integer cret,fid
        character*32 maa 
	character*200 desc
        integer nmaa,mdim,type,narr
        integer numglb(100)




C  ** Ouverture du fichier test31.med **
	call efouvr(fid,'test31.med',MED_LECTURE, cret)
	print '(I1)',cret
	if (cret .ne. 0 ) then
	   print *,'Erreur ouverture du fichier test31.med'
	   call efexit(-1)
	endif      

  
C ** lecture du nombre de maillage                      **
	
	call efnmaa(fid,nmaa,cret)
	print '(I1)',cret
	if (cret .ne. 0 ) then
	   print *,'Erreur lecture du nombre de maillage'
	   call efexit(-1)
	endif      
	print '(A,I2)','Nombre de maillages = ',nmaa

C ** lecture des infos pour le premier maillage


	call efmaai(fid,1,maa,mdim,type,desc,cret)
	print '(I1)',cret
	if (cret .ne. 0 ) then
	   print *,'Erreur acces au premier maillage'
	   call efexit(-1)
	endif      

	call efnema(fid,maa,MED_CONN,MED_ARETE,MED_SEG2,MED_DESC
     1    ,narr,cret)   
	if (cret .ne. 0 ) then
	   print *,'Erreur acces au nombre d''arretes du premier maillage'
	   call efexit(-1)
	endif      


         print '(A,I1,A,A4,A,I1,A,I4)','maillage '
     &        ,0,' de nom ',maa,' et de dimension ',mdim,
     &        ' comportant le nombre d''arretes ',narr


C ** lecture de la numerotation globale lie aux arretes 

	 call efgnml(fid,maa,numglb,max(narr,100),
     &     MED_ARETE,MED_TRIA3,cret)

	if (cret .ge. 0 ) then
	   print '(A)','Erreur lecture numerotation globale ARRETE'
	   print '(A)','cette numerotation devait etre inexistante '
	   call efexit(-1)
	endif      


C ** Fermeture du fichier                                **
 	call efferm (fid,cret)
	print '(I1)',cret
	if (cret .ne. 0 ) then
	   print *,'Erreur fermeture du fichier'
	   call efexit(-1)
	endif      
C     
	end
