/*************************************************************************
* COPYRIGHT (C) 1999 - 2007  EDF R&D, CEA/DEN
* THIS LIBRARY IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
* IT UNDER THE TERMS OF THE GNU LESSER GENERAL PUBLIC LICENSE 
* AS PUBLISHED BY THE FREE SOFTWARE FOUNDATION; 
* EITHER VERSION 2.1 OF THE LICENSE, OR (AT YOUR OPTION) ANY LATER VERSION.
*  
* THIS LIBRARY IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
* WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
* MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
* LESSER GENERAL PUBLIC LICENSE FOR MORE DETAILS.
*
* YOU SHOULD HAVE RECEIVED A COPY OF THE GNU LESSER GENERAL PUBLIC LICENSE
* ALONG WITH THIS LIBRARY; IF NOT, WRITE TO THE FREE SOFTWARE FOUNDATION,
* INC., 59 TEMPLE PLACE, SUITE 330, BOSTON, MA 02111-1307 USA
*
*************************************************************************/

#include <med.h>
#include <med_config.h>
#include <med_outils.h>

#include <string.h>
#include <stdlib.h>

med_int 
MEDnCorres(med_idt fid,char *maa,char *eq,med_entite_maillage type_ent,
	   med_geometrie_element typ_geo)
{
  med_idt eqid, datagroup;
  char chemin[MED_TAILLE_MAA+MED_TAILLE_EQS+2*MED_TAILLE_NOM+1]; 
  char nomdatagroup[MED_TAILLE_NOM+1];
  char tmp[MED_TAILLE_NOM_ENTITE+1];
  med_int n=-1;
  med_entite_maillage _type_ent=type_ent;

  if ( type_ent == MED_NOEUD_MAILLE ) _type_ent=MED_NOEUD ;


  /*
   * On inhibe le gestionnaire d'erreur HDF 5
   */
   _MEDmodeErreurVerrouiller();

  /* 
   * Si le Data Group de "eq" n'existe pas => erreur
   */
  strcpy(chemin,MED_MAA);
  strcat(chemin,maa);
  strcat(chemin,MED_EQS);
  strcat(chemin,eq);
  if ((eqid = _MEDdatagroupOuvrir(fid,chemin)) < 0)
    goto ERROR;  
  if ( _MEDnomEntite(nomdatagroup,_type_ent) < 0)
    goto ERROR;
  if ((_type_ent != MED_NOEUD))
    {
      if ( _MEDnomGeometrie(tmp,typ_geo) < 0)
	goto ERROR;
      strcat(nomdatagroup,".");
      strcat(nomdatagroup,tmp);
    }
  if ((datagroup = _MEDdatagroupOuvrir(eqid,nomdatagroup)) < 0) n=0;

  if ( n ) /*peut valoir -1 : OK */
    if ( _MEDattrEntierLire(datagroup,MED_NOM_NBR,&n) < 0)
      goto ERROR;

  /*
   * On ferme tout
   */
 ERROR:

  if ( datagroup> 0 ) if ( _MEDdatagroupFermer(datagroup) < 0) {
  MESSAGE("Impossible de fermer le datagroup : ");
    ISCRUTE_int(datagroup);n = -1; 
  }
    if ( eqid> 0 ) if ( _MEDdatagroupFermer(eqid) < 0) {
  MESSAGE("Impossible de fermer le datagroup : ");
    ISCRUTE_id(eqid);n = -1; 
  }
  
  return n;  
}


