#include "MEDerreur.hxx"

#include <iostream>
#include <sstream>
//#include <memory>

#include <cstdlib>
#include <cstring>

/**
 * Class OSS is useful when streaming data through a function
 * that expect a string as parameter
 */
class OSS
{
private:
  std::ostringstream oss_;

public:
  explicit OSS() : oss_() {}

  template <class T>
  OSS & operator<<(T obj)
  {
    oss_ << obj;
    return *this;
  }

  operator std::string()
  {
    return oss_.str();
  }

  // Surtout ne pas crire le code suivant:
  // car oss_.str() renvoie une string temporaire
  //   operator const char*()
  //   {
  //     return oss_.str().c_str();
  //   }

}; /* end class OSS */


MEDerreur::MEDerreur( const char *fichier,
		      const unsigned int ligneNo,
		      const char * message,
		      const char * arg )
{
  OSS oss ;
  oss << "MEDerreur" ;

  if ( strcmp(fichier,"") ) {
    oss << " dans le fichier " << fichier;
    
    if ( ligneNo) oss << "[" << ligneNo << "]";
  }
    
  oss << " : " <<  message;

  _what = oss;
}

const char* MEDerreur::what( void ) const throw ()
{
  return _what.c_str();
}


