/*************************************************************************
* COPYRIGHT (C) 1999 - 2007  EDF R&D, CEA/DEN
* THIS LIBRARY IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
* IT UNDER THE TERMS OF THE GNU LESSER GENERAL PUBLIC LICENSE 
* AS PUBLISHED BY THE FREE SOFTWARE FOUNDATION; 
* EITHER VERSION 2.1 OF THE LICENSE, OR (AT YOUR OPTION) ANY LATER VERSION.
*  
* THIS LIBRARY IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
* WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
* MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
* LESSER GENERAL PUBLIC LICENSE FOR MORE DETAILS.
*
* YOU SHOULD HAVE RECEIVED A COPY OF THE GNU LESSER GENERAL PUBLIC LICENSE
* ALONG WITH THIS LIBRARY; IF NOT, WRITE TO THE FREE SOFTWARE FOUNDATION,
* INC., 59 TEMPLE PLACE, SUITE 330, BOSTON, MA 02111-1307 USA
*
*************************************************************************/

#ifndef MESGERR
#define MESGERR 1
#endif

#ifdef __cplusplus
extern "C" {
#endif

#include "med_config.h"
#include "med_outils.h"
#include <string.h>

#ifdef __cplusplus
}
#endif

#include "med21.h"
#include "med_hdfi21.h"
#include "MAJ_21_22.h"

void MAJ_21_22_familles_maillage(med_idt mid)
{
  med_idt fid, gid;
  char *nouvelle_chaine;
  int n;
  med_size dimd[1];
  med_err ret;
  int i;
  char chemin[MED_TAILLE_FAS+2*MED_TAILLE_NOM+1];
  char nom[MED_TAILLE_NOM+1];
  char *noeuds, *elements;
  int nnoeuds = 0;
  int nelements = 0;
  med_int numero;
  char *groupe_noeuds = "NOEUD";
  char *groupe_elements = "ELEME";
  char *nom_famille_zero = "FAMILLE_ZERO";
  char famille0[MED_TAILLE_NOM+1];
  int *index_noeuds, *index_elements;
  char stockage[MED_TAILLE_DESC];
  med_float *valr;

  /* Combien de famille ? */
  fid = _MEDdatagroupOuvrir(mid,"FAS");
  EXIT_IF(fid < 0,"Ouverture du groupe HDF 'FAS'",NULL);
  n = 0;
  _MEDnObjets(fid,".",&n);
  EXIT_IF(n < 0,"Lecture du nombre de famille",NULL);

  noeuds = (char *) malloc(n*MED_TAILLE_NOM+1);
  EXIT_IF(noeuds == NULL,NULL,NULL);
  index_noeuds = (int *) malloc(sizeof(int)*(n+1));
  EXIT_IF(index_noeuds == NULL,NULL,NULL);
  elements = (char *) malloc(n*MED_TAILLE_NOM+1);
  EXIT_IF(elements == NULL,NULL,NULL);
  index_elements = (int *) malloc(sizeof(int)*(n+1));
  EXIT_IF(index_elements == NULL,NULL,NULL);
  
  /* On recupere les familles une par une et on les
     normalise */
  for (i=0;i<n;i++) {
    ret = _MEDobjetIdentifier(fid,".",i,nom);
    EXIT_IF(ret < 0,"Identification d'une famille",NULL);

    /* On accede a la famille */
    gid = _MEDdatagroupOuvrir(fid,nom);
    EXIT_IF(gid < 0,"Ouverture de l'accs  la famille",nom);

    /* On lit le numero de la famille */
    ret = _MEDattrEntierLire(gid,(char *)(MED_NOM_NUM),&numero);
    EXIT_IF(ret < 0,"Lecture du numro de la famille",nom);
      
    /* On ferme l'acces a la famille */
    ret = _MEDdatagroupFermer(gid);
    EXIT_IF(ret < 0,"Fermeture de l'accs a la famille",nom);

    if (numero == 0) 
      strcpy(famille0,nom);

    if (numero < 0) {
      if (nelements == 0) { 
	*(index_elements) = 0;
	strcpy(elements,nom);
      }
      else
	strcat(elements,nom);
      nelements ++;
      *(index_elements+nelements) = strlen(nom) + *(index_elements+nelements-1);
    }

    if (numero > 0) {
      if (nnoeuds == 0) {
	strcpy(noeuds,nom);
	*(index_noeuds) = 0;
      }
      else
	strcat(noeuds,nom);
      nnoeuds++;
      *(index_noeuds+nnoeuds) = strlen(nom) + *(index_noeuds+nnoeuds-1);
    }
  }

  /* Normalisation de la famille 0 */
  ret = H5Gmove(fid,famille0,nom_famille_zero);
  EXIT_IF(ret < 0,"Normalisation de la famille ZERO",NULL);

  /* On cree les groupes HDF pour les familles de noeuds et d'elements */
  gid = _MEDdatagroupCreer(fid,groupe_noeuds); 
  EXIT_IF(gid < 0,"Creation du grupe HDF pour les familles de noeuds",NULL); 
  ret = _MEDdatagroupFermer(gid); 
  EXIT_IF(ret < 0,"Fermeture du groupe HDF pour les familles de noeuds",NULL); 
  gid = _MEDdatagroupCreer(fid,groupe_elements); 
  EXIT_IF(gid < 0,"Creation du groupe HDF pour les familles d'lments",NULL); 
  ret = _MEDdatagroupFermer(gid); 
  EXIT_IF(ret < 0,"Fermeture du groupe HDF pour les familles d'lments",NULL); 

  /* On deplace les groupes HDF des familles en fonction de la nature de 
     chaque famille */
  for (i=0;i<nnoeuds;i++) {
    strncpy(nom,noeuds+*(index_noeuds+i),*(index_noeuds+i+1)-*(index_noeuds+i));
    nom[*(index_noeuds+i+1)-*(index_noeuds+i)] = '\0';
    strcpy(stockage,groupe_noeuds);
    strcat(stockage,"/");
    strcat(stockage,nom);
    ret = H5Gmove(fid,nom,stockage); 
    EXIT_IF(ret < 0,"Normalisation de la famille",nom); 
  }

  for (i=0;i<nelements;i++) {
    strncpy(nom,elements+*(index_elements+i),*(index_elements+i+1)-*(index_elements+i));
    nom[*(index_elements+i+1)-*(index_elements+i)] = '\0';
    strcpy(stockage,groupe_elements);
    strcat(stockage,"/"); 
    strcat(stockage,nom);
    ret = H5Gmove(fid,nom,stockage);  
    EXIT_IF(ret < 0,"Normalisation de la famille",nom);  
  }

  /* On libere la memoire */
  free(noeuds);
  free(index_noeuds);
  free(elements);
  free(index_elements);

  /* On ferme tout */
  ret = _MEDdatagroupFermer(fid);
  EXIT_IF(ret < 0,"Fermeture du groupe HDF 'FAS'",NULL);
}
