/*
 *    Copyright (C) 2008
 *
 *    This program is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 3 of the License, or
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package mediathek.daten;

import mediathek.Konstanten;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class DatenFilmUpdate implements Comparable<DatenFilmUpdate> {

    public String[] arr;

    public DatenFilmUpdate() {
        makeArr();
    }

    public DatenFilmUpdate(String url, String prio) {
        makeArr();
        arr[Konstanten.FILM_UPDATE_URL_NR] = url;
        arr[Konstanten.FILM_UPDATE_PRIO_NR] = prio;
    }

    public DatenFilmUpdate(String url, String prio, String zeit, String datum, String anzahl) {
        makeArr();
        arr[Konstanten.FILM_UPDATE_URL_NR] = url;
        arr[Konstanten.FILM_UPDATE_PRIO_NR] = prio;
        arr[Konstanten.FILM_UPDATE_DATUM_NR] = datum;
        arr[Konstanten.FILM_UPDATE_ZEIT_NR] = zeit;
        arr[Konstanten.FILM_UPDATE_ANZAHL_NR] = anzahl;
    }

    public DatenFilmUpdate getCopy() {
        DatenFilmUpdate ret = new DatenFilmUpdate(new String(arr[Konstanten.FILM_UPDATE_URL_NR]), new String(arr[Konstanten.FILM_UPDATE_PRIO_NR]));
        return ret;
    }

    @Override
    public int compareTo(DatenFilmUpdate arg0) {
        int ret = 0;
        try {
            //31.10.2010	16:54:17
            String ich = arr[Konstanten.FILM_UPDATE_DATUM_NR] + ", " + arr[Konstanten.FILM_UPDATE_ZEIT_NR];
            String du = arg0.arr[Konstanten.FILM_UPDATE_DATUM_NR] + ", " + arg0.arr[Konstanten.FILM_UPDATE_ZEIT_NR];
            if (ich.equals(du)) {
                return 0;
            }
            SimpleDateFormat sdf = new SimpleDateFormat("dd.MM.yyyy, HH:mm:ss");
            Date d_ich = sdf.parse(ich);
            Date d_du = sdf.parse(du);
            ret = d_du.compareTo(d_ich);
        } catch (ParseException ex) {
        }
        return ret;
    }

    private void makeArr() {
        arr = new String[Konstanten.FILM_UPDATE_MAX_ELEM];
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = "";
        }
    }
}
