/*
 *    Copyright (C) 2008
 *
 *    This program is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 3 of the License, or
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package mediathek.daten;

import mediathek.Konstanten;

public class DatenPodster implements Comparable<DatenPodster> {

    public String[] arr;

    public DatenPodster() {
        makeArr();
    }

    public DatenPodster(String name, String url, String thema) {
        makeArr();
        arr[Konstanten.PODSTER_TITEL_NR] = name;
        arr[Konstanten.PODSTER_URL_NR] = url;
        arr[Konstanten.PODSTER_THEMA_NR] = thema;
    }

    public DatenPodster copy() {
        DatenPodster ret = new DatenPodster();
        for (int i = 0; i < Konstanten.PODSTER_MAX_ELEM; ++i) {
            ret.arr[i] = this.arr[i];
        }
        return ret;
    }

    public void get(DatenPodster pod) {
        for (int i = 0; i < Konstanten.PODSTER_MAX_ELEM; ++i) {
            arr[i] = pod.arr[i];
        }
    }

    private void makeArr() {
        arr = new String[Konstanten.PODSTER_MAX_ELEM];
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = new String("");
        }
    }

    @Override
    public int compareTo(DatenPodster arg0) {
        return (arr[Konstanten.PODSTER_TITEL_NR].compareToIgnoreCase(((DatenPodster) arg0).arr[Konstanten.PODSTER_TITEL_NR]));
    }

}
