/*
 *    Copyright (C) 2008
 *
 *    This program is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 3 of the License, or
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package mediathek.daten;

import mediathek.Konstanten;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import mediathek.filme.DatenFilm;

public class ListeBlacklist extends LinkedList<DatenBlacklist> {

    Daten daten;

    public ListeBlacklist(Daten ddaten) {
        daten = ddaten;
    }

    @Override
    public boolean add(DatenBlacklist blacklist) {
        boolean ret = super.add(blacklist);
        daten.filmeLaden.checkBlacklist();
        return ret;
    }

    @Override
    public DatenBlacklist remove(int nr) {
        DatenBlacklist blacklist = super.remove(nr);
        daten.filmeLaden.checkBlacklist();
        return blacklist;
    }

    public Object[][] getObjectData() {
        Object[][] object;
        DatenBlacklist blacklist;
        int i = 0;
        ListIterator<DatenBlacklist> iterator = this.listIterator();
        object = new Object[this.size()][Konstanten.BLACKLIST_MAX_ELEM];
        while (iterator.hasNext()) {
            blacklist = iterator.next();
            object[i] = blacklist.arr;
            ++i;
        }
        return object;
    }

    public boolean checkBlackOk(DatenFilm film) {
        // Eintrag suchen, true wenn Film NICHT in der Blacklist ist, also angezeigt wird!!
        // Alte Filme werden auch ausgewertet
        boolean ret = true;
        DatenBlacklist blacklist = null;
        Iterator<DatenBlacklist> it = this.iterator();
        if (this.size() == 0) {
            if (!Boolean.parseBoolean(daten.system[Konstanten.SYSTEM_ALTE_FILME_NR]) && Boolean.parseBoolean(film.arr[Konstanten.FILM_ALT_NR])) {
                ret = false;
            }
        } else {
            while (it.hasNext()) {
                blacklist = it.next();
                if ((blacklist.arr[Konstanten.BLACKLIST_SENDER_NR].equalsIgnoreCase(film.arr[Konstanten.FILM_SENDER_NR]) && blacklist.arr[Konstanten.BLACKLIST_THEMA_NR].equals(""))
                        || (blacklist.arr[Konstanten.BLACKLIST_SENDER_NR].equalsIgnoreCase(film.arr[Konstanten.FILM_SENDER_NR])
                        && !blacklist.arr[Konstanten.BLACKLIST_THEMA_NR].equals("")
                        && blacklist.arr[Konstanten.BLACKLIST_THEMA_NR].equalsIgnoreCase(film.arr[Konstanten.FILM_THEMA_NR]))
                        || (!Boolean.parseBoolean(daten.system[Konstanten.SYSTEM_ALTE_FILME_NR]) && Boolean.parseBoolean(film.arr[Konstanten.FILM_ALT_NR]))) {
                    ret = false;
                    break;
                }
            }
        }
        return ret;
    }
}
