/*
 *    Copyright (C) 2008
 *
 *    This program is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 3 of the License, or
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package mediathek.filme.sender;

import mediathek.Funktionen;
import mediathek.Konstanten;
import mediathek.daten.Daten;
import mediathek.filme.DatenFilm;
import mediathek.io.GetUrl;

/**
 *
 * @author
 */
public class MediathekOrf extends MediathekReader implements Runnable {

    /**
     *
     * @param ddaten
     */
    public MediathekOrf(Daten ddaten) {
        super(ddaten);
        sender = Konstanten.SENDER_ORF;
        text = "ORF (ca. 4 MB, 60 Filme)";
        getUrlIo = new GetUrl(daten, 20000, Konstanten.WARTEN_BASIS_URL);
    }

    @Override
    void addToList() {
        //<option value="http://xxxxxxxxxx.at/programs/1299-a-viso">a.viso</option>
        final String ADRESSE = "http://tvthek.orf.at/programs";
        final String MUSTER_URL1 = "<option value=\"http://";
        final String MUSTER_URL2 = "/programs/";
        listeThemen.clear();
        StringBuffer seite = new StringBuffer();
        seite = getUrlIo.getUri_Utf(sender, ADRESSE, seite, "");
        int pos = 0;
        int pos1 = 0;
        int pos2 = 0;
        String url = "";
        String thema = "";
        //Podcasts auslesen
        while ((pos = seite.indexOf(MUSTER_URL1, pos)) != -1) {
            try {
                pos += MUSTER_URL1.length();
                if ((pos = seite.indexOf(MUSTER_URL2, pos)) != -1) {
                    pos += MUSTER_URL2.length();
                    pos1 = pos;
                    pos2 = seite.indexOf("\"", pos);
                    if (pos1 != -1 && pos2 != -1) {
                        url = seite.substring(pos1, pos2);
                    }
                    pos1 = seite.indexOf(">", pos);
                    pos2 = seite.indexOf("<", pos);
                    if (pos1 != -1 && pos2 != -1 && pos1 < pos2) {
                        thema = seite.substring(pos1 + 1, pos2);
                        if (nurAboLaden()) {
                            //nur Abos laden
                            if (!daten.listeAbo.aboExists(sender, thema)) {
                                continue;
                            }
                        }
                    }
                    if (url.equals("")) {
                        continue;
                    }
                    String[] add = new String[]{"http://tvthek.orf.at/programs/" + url, thema};
                    if (!istInListe(listeThemen, url, 0)) {
                        listeThemen.add(add);
                    }
                }
            } catch (Exception ex) {
                daten.fehler.fehlerMeldung("Fehler!", "Test: kein Thema");
            }
        }
        if (!stop) {
            if (listeThemen.size() > 0) {
                notifyStart(listeThemen.size());
                Funktionen.listeSort(listeThemen, 1);
                for (int t = 0; t < Konstanten.MAX_THREAD_LADEN_FILME_KLEIN; ++t) {
                    new Thread(new OrfThemaLaden()).start();
                }
            }
        }
    }

//    @Override
//    void themaLaden() {
//        new Thread(new OrfThemaLaden()).start();
//
//    }
    private class OrfThemaLaden implements Runnable {

        GetUrl getUrl = new GetUrl(daten, 20000, Konstanten.WARTEN_BASIS_URL_LANG);
        private StringBuffer seite1 = new StringBuffer();

        @Override
        public synchronized void run() {
            addThread();
            String[] link;
            while (!stop && (link = getListeThemen()) != null) {
                try {
                    notifyProgress(link[0]);
                    feedEinerSeiteSuchen(link[0] /*url*/, link[1] /*Thema*/);
                } catch (Exception ex) {
                }
            }
            threadUndFertig();
        }

        void feedEinerSeiteSuchen(String strUrlFeed, String thema) {
            //<param name="URL" value="/programs/1306-Newton/episodes/1229327-Newton/1231597-Signation---Themenuebersicht.asx" />
            //<title> ORF TVthek: a.viso - 28.11.2010 09:05 Uhr</title>

            final String MUSTER = "<param name=\"URL\" value=\"";
            final String MUSTER_SET = "http://tvthek.orf.at";
            final String MUSTER_DATUM_1 = "<title>";
            final String MUSTER_DATUM_2 = "</title>";
            seite1 = getUrl.getUri_Utf(sender, strUrlFeed, seite1, "Thema: " + thema);
            int pos = 0;
            int pos1 = 0;
            int pos2 = 0;
            String url = "";
            String datum = "";
            String zeit = "";
            String tmp = "";
            if ((pos1 = seite1.indexOf(MUSTER_DATUM_1)) != -1) {
                pos1 += MUSTER_DATUM_1.length();
                if ((pos2 = seite1.indexOf(MUSTER_DATUM_2, pos1)) != -1) {
                    tmp = seite1.substring(pos1, pos2);
                    if (tmp.contains("-")) {
                        tmp = tmp.substring(tmp.lastIndexOf("-") + 1).trim();
                        if (tmp.contains(" ")) {
                            datum = tmp.substring(0, tmp.indexOf(" ")).trim();
                            zeit = tmp.substring(tmp.indexOf(" "));
                            zeit = zeit.replace("Uhr", "").trim() + ":00";
                        }
                    }
                }
            }
            if ((pos = seite1.indexOf(MUSTER, pos)) != -1) {
                try {
                    pos += MUSTER.length();
                    pos1 = pos;
                    pos2 = seite1.indexOf("\"", pos);
                    if (pos1 != -1 && pos2 != -1) {
                        url = seite1.substring(pos1, pos2);
                    }
                    if (!url.equals("")) {
                        //DatenFilm(Daten ddaten, String ssender, String tthema, String urlThema, String ttitel, String uurl, String uurlorg, String zziel)
                        daten.filmeLaden.listeFilmeSchattenliste.addSenderRtmp(new DatenFilm(daten, sender, thema, strUrlFeed, thema,
                                MUSTER_SET + url, datum, zeit));
                    }
                } catch (Exception ex) {
                    daten.fehler.fehlerMeldung("Fehler!", "Thema hat keine Links");
                }
            }
        }
    }
}
